/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Config;
import com.github.susom.database.ConfigFromImpl;
import com.github.susom.database.ConfigMissingException;
import com.github.susom.database.ConfigStrings;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImpl
implements Config {
    private static final Logger log = LoggerFactory.getLogger(ConfigFromImpl.class);
    private final ConfigStrings provider;
    private Set<String> failedKeys = new HashSet<String>();

    public ConfigImpl(ConfigStrings provider) {
        this.provider = provider;
    }

    @Override
    public String getString(@Nonnull String key) {
        return this.cleanString(key);
    }

    @Override
    public String getStringOrThrow(@Nonnull String key) {
        return this.nonnull(key, this.getString(key));
    }

    @Override
    @Nonnull
    public String getString(String key, @Nonnull String defaultValue) {
        String stringValue = this.cleanString(key);
        if (stringValue != null) {
            return stringValue;
        }
        if ((defaultValue = defaultValue.trim()).length() == 0) {
            throw new IllegalArgumentException("Your default value is empty or just whitespace");
        }
        return defaultValue;
    }

    @Override
    public Integer getInteger(@Nonnull String key) {
        String stringValue = this.cleanString(key);
        try {
            return stringValue == null ? null : Integer.valueOf(Integer.parseInt(stringValue));
        }
        catch (Exception e) {
            if (!this.failedKeys.contains(key)) {
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
            return null;
        }
    }

    @Override
    public int getInteger(@Nonnull String key, int defaultValue) {
        Integer value = this.getInteger(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public int getIntegerOrThrow(@Nonnull String key) {
        return this.nonnull(key, this.getInteger(key));
    }

    @Override
    @Nullable
    public Long getLong(@Nonnull String key) {
        String stringValue = this.cleanString(key);
        try {
            return stringValue == null ? null : Long.valueOf(Long.parseLong(stringValue));
        }
        catch (Exception e) {
            if (!this.failedKeys.contains(key)) {
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
            return null;
        }
    }

    @Override
    public long getLong(@Nonnull String key, long defaultValue) {
        Long value = this.getLong(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public long getLongOrThrow(@Nonnull String key) {
        return this.nonnull(key, this.getLong(key));
    }

    @Override
    @Nullable
    public Float getFloat(@Nonnull String key) {
        String stringValue = this.cleanString(key);
        try {
            return stringValue == null ? null : Float.valueOf(Float.parseFloat(stringValue));
        }
        catch (Exception e) {
            if (!this.failedKeys.contains(key)) {
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
            return null;
        }
    }

    @Override
    public float getFloat(@Nonnull String key, float defaultValue) {
        Float value = this.getFloat(key);
        return value == null ? defaultValue : value.floatValue();
    }

    @Override
    public float getFloatOrThrow(@Nonnull String key) {
        return this.nonnull(key, this.getFloat(key)).floatValue();
    }

    @Override
    @Nullable
    public Double getDouble(@Nonnull String key) {
        String stringValue = this.cleanString(key);
        try {
            return stringValue == null ? null : Double.valueOf(Double.parseDouble(stringValue));
        }
        catch (Exception e) {
            if (!this.failedKeys.contains(key)) {
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
            return null;
        }
    }

    @Override
    public double getDouble(@Nonnull String key, double defaultValue) {
        Double value = this.getDouble(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public double getDoubleOrThrow(@Nonnull String key) {
        return this.nonnull(key, this.getDouble(key));
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@Nonnull String key) {
        String stringValue = this.cleanString(key);
        try {
            return stringValue == null ? null : new BigDecimal(stringValue);
        }
        catch (Exception e) {
            if (!this.failedKeys.contains(key)) {
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
            return null;
        }
    }

    @Override
    @Nonnull
    public BigDecimal getBigDecimal(String key, @Nonnull BigDecimal defaultValue) {
        BigDecimal value = this.getBigDecimal(key);
        return value == null ? defaultValue : value;
    }

    @Override
    @Nonnull
    public BigDecimal getBigDecimalOrThrow(String key) {
        return this.nonnull(key, this.getBigDecimal(key));
    }

    @Override
    public boolean getBooleanOrFalse(@Nonnull String key) {
        return this.parseBoolean(this.cleanString(key), false);
    }

    @Override
    public boolean getBooleanOrTrue(@Nonnull String key) {
        return this.parseBoolean(this.cleanString(key), true);
    }

    @Override
    public boolean getBooleanOrThrow(@Nonnull String key) {
        String value = this.nonnull(key, this.cleanString(key));
        if ((value = value.toLowerCase()).equals("yes") || value.equals("true")) {
            return true;
        }
        if (value.equals("no") || value.equals("false")) {
            return false;
        }
        throw new ConfigMissingException("Unrecognized boolean value for config key: " + key);
    }

    private <T> T nonnull(String key, T value) {
        if (value == null) {
            throw new ConfigMissingException("No value for config key: " + key);
        }
        return value;
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (value != null) {
            if ((value = value.toLowerCase()).equals("yes") || value.equals("true")) {
                return true;
            }
            if (value.equals("no") || value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }

    private String cleanString(String key) {
        String value;
        block3: {
            value = null;
            try {
                value = this.provider.get(key);
                if (value != null && (value = value.trim()).length() == 0) {
                    value = null;
                }
            }
            catch (Exception e) {
                if (this.failedKeys.contains(key)) break block3;
                log.warn("Could not load config value for key (this message will only be logged once): " + key, (Throwable)e);
                this.failedKeys.add(key);
            }
        }
        return value;
    }
}

