/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.DatabaseMock;
import com.github.susom.database.Ddl;
import com.github.susom.database.DdlImpl;
import com.github.susom.database.Flavor;
import com.github.susom.database.Options;
import com.github.susom.database.OptionsDefault;
import com.github.susom.database.Sql;
import com.github.susom.database.SqlInsert;
import com.github.susom.database.SqlInsertImpl;
import com.github.susom.database.SqlSelect;
import com.github.susom.database.SqlSelectImpl;
import com.github.susom.database.SqlUpdate;
import com.github.susom.database.SqlUpdateImpl;
import com.github.susom.database.When;
import java.sql.Connection;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseImpl
implements Database {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final Connection connection;
    private final DatabaseMock mock;
    private final Options options;

    public DatabaseImpl(@Nonnull Connection connection, @Nonnull Options options) {
        this.connection = connection;
        this.mock = null;
        this.options = options;
    }

    public DatabaseImpl(@Nonnull DatabaseMock mock, Flavor flavor) {
        this(mock, (Options)new OptionsDefault(flavor));
    }

    public DatabaseImpl(@Nonnull DatabaseMock mock, @Nonnull Options options) {
        this.connection = null;
        this.mock = mock;
        this.options = options;
    }

    @Override
    @Nonnull
    public DatabaseImpl get() {
        return this;
    }

    @Override
    @Nonnull
    public SqlInsert toInsert(@Nonnull String sql) {
        return new SqlInsertImpl(this.connection, this.mock, sql, this.options);
    }

    @Override
    @Nonnull
    public SqlInsert toInsert(@Nonnull Sql sql) {
        return new SqlInsertImpl(this.connection, this.mock, sql.sql(), this.options).apply(sql);
    }

    @Override
    @Nonnull
    public SqlSelect toSelect(@Nonnull String sql) {
        return new SqlSelectImpl(this.connection, this.mock, sql, this.options);
    }

    @Override
    @Nonnull
    public SqlSelect toSelect(@Nonnull Sql sql) {
        return new SqlSelectImpl(this.connection, this.mock, sql.sql(), this.options).apply(sql);
    }

    @Override
    @Nonnull
    public SqlUpdate toUpdate(@Nonnull String sql) {
        return new SqlUpdateImpl(this.connection, this.mock, sql, this.options);
    }

    @Override
    @Nonnull
    public SqlUpdate toUpdate(@Nonnull Sql sql) {
        return new SqlUpdateImpl(this.connection, this.mock, sql.sql(), this.options).apply(sql);
    }

    @Override
    @Nonnull
    public SqlUpdate toDelete(@Nonnull String sql) {
        return new SqlUpdateImpl(this.connection, this.mock, sql, this.options);
    }

    @Override
    @Nonnull
    public SqlUpdate toDelete(@Nonnull Sql sql) {
        return new SqlUpdateImpl(this.connection, this.mock, sql.sql(), this.options).apply(sql);
    }

    @Override
    @Nonnull
    public Ddl ddl(@Nonnull String sql) {
        return new DdlImpl(this.connection, sql, this.options);
    }

    @Override
    public Long nextSequenceValue(@Nonnull String sequenceName) {
        return this.toSelect(this.flavor().sequenceSelectNextVal(sequenceName)).queryLongOrNull();
    }

    @Override
    public Date nowPerApp() {
        return this.options.currentDate();
    }

    @Override
    public void commitNow() {
        if (this.options.ignoreTransactionControl()) {
            log.debug("Ignoring call to commitNow()");
            return;
        }
        if (!this.options.allowTransactionControl()) {
            throw new DatabaseException("Calls to commitNow() are not allowed");
        }
        try {
            this.connection.commit();
        }
        catch (Exception e) {
            throw new DatabaseException("Unable to commit transaction", e);
        }
    }

    @Override
    public void rollbackNow() {
        if (this.options.ignoreTransactionControl()) {
            log.debug("Ignoring call to rollbackNow()");
            return;
        }
        if (!this.options.allowTransactionControl()) {
            throw new DatabaseException("Calls to rollbackNow() are not allowed");
        }
        try {
            this.connection.rollback();
        }
        catch (Exception e) {
            throw new DatabaseException("Unable to rollback transaction", e);
        }
    }

    @Override
    @Nonnull
    public Connection underlyingConnection() {
        if (!this.options.allowConnectionAccess()) {
            throw new DatabaseException("Calls to underlyingConnection() are not allowed");
        }
        return this.connection;
    }

    @Override
    @Nonnull
    public Options options() {
        return this.options;
    }

    @Override
    @Nonnull
    public Flavor flavor() {
        return this.options.flavor();
    }

    @Override
    @Nonnull
    public When when() {
        return new When(this.options.flavor());
    }

    @Override
    public void dropSequenceQuietly(@Nonnull String sequenceName) {
        this.ddl(this.flavor().sequenceDrop(sequenceName)).executeQuietly();
    }

    @Override
    public void dropTableQuietly(@Nonnull String tableName) {
        if (this.flavor() == Flavor.postgresql || this.flavor() == Flavor.hsqldb) {
            this.ddl("drop table if exists " + tableName).executeQuietly();
        } else {
            this.ddl("drop table " + tableName).executeQuietly();
        }
    }

    @Override
    public void assertTimeSynchronized(long millisToWarn, long millisToError) {
        this.toSelect("select ?" + this.flavor().fromAny()).argDateNowPerDb().queryFirstOrNull(r -> {
            Date appDate = this.nowPerApp();
            Date dbDate = r.getDateOrNull();
            if (dbDate == null) {
                throw new DatabaseException("Expecting a date in the result");
            }
            if (Math.abs(appDate.getTime() - dbDate.getTime()) > 3600000L) {
                throw new DatabaseException("App and db time are over an hour apart (check your timezones) app: " + DateTimeFormatter.ISO_INSTANT.format(appDate.toInstant()) + " db: " + DateTimeFormatter.ISO_INSTANT.format(dbDate.toInstant()));
            }
            if (Math.abs(appDate.getTime() - dbDate.getTime()) > millisToError) {
                throw new DatabaseException("App and db time over " + millisToError + " millis apart (check your clocks) app: " + DateTimeFormatter.ISO_INSTANT.format(appDate.toInstant()) + " db: " + DateTimeFormatter.ISO_INSTANT.format(dbDate.toInstant()));
            }
            if (Math.abs(appDate.getTime() - dbDate.getTime()) > millisToWarn) {
                log.warn("App and db time are over " + millisToWarn + " millis apart (check your clocks) app: " + DateTimeFormatter.ISO_INSTANT.format(appDate.toInstant()) + " db: " + DateTimeFormatter.ISO_INSTANT.format(dbDate.toInstant()));
            }
            return null;
        });
    }

    @Override
    public void assertTimeSynchronized() {
        this.assertTimeSynchronized(10000L, 30000L);
    }
}

