/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Config;
import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.DatabaseImpl;
import com.github.susom.database.DatabaseProvider;
import com.github.susom.database.DbCode;
import com.github.susom.database.DbCodeTx;
import com.github.susom.database.DbCodeTyped;
import com.github.susom.database.DbCodeTypedTx;
import com.github.susom.database.Metric;
import com.github.susom.database.Options;
import com.github.susom.database.OptionsDefault;
import com.github.susom.database.OptionsOverride;
import com.github.susom.database.TransactionImpl;
import com.github.susom.database.VertxUtil;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseProviderVertx
implements Supplier<Database> {
    private static final Logger log = LoggerFactory.getLogger(DatabaseProviderVertx.class);
    private DatabaseProviderVertx delegateTo = null;
    private Vertx vertx;
    private Provider<Connection> connectionProvider;
    private boolean txStarted = false;
    private Connection connection = null;
    private Database database = null;
    private final Options options;

    public DatabaseProviderVertx(Vertx vertx, Provider<Connection> connectionProvider, Options options) {
        if (vertx == null) {
            throw new IllegalArgumentException("Vertx cannot be null");
        }
        if (connectionProvider == null) {
            throw new IllegalArgumentException("Connection provider cannot be null");
        }
        this.vertx = vertx;
        this.connectionProvider = connectionProvider;
        this.options = options;
    }

    private DatabaseProviderVertx(DatabaseProviderVertx delegateTo) {
        this.delegateTo = delegateTo;
        this.vertx = delegateTo.vertx;
        this.options = delegateTo.options;
    }

    @CheckReturnValue
    public static Builder pooledBuilder(Vertx vertx, Config config) {
        return DatabaseProviderVertx.fromPool(vertx, DatabaseProvider.createPool(config));
    }

    @CheckReturnValue
    public static Builder fromPool(Vertx vertx, DatabaseProvider.Pool pool) {
        return new BuilderImpl(vertx, pool.poolShutdown, () -> {
            try {
                return pool.dataSource.getConnection();
            }
            catch (Exception e) {
                throw new DatabaseException("Unable to obtain a connection from DriverManager", e);
            }
        }, new OptionsDefault(pool.flavor));
    }

    public void transact(DbCode code) {
        if (Context.isOnEventLoopThread()) {
            throw new DatabaseException("Do not call transact() from event loop threads; use transactAsync() instead");
        }
        boolean complete = false;
        try {
            code.run(this);
            complete = true;
        }
        catch (DatabaseException | ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            throw new DatabaseException("Error during transaction", t);
        }
        finally {
            if (!complete) {
                this.rollbackAndClose();
            } else {
                this.commitAndClose();
            }
        }
    }

    public <T> void transactAsync(DbCodeTyped<T> code, Handler<AsyncResult<T>> resultHandler) {
        VertxUtil.executeBlocking(this.vertx, future -> {
            try {
                Object returnValue = null;
                boolean complete = false;
                try {
                    returnValue = code.run(this);
                    complete = true;
                }
                catch (DatabaseException | ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new DatabaseException("Error during transaction", t);
                }
                finally {
                    if (!complete) {
                        this.rollbackAndClose();
                    } else {
                        this.commitAndClose();
                    }
                }
                future.complete(returnValue);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                future.fail(t);
            }
        }, resultHandler);
    }

    public void transact(DbCodeTx code) {
        if (Context.isOnEventLoopThread()) {
            throw new DatabaseException("Do not call transact() from event loop threads; use transactAsync() instead");
        }
        TransactionImpl tx = new TransactionImpl();
        tx.setRollbackOnError(true);
        tx.setRollbackOnly(false);
        boolean complete = false;
        try {
            code.run(this, tx);
            complete = true;
        }
        catch (DatabaseException | ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            throw new DatabaseException("Error during transaction", t);
        }
        finally {
            if (!complete && tx.isRollbackOnError() || tx.isRollbackOnly()) {
                this.rollbackAndClose();
            } else {
                this.commitAndClose();
            }
        }
    }

    public <T> void transactAsync(DbCodeTypedTx<T> code, Handler<AsyncResult<T>> resultHandler) {
        VertxUtil.executeBlocking(this.vertx, future -> {
            try {
                Object returnValue = null;
                TransactionImpl tx = new TransactionImpl();
                tx.setRollbackOnError(true);
                tx.setRollbackOnly(false);
                boolean complete = false;
                try {
                    returnValue = code.run(this, tx);
                    complete = true;
                }
                catch (DatabaseException | ThreadDeath t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw new DatabaseException("Error during transaction", t);
                }
                finally {
                    if (!complete && tx.isRollbackOnError() || tx.isRollbackOnly()) {
                        this.rollbackAndClose();
                    } else {
                        this.commitAndClose();
                    }
                }
                future.complete(returnValue);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                future.fail(t);
            }
        }, resultHandler);
    }

    @Override
    public Database get() {
        if (this.delegateTo != null) {
            return this.delegateTo.get();
        }
        if (this.database != null) {
            return this.database;
        }
        if (this.connectionProvider == null) {
            throw new DatabaseException("Called get() on a DatabaseProviderVertx after close()");
        }
        Metric metric = new Metric(log.isDebugEnabled());
        try {
            this.connection = (Connection)this.connectionProvider.get();
            this.txStarted = true;
            metric.checkpoint("getConn", new Object[0]);
            try {
                this.connection.setAutoCommit(false);
                metric.checkpoint("setAutoCommit", new Object[0]);
            }
            catch (SQLException e) {
                throw new DatabaseException("Unable to check/set autoCommit for the connection", e);
            }
            this.database = new DatabaseImpl(this.connection, this.options);
            metric.checkpoint("dbInit", new Object[0]);
        }
        catch (RuntimeException e) {
            metric.checkpoint("fail", new Object[0]);
            throw e;
        }
        finally {
            metric.done();
            if (log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder("Get ").append((Object)this.options.flavor()).append(" database: ");
                metric.printMessage(buf);
                log.debug(buf.toString());
            }
        }
        return this.database;
    }

    public Builder fakeBuilder() {
        return new Builder(){

            @Override
            public Builder withOptions(OptionsOverride optionsOverride) {
                return this;
            }

            @Override
            public Builder withSqlParameterLogging() {
                return this;
            }

            @Override
            public Builder withSqlInExceptionMessages() {
                return this;
            }

            @Override
            public Builder withDatePerAppOnly() {
                return this;
            }

            @Override
            public Builder withTransactionControl() {
                return this;
            }

            @Override
            public Builder withTransactionControlSilentlyIgnored() {
                return this;
            }

            @Override
            public Builder withConnectionAccess() {
                return this;
            }

            @Override
            public DatabaseProviderVertx create() {
                return new DatabaseProviderVertx(DatabaseProviderVertx.this);
            }

            @Override
            public void transact(DbCode tx) {
                this.create().transact(tx);
            }

            @Override
            public <T> void transactAsync(DbCodeTyped<T> code, Handler<AsyncResult<T>> resultHandler) {
                this.create().transactAsync(code, resultHandler);
            }

            @Override
            public void transact(DbCodeTx tx) {
                this.create().transact(tx);
            }

            @Override
            public <T> void transactAsync(DbCodeTypedTx<T> code, Handler<AsyncResult<T>> resultHandler) {
                this.create().transactAsync(code, resultHandler);
            }

            @Override
            public void close() {
                log.debug("Ignoring close call on fakeBuilder");
            }
        };
    }

    public void commitAndClose() {
        if (this.delegateTo != null) {
            log.debug("Ignoring commitAndClose() because this is a fake provider");
            return;
        }
        if (this.txStarted) {
            try {
                this.connection.commit();
            }
            catch (Exception e) {
                throw new DatabaseException("Unable to commit the transaction", e);
            }
            this.close();
        }
    }

    public void rollbackAndClose() {
        if (this.delegateTo != null) {
            log.debug("Ignoring rollbackAndClose() because this is a fake provider");
            return;
        }
        if (this.txStarted) {
            try {
                this.connection.rollback();
            }
            catch (Exception e) {
                log.error("Unable to rollback the transaction", (Throwable)e);
            }
            this.close();
        }
    }

    private void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            log.error("Unable to close the database connection", (Throwable)e);
        }
        this.connection = null;
        this.database = null;
        this.txStarted = false;
        this.connectionProvider = null;
    }

    private static class BuilderImpl
    implements Builder {
        private final Vertx vertx;
        private Closeable pool;
        private final Provider<Connection> connectionProvider;
        private final Options options;

        private BuilderImpl(Vertx vertx, Closeable pool, Provider<Connection> connectionProvider, Options options) {
            this.vertx = vertx;
            this.pool = pool;
            this.connectionProvider = connectionProvider;
            this.options = options;
        }

        @Override
        public Builder withOptions(OptionsOverride options) {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, options.withParent(this.options));
        }

        @Override
        public Builder withSqlParameterLogging() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean isLogParameters() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public Builder withSqlInExceptionMessages() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean isDetailedExceptions() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public Builder withDatePerAppOnly() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean useDatePerAppOnly() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public Builder withTransactionControl() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean allowTransactionControl() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public Builder withTransactionControlSilentlyIgnored() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean ignoreTransactionControl() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public Builder withConnectionAccess() {
            return new BuilderImpl(this.vertx, this.pool, this.connectionProvider, new OptionsOverride(){

                @Override
                public boolean allowConnectionAccess() {
                    return true;
                }
            }.withParent(this.options));
        }

        @Override
        public DatabaseProviderVertx create() {
            return new DatabaseProviderVertx(this.vertx, this.connectionProvider, this.options);
        }

        @Override
        public void transact(DbCode tx) {
            this.create().transact(tx);
        }

        @Override
        public <T> void transactAsync(DbCodeTyped<T> code, Handler<AsyncResult<T>> resultHandler) {
            this.create().transactAsync(code, resultHandler);
        }

        @Override
        public void transact(DbCodeTx tx) {
            this.create().transact(tx);
        }

        @Override
        public <T> void transactAsync(DbCodeTypedTx<T> code, Handler<AsyncResult<T>> resultHandler) {
            this.create().transactAsync(code, resultHandler);
        }

        @Override
        public void close() {
            if (this.pool != null) {
                try {
                    this.pool.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close connection pool", (Throwable)e);
                }
                this.pool = null;
            }
        }
    }

    public static interface Builder {
        @CheckReturnValue
        public Builder withOptions(OptionsOverride var1);

        @CheckReturnValue
        public Builder withSqlParameterLogging();

        @CheckReturnValue
        public Builder withSqlInExceptionMessages();

        @CheckReturnValue
        public Builder withDatePerAppOnly();

        @CheckReturnValue
        public Builder withTransactionControl();

        @CheckReturnValue
        public Builder withTransactionControlSilentlyIgnored();

        @CheckReturnValue
        public Builder withConnectionAccess();

        @CheckReturnValue
        public DatabaseProviderVertx create();

        public void transact(DbCode var1);

        public <T> void transactAsync(DbCodeTyped<T> var1, Handler<AsyncResult<T>> var2);

        public void transact(DbCodeTx var1);

        public <T> void transactAsync(DbCodeTypedTx<T> var1, Handler<AsyncResult<T>> var2);

        public void close();
    }
}

