/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.Ddl;
import com.github.susom.database.DebugSql;
import com.github.susom.database.Metric;
import com.github.susom.database.Options;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlImpl
implements Ddl {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private static final Logger logQuiet = LoggerFactory.getLogger((String)(Database.class.getName() + ".Quiet"));
    private final Connection connection;
    private final String sql;
    private final Options options;

    public DdlImpl(Connection connection, String sql, Options options) {
        this.connection = connection;
        this.sql = sql;
        this.options = options;
    }

    private void updateInternal(boolean quiet) {
        CallableStatement ps = null;
        Metric metric = new Metric(log.isDebugEnabled());
        boolean isSuccess = false;
        String errorCode = null;
        Exception logEx = null;
        try {
            ps = this.connection.prepareCall(this.sql);
            metric.checkpoint("prep", new Object[0]);
            ps.execute();
            metric.checkpoint("exec", new Object[0]);
            isSuccess = true;
            this.close(ps);
            metric.checkpoint("close", new Object[0]);
            this.commit(this.connection);
            metric.done("commit", new Object[0]);
        }
        catch (Exception e) {
            try {
                errorCode = this.options.generateErrorCode();
                logEx = e;
                throw DatabaseException.wrap(DebugSql.exceptionMessage(this.sql, null, errorCode, this.options), e);
            }
            catch (Throwable throwable) {
                this.close(ps);
                metric.checkpoint("close", new Object[0]);
                this.commit(this.connection);
                metric.done("commit", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("DDL", log, metric, this.sql, null, this.options);
                } else if (quiet) {
                    DebugSql.logWarning("DDL", logQuiet, metric, errorCode, this.sql, null, this.options, logEx);
                } else {
                    DebugSql.logError("DDL", log, metric, errorCode, this.sql, null, this.options, logEx);
                }
                throw throwable;
            }
        }
        if (isSuccess) {
            DebugSql.logSuccess("DDL", log, metric, this.sql, null, this.options);
        } else if (quiet) {
            DebugSql.logWarning("DDL", logQuiet, metric, errorCode, this.sql, null, this.options, logEx);
        } else {
            DebugSql.logError("DDL", log, metric, errorCode, this.sql, null, this.options, logEx);
        }
    }

    @Override
    public void execute() {
        this.updateInternal(false);
    }

    @Override
    public void executeQuietly() {
        try {
            this.updateInternal(true);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    private void close(Statement s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (Exception e) {
                log.warn("Caught exception closing the Statement", (Throwable)e);
            }
        }
    }

    private void commit(Connection c) {
        if (c != null) {
            try {
                c.commit();
            }
            catch (Exception e) {
                log.warn("Caught exception on commit", (Throwable)e);
            }
        }
    }
}

