/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Metric;
import com.github.susom.database.MixedParameterSql;
import com.github.susom.database.Options;
import com.github.susom.database.StatementAdaptor;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;

public class DebugSql {
    public static final String PARAM_SQL_SEPARATOR = "\tParamSql:\t";

    public static String printDebugOnlySqlString(String sql, Object[] args, Options options) {
        StringBuilder buf = new StringBuilder();
        DebugSql.printSql(buf, sql, args, false, true, options);
        return buf.toString();
    }

    public static void printSql(StringBuilder buf, String sql, Object[] args, Options options) {
        DebugSql.printSql(buf, sql, args, true, options.isLogParameters(), options);
    }

    public static void printSql(StringBuilder buf, String sql, Object[] args, boolean includeExecSql, boolean includeParameters, Options options) {
        String[] sqlParts;
        Object[] argsToPrint = args;
        if (argsToPrint == null) {
            argsToPrint = new Object[]{};
        }
        int batchSize = -1;
        if (argsToPrint.length > 0 && argsToPrint instanceof Object[][]) {
            batchSize = argsToPrint.length;
            argsToPrint = (Object[])argsToPrint[0];
        }
        if ((sqlParts = sql.split("\\?")).length != argsToPrint.length + (sql.endsWith("?") ? 0 : 1)) {
            buf.append("(wrong # args) query: ");
            buf.append(sql);
            if (args != null) {
                buf.append(" args: ");
                if (includeParameters) {
                    buf.append(Arrays.toString(argsToPrint));
                } else {
                    buf.append(argsToPrint.length);
                }
            }
        } else {
            if (includeExecSql) {
                buf.append(DebugSql.removeTabs(sql));
            }
            if (includeParameters && argsToPrint.length > 0) {
                if (includeExecSql) {
                    buf.append(PARAM_SQL_SEPARATOR);
                }
                for (int i = 0; i < argsToPrint.length; ++i) {
                    buf.append(DebugSql.removeTabs(sqlParts[i]));
                    Object argToPrint = argsToPrint[i];
                    if (argToPrint instanceof String) {
                        String argToPrintString = (String)argToPrint;
                        int maxLength = options.maxStringLengthParam();
                        if (argToPrintString.length() > maxLength && maxLength > 0) {
                            buf.append("'").append(argToPrintString.substring(0, maxLength)).append("...'");
                            continue;
                        }
                        buf.append("'");
                        buf.append(DebugSql.removeTabs(DebugSql.escapeSingleQuoted(argToPrintString)));
                        buf.append("'");
                        continue;
                    }
                    if (argToPrint instanceof StatementAdaptor.SqlNull || argToPrint == null) {
                        buf.append("null");
                        continue;
                    }
                    if (argToPrint instanceof Date) {
                        buf.append(options.flavor().dateAsSqlFunction((Date)argToPrint, options.calendarForTimestamps()));
                        continue;
                    }
                    if (argToPrint instanceof Number) {
                        buf.append(argToPrint);
                        continue;
                    }
                    if (argToPrint instanceof Boolean) {
                        buf.append((Boolean)argToPrint != false ? "'Y'" : "'N'");
                        continue;
                    }
                    if (argToPrint instanceof MixedParameterSql.SecretArg) {
                        buf.append("<secret>");
                        continue;
                    }
                    if (argToPrint instanceof Reader || argToPrint instanceof InputStream) {
                        buf.append("<").append(argToPrint.getClass().getName()).append(">");
                        continue;
                    }
                    if (argToPrint instanceof byte[]) {
                        buf.append("<").append(((byte[])argToPrint).length).append(" bytes>");
                        continue;
                    }
                    buf.append("<unknown:").append(argToPrint.getClass().getName()).append(">");
                }
                if (sqlParts.length > argsToPrint.length) {
                    buf.append(sqlParts[sqlParts.length - 1]);
                }
            }
        }
        if (batchSize != -1) {
            buf.append(" (first in batch of ");
            buf.append(batchSize);
            buf.append(')');
        }
    }

    private static String removeTabs(String s) {
        return s == null ? null : s.replace("\t", "<tab>");
    }

    private static String escapeSingleQuoted(String s) {
        return s == null ? null : s.replace("'", "''");
    }

    public static String exceptionMessage(String sql, Object[] parameters, String errorCode, Options options) {
        StringBuilder buf = new StringBuilder("Error executing SQL");
        if (errorCode != null) {
            buf.append(" (errorCode=").append(errorCode).append(")");
        }
        if (options.isDetailedExceptions()) {
            buf.append(": ");
            DebugSql.printSql(buf, sql, parameters, options);
        }
        return buf.toString();
    }

    public static void logSuccess(String sqlType, Logger log, Metric metric, String sql, Object[] args, Options options) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append(sqlType).append(": ");
            metric.printMessage(buf);
            buf.append('\t');
            DebugSql.printSql(buf, sql, args, options);
            log.debug(buf.toString());
        }
    }

    public static void logWarning(String sqlType, Logger log, Metric metric, String errorCode, String sql, Object[] args, Options options, Throwable t) {
        if (log.isWarnEnabled()) {
            StringBuilder buf = new StringBuilder();
            if (errorCode != null) {
                buf.append("errorCode=").append(errorCode).append(" ");
            }
            buf.append(sqlType).append(": ");
            metric.printMessage(buf);
            buf.append(" ");
            DebugSql.printSql(buf, sql, args, options);
            log.warn(buf.toString(), t);
        }
    }

    public static void logError(String sqlType, Logger log, Metric metric, String errorCode, String sql, Object[] args, Options options, Throwable t) {
        if (log.isErrorEnabled()) {
            StringBuilder buf = new StringBuilder();
            if (errorCode != null) {
                buf.append("errorCode=").append(errorCode).append(" ");
            }
            buf.append(sqlType).append(": ");
            metric.printMessage(buf);
            buf.append(" ");
            DebugSql.printSql(buf, sql, args, options);
            log.error(buf.toString(), t);
        }
    }
}

