/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public enum Flavor {
    derby{

        @Override
        public String typeInteger() {
            return "integer";
        }

        @Override
        public String typeBoolean() {
            return "char(1)";
        }

        @Override
        public String typeLong() {
            return "bigint";
        }

        @Override
        public String typeFloat() {
            return "real";
        }

        @Override
        public String typeDouble() {
            return "double";
        }

        @Override
        public String typeBigDecimal(int size, int precision) {
            return "numeric(" + size + "," + precision + ")";
        }

        @Override
        public String typeStringVar(int bytes) {
            return "varchar(" + bytes + ")";
        }

        @Override
        public String typeStringFixed(int bytes) {
            return "char(" + bytes + ")";
        }

        @Override
        public String typeClob() {
            return "clob";
        }

        @Override
        public String typeBlob() {
            return "blob";
        }

        @Override
        public String typeDate() {
            return "timestamp";
        }

        @Override
        public boolean useStringForClob() {
            return false;
        }

        @Override
        public boolean useBytesForBlob() {
            return false;
        }

        @Override
        public String sequenceNextVal(String sequenceName) {
            return "next value for " + sequenceName;
        }

        @Override
        public String sequenceSelectNextVal(String sequenceName) {
            return "values next value for " + sequenceName;
        }

        @Override
        public String sequenceDrop(String dbtestSeq) {
            return "drop sequence " + dbtestSeq + " restrict";
        }

        @Override
        public boolean supportsInsertReturning() {
            return false;
        }

        @Override
        public String sequenceCacheClause(int nbrValuesToCache) {
            return "";
        }

        @Override
        public String sequenceOrderClause(boolean order) {
            return "";
        }

        @Override
        public String sequenceCycleClause(boolean cycle) {
            return cycle ? " cycle" : " no cycle";
        }

        @Override
        public String dbTimeMillis() {
            return "current_timestamp";
        }

        @Override
        public String fromAny() {
            return " from sysibm.sysdummy1";
        }

        @Override
        public String dateAsSqlFunction(Date date, Calendar calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000");
            dateFormat.setCalendar(calendar);
            return "timestamp('" + dateFormat.format(date) + "')";
        }

        @Override
        public String sequenceOptions() {
            return " as bigint";
        }
    }
    ,
    sqlserver{

        @Override
        public String typeFloat() {
            return "float(24)";
        }

        @Override
        public String typeDouble() {
            return "float(53)";
        }

        @Override
        public String typeBigDecimal(int size, int precision) {
            return "numeric(" + size + "," + precision + ")";
        }

        @Override
        public String typeInteger() {
            return "numeric(10)";
        }

        @Override
        public String typeBoolean() {
            return "char(1)";
        }

        @Override
        public String typeLong() {
            return "numeric(19)";
        }

        @Override
        public String typeDate() {
            return "datetime2(3)";
        }

        @Override
        public boolean useStringForClob() {
            return false;
        }

        @Override
        public boolean useBytesForBlob() {
            return false;
        }

        @Override
        public String sequenceNextVal(String sequenceName) {
            return "next value for " + sequenceName;
        }

        @Override
        public String sequenceSelectNextVal(String sequenceName) {
            return "select next value for " + sequenceName;
        }

        @Override
        public String sequenceDrop(String dbtestSeq) {
            return "drop sequence " + dbtestSeq;
        }

        @Override
        public String typeStringVar(int bytes) {
            return "varchar(" + bytes + ")";
        }

        @Override
        public String typeStringFixed(int bytes) {
            return "char(" + bytes + ")";
        }

        @Override
        public String typeClob() {
            return "varchar(max)";
        }

        @Override
        public String typeBlob() {
            return "varbinary(max)";
        }

        @Override
        public String sequenceOrderClause(boolean order) {
            return "";
        }

        @Override
        public String sequenceCycleClause(boolean cycle) {
            return cycle ? " cycle" : " no cycle";
        }

        @Override
        public boolean supportsInsertReturning() {
            return false;
        }

        @Override
        public String dbTimeMillis() {
            return "current_timestamp";
        }

        @Override
        public String sequenceCacheClause(int nbrValuesToCache) {
            return " cache " + nbrValuesToCache;
        }

        @Override
        public String fromAny() {
            return "";
        }

        @Override
        public String dateAsSqlFunction(Date date, Calendar calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000");
            dateFormat.setCalendar(calendar);
            return "cast('" + dateFormat.format(date) + "' as datetime2(3))";
        }

        @Override
        public String sequenceOptions() {
            return "";
        }
    }
    ,
    oracle{

        @Override
        public String typeFloat() {
            return "binary_float";
        }

        @Override
        public String typeDouble() {
            return "binary_double";
        }

        @Override
        public String typeBigDecimal(int size, int precision) {
            return "numeric(" + size + "," + precision + ")";
        }

        @Override
        public String typeInteger() {
            return "numeric(10)";
        }

        @Override
        public String typeBoolean() {
            return "char(1)";
        }

        @Override
        public String typeLong() {
            return "numeric(19)";
        }

        @Override
        public String typeDate() {
            return "timestamp(3)";
        }

        @Override
        public boolean useStringForClob() {
            return false;
        }

        @Override
        public boolean useBytesForBlob() {
            return false;
        }

        @Override
        public String sequenceNextVal(String sequenceName) {
            return sequenceName + ".nextval";
        }

        @Override
        public String sequenceSelectNextVal(String sequenceName) {
            return "select " + sequenceName + ".nextval from dual";
        }

        @Override
        public String sequenceDrop(String dbtestSeq) {
            return "drop sequence " + dbtestSeq;
        }

        @Override
        public String typeStringVar(int bytes) {
            return "varchar2(" + bytes + ")";
        }

        @Override
        public String typeStringFixed(int bytes) {
            return "char(" + bytes + ")";
        }

        @Override
        public String typeClob() {
            return "clob";
        }

        @Override
        public String typeBlob() {
            return "blob";
        }

        @Override
        public String sequenceOrderClause(boolean order) {
            return order ? " order" : " noorder";
        }

        @Override
        public String sequenceCycleClause(boolean cycle) {
            return cycle ? " cycle" : " nocycle";
        }

        @Override
        public boolean supportsInsertReturning() {
            return true;
        }

        @Override
        public String dbTimeMillis() {
            return "systimestamp(3)";
        }

        @Override
        public String sequenceCacheClause(int nbrValuesToCache) {
            return " cache " + nbrValuesToCache;
        }

        @Override
        public String fromAny() {
            return " from dual";
        }

        @Override
        public String dateAsSqlFunction(Date date, Calendar calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000");
            dateFormat.setCalendar(calendar);
            return "timestamp '" + dateFormat.format(date) + "'";
        }

        @Override
        public String sequenceOptions() {
            return "";
        }
    }
    ,
    postgresql{

        @Override
        public String typeInteger() {
            return "integer";
        }

        @Override
        public String typeBoolean() {
            return "char(1)";
        }

        @Override
        public String typeLong() {
            return "bigint";
        }

        @Override
        public String typeFloat() {
            return "real";
        }

        @Override
        public String typeDouble() {
            return "double precision";
        }

        @Override
        public String typeBigDecimal(int size, int precision) {
            return "numeric(" + size + "," + precision + ")";
        }

        @Override
        public String typeStringVar(int bytes) {
            return "varchar(" + bytes + ")";
        }

        @Override
        public String typeStringFixed(int bytes) {
            return "char(" + bytes + ")";
        }

        @Override
        public String typeClob() {
            return "text";
        }

        @Override
        public String typeBlob() {
            return "bytea";
        }

        @Override
        public String typeDate() {
            return "timestamp(3)";
        }

        @Override
        public boolean useStringForClob() {
            return true;
        }

        @Override
        public boolean useBytesForBlob() {
            return true;
        }

        @Override
        public String sequenceNextVal(String sequenceName) {
            return "nextval('" + sequenceName + "')";
        }

        @Override
        public String sequenceSelectNextVal(String sequenceName) {
            return "select nextval('" + sequenceName + "')";
        }

        @Override
        public String sequenceDrop(String dbtestSeq) {
            return "drop sequence " + dbtestSeq;
        }

        @Override
        public String sequenceOrderClause(boolean order) {
            return "";
        }

        @Override
        public String sequenceCycleClause(boolean cycle) {
            return cycle ? " cycle" : " no cycle";
        }

        @Override
        public String fromAny() {
            return "";
        }

        @Override
        public boolean supportsInsertReturning() {
            return true;
        }

        @Override
        public String dbTimeMillis() {
            return "date_trunc('milliseconds',localtimestamp)";
        }

        @Override
        public String sequenceCacheClause(int nbrValuesToCache) {
            return " cache " + nbrValuesToCache;
        }

        @Override
        public String dateAsSqlFunction(Date date, Calendar calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000");
            dateFormat.setCalendar(calendar);
            return "'" + dateFormat.format(date) + " GMT'::timestamp";
        }

        @Override
        public String sequenceOptions() {
            return "";
        }
    }
    ,
    hsqldb{

        @Override
        public String typeInteger() {
            return "integer";
        }

        @Override
        public String typeBoolean() {
            return "char(1)";
        }

        @Override
        public String typeLong() {
            return "bigint";
        }

        @Override
        public String typeFloat() {
            return "double";
        }

        @Override
        public String typeDouble() {
            return "double";
        }

        @Override
        public String typeBigDecimal(int size, int precision) {
            return "numeric(" + size + "," + precision + ")";
        }

        @Override
        public String typeStringVar(int bytes) {
            return "varchar(" + bytes + ")";
        }

        @Override
        public String typeStringFixed(int bytes) {
            return "char(" + bytes + ")";
        }

        @Override
        public String typeClob() {
            return "clob(2G)";
        }

        @Override
        public String typeBlob() {
            return "blob(2G)";
        }

        @Override
        public String typeDate() {
            return "timestamp(3)";
        }

        @Override
        public boolean useStringForClob() {
            return true;
        }

        @Override
        public boolean useBytesForBlob() {
            return true;
        }

        @Override
        public String sequenceNextVal(String sequenceName) {
            return "next value for " + sequenceName + "";
        }

        @Override
        public String sequenceSelectNextVal(String sequenceName) {
            return "select " + this.sequenceNextVal(sequenceName) + this.fromAny();
        }

        @Override
        public String sequenceDrop(String dbtestSeq) {
            return "drop sequence if exists " + dbtestSeq;
        }

        @Override
        public String sequenceOrderClause(boolean order) {
            return "";
        }

        @Override
        public String sequenceCycleClause(boolean cycle) {
            return cycle ? " cycle" : " no cycle";
        }

        @Override
        public String fromAny() {
            return " from (values(0))";
        }

        @Override
        public boolean supportsInsertReturning() {
            return false;
        }

        @Override
        public String dbTimeMillis() {
            return "localtimestamp";
        }

        @Override
        public String sequenceCacheClause(int nbrValuesToCache) {
            return "";
        }

        @Override
        public String dateAsSqlFunction(Date date, Calendar calendar) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS000XXX");
            dateFormat.setCalendar(calendar);
            return "cast(timestamp '" + dateFormat.format(date) + "' as timestamp without time zone)";
        }

        @Override
        public String sequenceOptions() {
            return " as bigint";
        }
    };


    public abstract String typeInteger();

    public abstract String typeBoolean();

    public abstract String typeLong();

    public abstract String typeFloat();

    public abstract String typeDouble();

    public abstract String typeBigDecimal(int var1, int var2);

    public abstract String typeStringVar(int var1);

    public abstract String typeStringFixed(int var1);

    public abstract String typeClob();

    public abstract String typeBlob();

    public abstract String typeDate();

    public abstract boolean useStringForClob();

    public abstract boolean useBytesForBlob();

    public abstract String sequenceNextVal(String var1);

    public abstract String sequenceSelectNextVal(String var1);

    public abstract String sequenceDrop(String var1);

    public abstract boolean supportsInsertReturning();

    public abstract String dbTimeMillis();

    public abstract String sequenceCacheClause(int var1);

    public abstract String sequenceOrderClause(boolean var1);

    public abstract String sequenceCycleClause(boolean var1);

    public abstract String fromAny();

    public abstract String dateAsSqlFunction(Date var1, Calendar var2);

    public abstract String sequenceOptions();

    public static Flavor fromJdbcUrl(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return postgresql;
        }
        if (url.startsWith("jdbc:oracle:")) {
            return oracle;
        }
        if (url.startsWith("jdbc:sqlserver:")) {
            return sqlserver;
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return hsqldb;
        }
        if (url.startsWith("jdbc:derby:")) {
            return derby;
        }
        throw new DatabaseException("Cannot determine database flavor from url");
    }

    public static String driverForJdbcUrl(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (url.startsWith("jdbc:oracle:")) {
            return "oracle.jdbc.OracleDriver";
        }
        if (url.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }
        if (url.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        throw new DatabaseException("Cannot determine database driver class from url");
    }
}

