/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import java.util.ArrayList;
import java.util.List;

public class Metric {
    private final boolean enabled;
    private boolean done;
    private long startNanos;
    private long lastCheckpointNanos;
    private List<Checkpoint> checkpoints;

    public Metric(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.checkpoints = new ArrayList<Checkpoint>();
            this.lastCheckpointNanos = this.startNanos = System.nanoTime();
        }
    }

    public long elapsedMillis() {
        if (!this.enabled) {
            return -1L;
        }
        return (System.nanoTime() - this.startNanos) / 1000000L;
    }

    public long elapsedNanos() {
        if (!this.enabled) {
            return -1L;
        }
        return System.nanoTime() - this.startNanos;
    }

    public void checkpoint(String description, Object ... args) {
        if (this.enabled) {
            long currentCheckpointNanos = System.nanoTime();
            this.checkpoints.add(new Checkpoint(this.noTabsOrSpaces(description), currentCheckpointNanos - this.lastCheckpointNanos, args));
            this.lastCheckpointNanos = currentCheckpointNanos;
        }
    }

    public long done(String description, Object ... args) {
        this.checkpoint(description, args);
        return this.done();
    }

    public long done() {
        if (this.enabled) {
            if (!this.done) {
                this.lastCheckpointNanos = System.nanoTime();
                this.done = true;
            }
            return this.lastCheckpointNanos - this.startNanos;
        }
        return -1L;
    }

    public String getMessage() {
        if (this.enabled) {
            StringBuilder buf = new StringBuilder();
            this.printMessage(buf);
            return buf.toString();
        }
        return "metricsDisabled";
    }

    public void printMessage(StringBuilder buf) {
        if (this.enabled) {
            this.done();
            this.writeNanos(buf, this.lastCheckpointNanos - this.startNanos);
            if (!this.checkpoints.isEmpty()) {
                buf.append("(");
                boolean first = true;
                for (Checkpoint checkpoint : this.checkpoints) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(',');
                    }
                    buf.append(checkpoint.description);
                    if (checkpoint.args != null && checkpoint.args.length > 0) {
                        buf.append('[');
                        boolean firstArg = true;
                        for (Object o : checkpoint.args) {
                            if (firstArg) {
                                firstArg = false;
                            } else {
                                buf.append(',');
                            }
                            buf.append(this.sanitizeArg(String.valueOf(o)));
                        }
                        buf.append(']');
                    }
                    buf.append('=');
                    this.writeNanos(buf, checkpoint.durationNanos);
                }
                buf.append(')');
            }
        } else {
            buf.append("metricsDisabled");
        }
    }

    private void writeNanos(StringBuilder buf, long nanos) {
        String nanosStr;
        if (nanos < 0L) {
            buf.append("-");
            nanos = -nanos;
        }
        if ((nanosStr = Long.toString(nanos)).length() > 6) {
            buf.append(nanosStr.substring(0, nanosStr.length() - 6));
            buf.append('.');
            buf.append(nanosStr.substring(nanosStr.length() - 6, nanosStr.length() - 3));
        } else {
            buf.append("0.0000000".substring(0, 8 - Math.max(nanosStr.length(), 4)));
            if (nanosStr.length() > 3) {
                buf.append(nanosStr.substring(0, nanosStr.length() - 3));
            }
        }
        buf.append("ms");
    }

    private String noTabsOrSpaces(String s) {
        return s.replace(' ', '_').replace('\t', '_');
    }

    private String sanitizeArg(String s) {
        return s.replaceAll("[^\\p{Alnum}_.\\-\\+]", "*");
    }

    private static class Checkpoint {
        String description;
        long durationNanos;
        private final Object[] args;

        Checkpoint(String description, long durationNanos, Object ... args) {
            this.description = description;
            this.durationNanos = durationNanos;
            this.args = args;
        }
    }
}

