/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MixedParameterSql {
    private final String sqlToExecute;
    private final Object[] args;

    public MixedParameterSql(String sql, List<Object> positionalArgs, Map<String, Object> nameToArg) {
        if (positionalArgs == null) {
            positionalArgs = new ArrayList<Object>();
        }
        if (nameToArg == null) {
            nameToArg = new HashMap<String, Object>();
        }
        StringBuilder newSql = new StringBuilder(sql.length());
        ArrayList<String> argNamesList = new ArrayList<String>();
        ArrayList<String> rewrittenArgs = new ArrayList<String>();
        ArrayList<Object> argsList = new ArrayList<Object>();
        int searchIndex = 0;
        int currentPositionalArg = 0;
        while (searchIndex < sql.length()) {
            int nextColonIndex = sql.indexOf(58, searchIndex);
            int nextQmIndex = sql.indexOf(63, searchIndex);
            if (nextColonIndex < 0 && nextQmIndex < 0) {
                newSql.append(sql.substring(searchIndex));
                break;
            }
            if (nextColonIndex >= 0 && (nextQmIndex == -1 || nextColonIndex < nextQmIndex)) {
                int endOfNameIndex;
                if (nextColonIndex > sql.length() - 2) break;
                if (sql.charAt(nextColonIndex + 1) == ':') {
                    newSql.append(sql.substring(searchIndex, nextColonIndex + 1));
                    searchIndex = nextColonIndex + 2;
                    continue;
                }
                for (endOfNameIndex = nextColonIndex + 1; endOfNameIndex < sql.length() && Character.isJavaIdentifierPart(sql.charAt(endOfNameIndex)); ++endOfNameIndex) {
                }
                newSql.append(sql.substring(searchIndex, nextColonIndex));
                String paramName = sql.substring(nextColonIndex + 1, endOfNameIndex);
                boolean secretParam = paramName.startsWith("secret");
                Object arg = nameToArg.get(paramName);
                if (arg instanceof RewriteArg) {
                    newSql.append(((RewriteArg)arg).sql);
                    rewrittenArgs.add(paramName);
                } else {
                    newSql.append('?');
                    if (!nameToArg.containsKey(paramName)) {
                        throw new DatabaseException("The SQL requires parameter ':" + paramName + "' but no value was provided");
                    }
                    argsList.add(secretParam ? new SecretArg(arg) : arg);
                    argNamesList.add(paramName);
                }
                searchIndex = endOfNameIndex;
                continue;
            }
            if (nextQmIndex < sql.length() - 1 && sql.charAt(nextQmIndex + 1) == '?') {
                newSql.append(sql.substring(searchIndex, nextQmIndex + 1));
                searchIndex = nextQmIndex + 2;
                continue;
            }
            newSql.append(sql.substring(searchIndex, nextQmIndex));
            if (currentPositionalArg >= positionalArgs.size()) {
                throw new DatabaseException("Not enough positional parameters (" + positionalArgs.size() + ") were provided");
            }
            if (positionalArgs.get(currentPositionalArg) instanceof RewriteArg) {
                newSql.append(((RewriteArg)positionalArgs.get(currentPositionalArg)).sql);
            } else {
                newSql.append('?');
                argsList.add(positionalArgs.get(currentPositionalArg));
            }
            ++currentPositionalArg;
            searchIndex = nextQmIndex + 1;
        }
        this.sqlToExecute = newSql.toString();
        this.args = argsList.toArray(new Object[argsList.size()]);
        if (currentPositionalArg != positionalArgs.size()) {
            throw new DatabaseException("Wrong number of positional parameters were provided (expected: " + currentPositionalArg + ", actual: " + positionalArgs.size() + ")");
        }
        if (nameToArg.size() > this.args.length - Math.max(0, positionalArgs.size() - 1) + rewrittenArgs.size()) {
            HashSet<String> unusedNames = new HashSet<String>(nameToArg.keySet());
            unusedNames.removeAll(argNamesList);
            unusedNames.removeAll(rewrittenArgs);
            if (!unusedNames.isEmpty()) {
                throw new DatabaseException("These named parameters do not exist in the query: " + unusedNames);
            }
        }
    }

    public String getSqlToExecute() {
        return this.sqlToExecute;
    }

    public Object[] getArgs() {
        return this.args;
    }

    static class SecretArg {
        private final Object arg;

        SecretArg(Object arg) {
            this.arg = arg;
        }

        Object getArg() {
            return this.arg;
        }

        public String toString() {
            return "<secret>";
        }
    }

    public static class RewriteArg {
        private final String sql;

        public RewriteArg(String sql) {
            this.sql = sql;
        }
    }
}

