/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Flavor;
import com.github.susom.database.Options;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class OptionsDefault
implements Options {
    private final Flavor flavor;

    public OptionsDefault(Flavor flavor) {
        this.flavor = flavor;
    }

    @Override
    public boolean allowTransactionControl() {
        return false;
    }

    @Override
    public boolean ignoreTransactionControl() {
        return false;
    }

    @Override
    public boolean allowConnectionAccess() {
        return false;
    }

    @Override
    public boolean isLogParameters() {
        return false;
    }

    @Override
    public boolean isDetailedExceptions() {
        return false;
    }

    @Override
    public String generateErrorCode() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd:H:m:s");
        return sdf.format(new Date()) + "-" + Math.abs(new Random().nextInt());
    }

    @Override
    public boolean useBytesForBlob() {
        return this.flavor().useBytesForBlob();
    }

    @Override
    public boolean useStringForClob() {
        return this.flavor().useStringForClob();
    }

    @Override
    public Flavor flavor() {
        return this.flavor;
    }

    @Override
    public Date currentDate() {
        return new Date();
    }

    @Override
    public boolean useDatePerAppOnly() {
        return false;
    }

    @Override
    public Calendar calendarForTimestamps() {
        return Calendar.getInstance(TimeZone.getDefault());
    }

    @Override
    public int maxStringLengthParam() {
        return 4000;
    }
}

