/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import com.github.susom.database.Rows;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RowStub {
    private String[] columnNames;
    private List<Object[]> rows = new ArrayList<Object[]>();

    public RowStub withColumnNames(String ... names) {
        this.columnNames = names;
        return this;
    }

    public RowStub addRow(Object ... columns) {
        this.rows.add(columns);
        return this;
    }

    public Rows toRows() {
        return new Rows(){
            private int row = -1;
            private int col = -1;

            @Override
            public boolean next() {
                this.col = -1;
                return !RowStub.this.rows.isEmpty() && ++this.row < RowStub.this.rows.size();
            }

            @Override
            @Nonnull
            public String[] getColumnLabels() {
                this.requireColumnNames();
                return RowStub.this.columnNames;
            }

            @Override
            @Nonnull
            public ResultSetMetaData getMetadata() {
                this.requireColumnNames();
                return new ResultSetMetaData(){

                    @Override
                    public int getColumnCount() throws SQLException {
                        return RowStub.this.columnNames.length;
                    }

                    @Override
                    public boolean isAutoIncrement(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public boolean isCaseSensitive(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public boolean isSearchable(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public boolean isCurrency(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public int isNullable(int column) throws SQLException {
                        return 1;
                    }

                    @Override
                    public boolean isSigned(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public int getColumnDisplaySize(int column) throws SQLException {
                        return 4000;
                    }

                    @Override
                    public String getColumnLabel(int column) throws SQLException {
                        return RowStub.this.columnNames[column - 1];
                    }

                    @Override
                    public String getColumnName(int column) throws SQLException {
                        return RowStub.this.columnNames[column - 1];
                    }

                    @Override
                    public String getSchemaName(int column) throws SQLException {
                        return "";
                    }

                    @Override
                    public int getPrecision(int column) throws SQLException {
                        return 4000;
                    }

                    @Override
                    public int getScale(int column) throws SQLException {
                        return 0;
                    }

                    @Override
                    public String getTableName(int column) throws SQLException {
                        return "";
                    }

                    @Override
                    public String getCatalogName(int column) throws SQLException {
                        return "";
                    }

                    @Override
                    public int getColumnType(int column) throws SQLException {
                        return 12;
                    }

                    @Override
                    public String getColumnTypeName(int column) throws SQLException {
                        return "VARCHAR";
                    }

                    @Override
                    public boolean isReadOnly(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public boolean isWritable(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public boolean isDefinitelyWritable(int column) throws SQLException {
                        return false;
                    }

                    @Override
                    public String getColumnClassName(int column) throws SQLException {
                        return String.class.getName();
                    }

                    @Override
                    public <T> T unwrap(Class<T> iface) throws SQLException {
                        return null;
                    }

                    @Override
                    public boolean isWrapperFor(Class<?> iface) throws SQLException {
                        return false;
                    }
                };
            }

            @Override
            @Nullable
            public Boolean getBooleanOrNull() {
                return this.toBoolean(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Boolean getBooleanOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toBoolean(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Boolean getBooleanOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toBoolean(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            public boolean getBooleanOrFalse() {
                Boolean i = this.getBooleanOrNull();
                return i == null ? false : i;
            }

            @Override
            public boolean getBooleanOrFalse(int columnOneBased) {
                Boolean i = this.getBooleanOrNull(columnOneBased);
                return i == null ? false : i;
            }

            @Override
            public boolean getBooleanOrFalse(String columnName) {
                Boolean i = this.getBooleanOrNull(columnName);
                return i == null ? false : i;
            }

            @Override
            public boolean getBooleanOrTrue() {
                Boolean i = this.getBooleanOrNull();
                return i == null ? true : i;
            }

            @Override
            public boolean getBooleanOrTrue(int columnOneBased) {
                this.col = columnOneBased;
                Boolean i = this.getBooleanOrNull(columnOneBased);
                return i == null ? true : i;
            }

            @Override
            public boolean getBooleanOrTrue(String columnName) {
                Boolean i = this.getBooleanOrNull(columnName);
                return i == null ? true : i;
            }

            @Override
            @Nullable
            public Integer getIntegerOrNull() {
                return this.toInteger(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Integer getIntegerOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toInteger(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Integer getIntegerOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toInteger(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            public int getIntegerOrZero() {
                Integer i = this.getIntegerOrNull();
                return i == null ? 0 : i;
            }

            @Override
            public int getIntegerOrZero(int columnOneBased) {
                Integer i = this.getIntegerOrNull(columnOneBased);
                return i == null ? 0 : i;
            }

            @Override
            public int getIntegerOrZero(String columnName) {
                Integer i = this.getIntegerOrNull(columnName);
                return i == null ? 0 : i;
            }

            @Override
            @Nullable
            public Long getLongOrNull() {
                return this.toLong(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Long getLongOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toLong(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Long getLongOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toLong(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            public long getLongOrZero() {
                Long i = this.getLongOrNull();
                return i == null ? 0L : i;
            }

            @Override
            public long getLongOrZero(int columnOneBased) {
                Long i = this.getLongOrNull(columnOneBased);
                return i == null ? 0L : i;
            }

            @Override
            public long getLongOrZero(String columnName) {
                Long i = this.getLongOrNull(columnName);
                return i == null ? 0L : i;
            }

            @Override
            @Nullable
            public Float getFloatOrNull() {
                return this.toFloat(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Float getFloatOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toFloat(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Float getFloatOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toFloat(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            public float getFloatOrZero() {
                Float i = this.getFloatOrNull();
                return i == null ? 0.0f : i.floatValue();
            }

            @Override
            public float getFloatOrZero(int columnOneBased) {
                Float i = this.getFloatOrNull(columnOneBased);
                return i == null ? 0.0f : i.floatValue();
            }

            @Override
            public float getFloatOrZero(String columnName) {
                Float i = this.getFloatOrNull(columnName);
                return i == null ? 0.0f : i.floatValue();
            }

            @Override
            @Nullable
            public Double getDoubleOrNull() {
                return this.toDouble(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Double getDoubleOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toDouble(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Double getDoubleOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toDouble(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            public double getDoubleOrZero() {
                Double i = this.getDoubleOrNull();
                return i == null ? 0.0 : i;
            }

            @Override
            public double getDoubleOrZero(int columnOneBased) {
                Double i = this.getDoubleOrNull(columnOneBased);
                return i == null ? 0.0 : i;
            }

            @Override
            public double getDoubleOrZero(String columnName) {
                Double i = this.getDoubleOrNull(columnName);
                return i == null ? 0.0 : i;
            }

            @Override
            @Nullable
            public BigDecimal getBigDecimalOrNull() {
                return this.toBigDecimal(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public BigDecimal getBigDecimalOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toBigDecimal(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public BigDecimal getBigDecimalOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toBigDecimal(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            @Nonnull
            public BigDecimal getBigDecimalOrZero() {
                BigDecimal i = this.getBigDecimalOrNull();
                return i == null ? new BigDecimal(0) : i;
            }

            @Override
            @Nonnull
            public BigDecimal getBigDecimalOrZero(int columnOneBased) {
                BigDecimal i = this.getBigDecimalOrNull(columnOneBased);
                return i == null ? new BigDecimal(0) : i;
            }

            @Override
            @Nonnull
            public BigDecimal getBigDecimalOrZero(String columnName) {
                BigDecimal i = this.getBigDecimalOrNull(columnName);
                return i == null ? new BigDecimal(0) : i;
            }

            @Override
            @Nullable
            public String getStringOrNull() {
                return this.toString(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public String getStringOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toString(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public String getStringOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toString(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            @Nonnull
            public String getStringOrEmpty() {
                String i = this.getStringOrNull();
                return i == null ? "" : i;
            }

            @Override
            @Nonnull
            public String getStringOrEmpty(int columnOneBased) {
                String i = this.getStringOrNull(columnOneBased);
                return i == null ? "" : i;
            }

            @Override
            @Nonnull
            public String getStringOrEmpty(String columnName) {
                String i = this.getStringOrNull(columnName);
                return i == null ? "" : i;
            }

            @Override
            @Nullable
            public String getClobStringOrNull() {
                return this.getStringOrNull();
            }

            @Override
            @Nullable
            public String getClobStringOrNull(int columnOneBased) {
                return this.getStringOrNull(columnOneBased);
            }

            @Override
            @Nullable
            public String getClobStringOrNull(String columnName) {
                return this.getStringOrNull(columnName);
            }

            @Override
            @Nonnull
            public String getClobStringOrEmpty() {
                return this.getStringOrEmpty();
            }

            @Override
            @Nonnull
            public String getClobStringOrEmpty(int columnOneBased) {
                return this.getStringOrEmpty(columnOneBased);
            }

            @Override
            @Nonnull
            public String getClobStringOrEmpty(String columnName) {
                return this.getStringOrEmpty(columnName);
            }

            @Override
            @Nullable
            public Reader getClobReaderOrNull() {
                String s = this.getStringOrNull();
                return s == null ? null : new StringReader(s);
            }

            @Override
            @Nullable
            public Reader getClobReaderOrNull(int columnOneBased) {
                String s = this.getStringOrNull(columnOneBased);
                return s == null ? null : new StringReader(s);
            }

            @Override
            @Nullable
            public Reader getClobReaderOrNull(String columnName) {
                String s = this.getStringOrNull(columnName);
                return s == null ? null : new StringReader(s);
            }

            @Override
            @Nonnull
            public Reader getClobReaderOrEmpty() {
                return new StringReader(this.getStringOrEmpty());
            }

            @Override
            @Nonnull
            public Reader getClobReaderOrEmpty(int columnOneBased) {
                return new StringReader(this.getStringOrEmpty(columnOneBased));
            }

            @Override
            @Nonnull
            public Reader getClobReaderOrEmpty(String columnName) {
                return new StringReader(this.getStringOrEmpty(columnName));
            }

            @Override
            @Nullable
            public byte[] getBlobBytesOrNull() {
                return this.toBytes(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public byte[] getBlobBytesOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toBytes(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public byte[] getBlobBytesOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toBytes(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            @Override
            @Nonnull
            public byte[] getBlobBytesOrZeroLen() {
                byte[] a = this.getBlobBytesOrNull();
                return a == null ? new byte[]{} : a;
            }

            @Override
            @Nonnull
            public byte[] getBlobBytesOrZeroLen(int columnOneBased) {
                byte[] a = this.getBlobBytesOrNull(columnOneBased);
                return a == null ? new byte[]{} : a;
            }

            @Override
            @Nonnull
            public byte[] getBlobBytesOrZeroLen(String columnName) {
                byte[] a = this.getBlobBytesOrNull(columnName);
                return a == null ? new byte[]{} : a;
            }

            @Override
            @Nullable
            public InputStream getBlobInputStreamOrNull() {
                byte[] a = this.getBlobBytesOrNull();
                return a == null ? null : new ByteArrayInputStream(a);
            }

            @Override
            @Nullable
            public InputStream getBlobInputStreamOrNull(int columnOneBased) {
                byte[] a = this.getBlobBytesOrNull(columnOneBased);
                return a == null ? null : new ByteArrayInputStream(a);
            }

            @Override
            @Nullable
            public InputStream getBlobInputStreamOrNull(String columnName) {
                byte[] a = this.getBlobBytesOrNull(columnName);
                return a == null ? null : new ByteArrayInputStream(a);
            }

            @Override
            @Nonnull
            public InputStream getBlobInputStreamOrEmpty() {
                return new ByteArrayInputStream(this.getBlobBytesOrZeroLen());
            }

            @Override
            @Nonnull
            public InputStream getBlobInputStreamOrEmpty(int columnOneBased) {
                return new ByteArrayInputStream(this.getBlobBytesOrZeroLen(columnOneBased));
            }

            @Override
            @Nonnull
            public InputStream getBlobInputStreamOrEmpty(String columnName) {
                return new ByteArrayInputStream(this.getBlobBytesOrZeroLen(columnName));
            }

            @Override
            @Nullable
            public Date getDateOrNull() {
                return this.toDate(((Object[])RowStub.this.rows.get(this.row))[++this.col]);
            }

            @Override
            @Nullable
            public Date getDateOrNull(int columnOneBased) {
                this.col = columnOneBased;
                return this.toDate(((Object[])RowStub.this.rows.get(this.row))[columnOneBased - 1]);
            }

            @Override
            @Nullable
            public Date getDateOrNull(String columnName) {
                this.col = this.columnIndexByName(columnName) + 1;
                return this.toDate(((Object[])RowStub.this.rows.get(this.row))[this.columnIndexByName(columnName)]);
            }

            private void requireColumnNames() {
                if (RowStub.this.columnNames == null) {
                    throw new DatabaseException("Column names were not provided for this stub");
                }
            }

            private int columnIndexByName(String columnName) {
                this.requireColumnNames();
                for (int i = 0; i < RowStub.this.columnNames.length; ++i) {
                    if (!columnName.equals(RowStub.this.columnNames[i])) continue;
                    return i;
                }
                throw new DatabaseException("Column name '" + columnName + "' not found");
            }

            private Boolean toBoolean(Object o) {
                if (o instanceof String) {
                    if ("Y".equals(o)) {
                        return Boolean.TRUE;
                    }
                    if ("N".equals(o)) {
                        return Boolean.FALSE;
                    }
                    throw new DatabaseException("Value returned for boolean was not 'Y' or 'N'");
                }
                return (Boolean)o;
            }

            private Integer toInteger(Object o) {
                return (Integer)o;
            }

            private Long toLong(Object o) {
                if (o instanceof Integer) {
                    return ((Integer)o).longValue();
                }
                return (Long)o;
            }

            private Float toFloat(Object o) {
                if (o instanceof Integer) {
                    return Float.valueOf(((Integer)o).floatValue());
                }
                return (Float)o;
            }

            private Double toDouble(Object o) {
                if (o instanceof Integer) {
                    return ((Integer)o).doubleValue();
                }
                if (o instanceof Float) {
                    return ((Float)o).doubleValue();
                }
                return (Double)o;
            }

            private BigDecimal toBigDecimal(Object o) {
                if (o instanceof Integer) {
                    return new BigDecimal(((Integer)o).doubleValue());
                }
                if (o instanceof Long) {
                    return new BigDecimal(((Long)o).doubleValue());
                }
                if (o instanceof Float) {
                    return new BigDecimal(((Float)o).doubleValue());
                }
                if (o instanceof Double) {
                    return new BigDecimal((Double)o);
                }
                return (BigDecimal)o;
            }

            private byte[] toBytes(Object o) {
                return (byte[])o;
            }

            private String toString(Object o) {
                return (String)o;
            }

            private Date toDate(Object o) {
                if (o instanceof String) {
                    String s = (String)o;
                    if (s.length() == "yyyy-MM-dd".length()) {
                        try {
                            return new SimpleDateFormat("yyyy-MM-dd").parse(s);
                        }
                        catch (ParseException e) {
                            throw new DatabaseException("Could not parse date as yyyy-MM-dd for " + s);
                        }
                    }
                    if (s.length() == "yyyy-MM-ddThh:mm:ss".length()) {
                        try {
                            return new SimpleDateFormat("yyyy-MM-ddThh:mm:ss").parse(s);
                        }
                        catch (ParseException e) {
                            throw new DatabaseException("Could not parse date as yyyy-MM-ddThh:mm:ss for " + s);
                        }
                    }
                    throw new DatabaseException("Didn't understand date string: " + s);
                }
                return (Date)o;
            }
        };
    }
}

