/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import com.github.susom.database.Options;
import com.github.susom.database.Rows;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class RowsAdaptor
implements Rows {
    private final ResultSet rs;
    private final Options options;
    private int column = 1;

    public RowsAdaptor(ResultSet rs, Options options) {
        this.rs = rs;
        this.options = options;
    }

    @Override
    public boolean next() {
        try {
            this.column = 1;
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public String[] getColumnLabels() {
        try {
            ResultSetMetaData metaData = this.rs.getMetaData();
            String[] names = new String[metaData.getColumnCount()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = metaData.getColumnLabel(i + 1);
            }
            return names;
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to retrieve metadata from ResultSet", e);
        }
    }

    @Override
    @Nonnull
    public ResultSetMetaData getMetadata() {
        try {
            return this.rs.getMetaData();
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to retrieve metadata from ResultSet", e);
        }
    }

    @Override
    @Nullable
    public Boolean getBooleanOrNull() {
        return this.getBooleanOrNull(this.column++);
    }

    @Override
    @Nullable
    public Boolean getBooleanOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toBoolean(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nullable
    public Boolean getBooleanOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toBoolean(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean getBooleanOrFalse() {
        return this.getBooleanOrFalse(this.column++);
    }

    @Override
    public boolean getBooleanOrFalse(int columnOneBased) {
        Boolean result = this.getBooleanOrNull(columnOneBased);
        if (result == null) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Override
    public boolean getBooleanOrFalse(String columnName) {
        Boolean result = this.getBooleanOrNull(columnName);
        if (result == null) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Override
    public boolean getBooleanOrTrue() {
        return this.getBooleanOrTrue(this.column++);
    }

    @Override
    public boolean getBooleanOrTrue(int columnOneBased) {
        Boolean result = this.getBooleanOrNull(columnOneBased);
        if (result == null) {
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    public boolean getBooleanOrTrue(String columnName) {
        Boolean result = this.getBooleanOrNull(columnName);
        if (result == null) {
            result = Boolean.TRUE;
        }
        return result;
    }

    @Override
    @Nullable
    public Integer getIntegerOrNull() {
        return this.getIntegerOrNull(this.column++);
    }

    @Override
    public Integer getIntegerOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toInteger(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Integer getIntegerOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toInteger(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getIntegerOrZero() {
        return this.getIntegerOrZero(this.column++);
    }

    @Override
    public int getIntegerOrZero(int columnOneBased) {
        Integer result = this.getIntegerOrNull(columnOneBased);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    @Override
    public int getIntegerOrZero(String columnName) {
        Integer result = this.getIntegerOrNull(columnName);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    @Override
    @Nullable
    public Long getLongOrNull() {
        return this.getLongOrNull(this.column++);
    }

    @Override
    public Long getLongOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toLong(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Long getLongOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toLong(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public long getLongOrZero() {
        return this.getLongOrZero(this.column++);
    }

    @Override
    public long getLongOrZero(int columnOneBased) {
        Long result = this.getLongOrNull(columnOneBased);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    @Override
    public long getLongOrZero(String columnName) {
        Long result = this.getLongOrNull(columnName);
        if (result == null) {
            result = 0L;
        }
        return result;
    }

    @Override
    @Nullable
    public Float getFloatOrNull() {
        return this.getFloatOrNull(this.column++);
    }

    @Override
    public Float getFloatOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toFloat(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Float getFloatOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toFloat(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public float getFloatOrZero() {
        return this.getFloatOrZero(this.column++);
    }

    @Override
    public float getFloatOrZero(int columnOneBased) {
        Float result = this.getFloatOrNull(columnOneBased);
        if (result == null) {
            result = Float.valueOf(0.0f);
        }
        return result.floatValue();
    }

    @Override
    public float getFloatOrZero(String columnName) {
        Float result = this.getFloatOrNull(columnName);
        if (result == null) {
            result = Float.valueOf(0.0f);
        }
        return result.floatValue();
    }

    @Override
    @Nullable
    public Double getDoubleOrNull() {
        return this.getDoubleOrNull(this.column++);
    }

    @Override
    public Double getDoubleOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toDouble(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Double getDoubleOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toDouble(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public double getDoubleOrZero() {
        return this.getDoubleOrZero(this.column++);
    }

    @Override
    public double getDoubleOrZero(int columnOneBased) {
        Double result = this.getDoubleOrNull(columnOneBased);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getDoubleOrZero(String columnName) {
        Double result = this.getDoubleOrNull(columnName);
        if (result == null) {
            result = 0.0;
        }
        return result;
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalOrNull() {
        return this.getBigDecimalOrNull(this.column++);
    }

    @Override
    public BigDecimal getBigDecimalOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toBigDecimal(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimalOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toBigDecimal(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public BigDecimal getBigDecimalOrZero() {
        return this.getBigDecimalOrZero(this.column++);
    }

    @Override
    @Nonnull
    public BigDecimal getBigDecimalOrZero(int columnOneBased) {
        BigDecimal result = this.getBigDecimalOrNull(columnOneBased);
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    @Nonnull
    public BigDecimal getBigDecimalOrZero(String columnName) {
        BigDecimal result = this.getBigDecimalOrNull(columnName);
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    @Nullable
    public String getStringOrNull() {
        return this.getStringOrNull(this.column++);
    }

    @Override
    public String getStringOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            String result = this.rs.getString(columnOneBased);
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getStringOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            String result = this.rs.getString(columnName);
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public String getStringOrEmpty() {
        return this.getStringOrEmpty(this.column++);
    }

    @Override
    @Nonnull
    public String getStringOrEmpty(int columnOneBased) {
        String result = this.getStringOrNull(columnOneBased);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Nonnull
    public String getStringOrEmpty(String columnName) {
        String result = this.getStringOrNull(columnName);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Nullable
    public String getClobStringOrNull() {
        return this.getClobStringOrNull(this.column++);
    }

    @Override
    public String getClobStringOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            String result = this.rs.getString(columnOneBased);
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getClobStringOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            String result = this.rs.getString(columnName);
            if (result != null && result.length() == 0) {
                result = null;
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public String getClobStringOrEmpty() {
        return this.getClobStringOrEmpty(this.column++);
    }

    @Override
    @Nonnull
    public String getClobStringOrEmpty(int columnOneBased) {
        String result = this.getClobStringOrNull(columnOneBased);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Nonnull
    public String getClobStringOrEmpty(String columnName) {
        String result = this.getClobStringOrNull(columnName);
        if (result == null) {
            result = "";
        }
        return result;
    }

    @Override
    @Nullable
    public Reader getClobReaderOrNull() {
        return this.getClobReaderOrNull(this.column++);
    }

    @Override
    public Reader getClobReaderOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.rs.getCharacterStream(columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Reader getClobReaderOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.rs.getCharacterStream(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public Reader getClobReaderOrEmpty() {
        return this.getClobReaderOrEmpty(this.column++);
    }

    @Override
    @Nonnull
    public Reader getClobReaderOrEmpty(int columnOneBased) {
        Reader result = this.getClobReaderOrNull(columnOneBased);
        if (result == null) {
            result = new StringReader("");
        }
        return result;
    }

    @Override
    @Nonnull
    public Reader getClobReaderOrEmpty(String columnName) {
        Reader result = this.getClobReaderOrNull(columnName);
        if (result == null) {
            result = new StringReader("");
        }
        return result;
    }

    @Override
    @Nullable
    public byte[] getBlobBytesOrNull() {
        return this.getBlobBytesOrNull(this.column++);
    }

    @Override
    public byte[] getBlobBytesOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.rs.getBytes(columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public byte[] getBlobBytesOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.rs.getBytes(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public byte[] getBlobBytesOrZeroLen() {
        return this.getBlobBytesOrZeroLen(this.column++);
    }

    @Override
    @Nonnull
    public byte[] getBlobBytesOrZeroLen(int columnOneBased) {
        byte[] result = this.getBlobBytesOrNull(columnOneBased);
        if (result == null) {
            result = new byte[]{};
        }
        return result;
    }

    @Override
    @Nonnull
    public byte[] getBlobBytesOrZeroLen(String columnName) {
        byte[] result = this.getBlobBytesOrNull(columnName);
        if (result == null) {
            result = new byte[]{};
        }
        return result;
    }

    @Override
    @Nullable
    public InputStream getBlobInputStreamOrNull() {
        return this.getBlobInputStreamOrNull(this.column++);
    }

    @Override
    public InputStream getBlobInputStreamOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.rs.getBinaryStream(columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public InputStream getBlobInputStreamOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.rs.getBinaryStream(columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    @Nonnull
    public InputStream getBlobInputStreamOrEmpty() {
        return this.getBlobInputStreamOrEmpty(this.column++);
    }

    @Override
    @Nonnull
    public InputStream getBlobInputStreamOrEmpty(int columnOneBased) {
        InputStream result = this.getBlobInputStreamOrNull(columnOneBased);
        if (result == null) {
            result = new ByteArrayInputStream(new byte[0]);
        }
        return result;
    }

    @Override
    @Nonnull
    public InputStream getBlobInputStreamOrEmpty(String columnName) {
        InputStream result = this.getBlobInputStreamOrNull(columnName);
        if (result == null) {
            result = new ByteArrayInputStream(new byte[0]);
        }
        return result;
    }

    @Override
    @Nullable
    public Date getDateOrNull() {
        return this.getDateOrNull(this.column++);
    }

    @Override
    public Date getDateOrNull(int columnOneBased) {
        try {
            this.column = columnOneBased + 1;
            return this.toDate(this.rs, columnOneBased);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Date getDateOrNull(String columnName) {
        try {
            this.column = this.rs.findColumn(columnName) + 1;
            return this.toDate(this.rs, columnName);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private Date timestampToDate(Timestamp ts) {
        long millis = ts.getTime();
        int nanos = ts.getNanos();
        return new Date(millis / 1000L * 1000L + (long)(nanos / 1000000));
    }

    private Date toDate(ResultSet rs, int col) throws SQLException {
        Timestamp val = rs.getTimestamp(col, this.options.calendarForTimestamps());
        return val == null ? null : this.timestampToDate(val);
    }

    private Date toDate(ResultSet rs, String col) throws SQLException {
        Timestamp val = rs.getTimestamp(col, this.options.calendarForTimestamps());
        return val == null ? null : this.timestampToDate(val);
    }

    private Boolean toBoolean(ResultSet rs, int col) throws SQLException {
        String val = rs.getString(col);
        if (val == null) {
            return null;
        }
        if (val.equals("Y")) {
            return Boolean.TRUE;
        }
        if (val.equals("N")) {
            return Boolean.FALSE;
        }
        throw new DatabaseException("Reading boolean from column " + col + " but the value was not 'Y' or 'N'");
    }

    private Boolean toBoolean(ResultSet rs, String col) throws SQLException {
        String val = rs.getString(col);
        if (val == null) {
            return null;
        }
        if (val.equals("Y")) {
            return Boolean.TRUE;
        }
        if (val.equals("N")) {
            return Boolean.FALSE;
        }
        throw new DatabaseException("Reading boolean from column \"" + col + "\" but the value was not 'Y' or 'N'");
    }

    private Integer toInteger(ResultSet rs, int col) throws SQLException {
        int val = rs.getInt(col);
        return rs.wasNull() ? null : Integer.valueOf(val);
    }

    private Integer toInteger(ResultSet rs, String col) throws SQLException {
        int val = rs.getInt(col);
        return rs.wasNull() ? null : Integer.valueOf(val);
    }

    private Long toLong(ResultSet rs, int col) throws SQLException {
        long val = rs.getLong(col);
        return rs.wasNull() ? null : Long.valueOf(val);
    }

    private Long toLong(ResultSet rs, String col) throws SQLException {
        long val = rs.getLong(col);
        return rs.wasNull() ? null : Long.valueOf(val);
    }

    private Float toFloat(ResultSet rs, int col) throws SQLException {
        float val = rs.getFloat(col);
        return rs.wasNull() ? null : Float.valueOf(val);
    }

    private Float toFloat(ResultSet rs, String col) throws SQLException {
        float val = rs.getFloat(col);
        return rs.wasNull() ? null : Float.valueOf(val);
    }

    private Double toDouble(ResultSet rs, int col) throws SQLException {
        double val = rs.getDouble(col);
        return rs.wasNull() ? null : Double.valueOf(val);
    }

    private Double toDouble(ResultSet rs, String col) throws SQLException {
        double val = rs.getDouble(col);
        return rs.wasNull() ? null : Double.valueOf(val);
    }

    private BigDecimal fixBigDecimal(BigDecimal val) {
        if (val.scale() > 0 && (val = val.stripTrailingZeros()).scale() < 0) {
            val = val.setScale(0);
        }
        return val;
    }

    private BigDecimal toBigDecimal(ResultSet rs, int col) throws SQLException {
        BigDecimal val = rs.getBigDecimal(col);
        return val == null ? null : this.fixBigDecimal(val);
    }

    private BigDecimal toBigDecimal(ResultSet rs, String col) throws SQLException {
        BigDecimal val = rs.getBigDecimal(col);
        return val == null ? null : this.fixBigDecimal(val);
    }
}

