/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.Flavor;
import com.github.susom.database.Row;
import com.github.susom.database.Sql;
import com.github.susom.database.SqlArgs;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class Schema {
    private List<Table> tables = new ArrayList<Table>();
    private List<Sequence> sequences = new ArrayList<Sequence>();
    private boolean indexForeignKeys = true;
    private String userTableName = "user_principal";

    public Sequence addSequence(String name) {
        Sequence sequence = new Sequence(name);
        this.sequences.add(sequence);
        return sequence;
    }

    public Schema withoutForeignKeyIndexing() {
        this.indexForeignKeys = false;
        return this;
    }

    public Schema userTableName(String userTableName) {
        this.userTableName = userTableName;
        return this;
    }

    public void validate() {
        for (Table t : this.tables) {
            t.validate();
        }
        for (Sequence s : this.sequences) {
            s.validate();
        }
    }

    public Table addTable(String name) {
        Table table = new Table(name);
        this.tables.add(table);
        return table;
    }

    public Table addTableFromRow(String tableName, Row r) {
        Table table = this.addTable(tableName);
        try {
            int i;
            ResultSetMetaData metadata = r.getMetadata();
            int columnCount = metadata.getColumnCount();
            String[] names = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                names[i] = metadata.getColumnName(i + 1);
            }
            names = SqlArgs.tidyColumnNames(names);
            block15: for (i = 0; i < columnCount; ++i) {
                int type = metadata.getColumnType(i + 1);
                switch (type) {
                    case 4: 
                    case 5: {
                        table.addColumn(names[i]).asInteger();
                        continue block15;
                    }
                    case -5: {
                        table.addColumn(names[i]).asLong();
                        continue block15;
                    }
                    case 7: 
                    case 100: {
                        table.addColumn(names[i]).asFloat();
                        continue block15;
                    }
                    case 8: 
                    case 101: {
                        table.addColumn(names[i]).asDouble();
                        continue block15;
                    }
                    case 2: {
                        int precision1 = metadata.getPrecision(i + 1);
                        int scale = metadata.getScale(i + 1);
                        if (precision1 == 10 && scale == 0) {
                            table.addColumn(names[i]).asInteger();
                            continue block15;
                        }
                        if (precision1 == 19 && scale == 0) {
                            table.addColumn(names[i]).asLong();
                            continue block15;
                        }
                        table.addColumn(names[i]).asBigDecimal(precision1, scale);
                        continue block15;
                    }
                    case -3: 
                    case -2: 
                    case 2004: {
                        table.addColumn(names[i]).asBlob();
                        continue block15;
                    }
                    case 2005: 
                    case 2011: {
                        table.addColumn(names[i]).asClob();
                        continue block15;
                    }
                    case 93: {
                        table.addColumn(names[i]).asDate();
                        continue block15;
                    }
                    case -9: 
                    case 12: {
                        int precision = metadata.getPrecision(i + 1);
                        if (precision >= Integer.MAX_VALUE) {
                            table.addColumn(names[i]).asClob();
                            continue block15;
                        }
                        table.addColumn(names[i]).asString(precision);
                        continue block15;
                    }
                    case -15: 
                    case 1: {
                        table.addColumn(names[i]).asStringFixed(metadata.getPrecision(i + 1));
                        continue block15;
                    }
                    default: {
                        throw new DatabaseException("Don't know what type to use for: " + type);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException("Unable to retrieve metadata from ResultSet", e);
        }
        return table;
    }

    public void execute(Supplier<Database> db) {
        this.executeOrPrint(db.get(), null);
    }

    public String print(Flavor flavor) {
        return this.executeOrPrint(null, flavor);
    }

    private String executeOrPrint(Database db, Flavor flavor) {
        Sql sql;
        Object sql2;
        this.validate();
        if (flavor == null) {
            flavor = db.flavor();
        }
        StringBuilder script = new StringBuilder();
        for (Table table : this.tables) {
            sql2 = new Sql();
            ((Sql)sql2).append("create table ").append(table.name).append(" (\n");
            boolean first = true;
            for (Table.Column column : table.columns) {
                if (first) {
                    first = false;
                    ((Sql)sql2).append("  ");
                } else {
                    ((Sql)sql2).append(",\n  ");
                }
                ((Sql)sql2).append(this.rpad(column.name, 30)).append(" ");
                switch (column.type) {
                    case Boolean: {
                        ((Sql)sql2).append(flavor.typeBoolean());
                        break;
                    }
                    case Integer: {
                        ((Sql)sql2).append(flavor.typeInteger());
                        break;
                    }
                    case Long: {
                        ((Sql)sql2).append(flavor.typeLong());
                        break;
                    }
                    case Float: {
                        ((Sql)sql2).append(flavor.typeFloat());
                        break;
                    }
                    case Double: {
                        ((Sql)sql2).append(flavor.typeDouble());
                        break;
                    }
                    case BigDecimal: {
                        ((Sql)sql2).append(flavor.typeBigDecimal(column.scale, column.precision));
                        break;
                    }
                    case StringVar: {
                        ((Sql)sql2).append(flavor.typeStringVar(column.scale));
                        break;
                    }
                    case StringFixed: {
                        ((Sql)sql2).append(flavor.typeStringFixed(column.scale));
                        break;
                    }
                    case Date: {
                        ((Sql)sql2).append(flavor.typeDate());
                        break;
                    }
                    case Clob: {
                        ((Sql)sql2).append(flavor.typeClob());
                        break;
                    }
                    case Blob: {
                        ((Sql)sql2).append(flavor.typeBlob());
                    }
                }
                if (!column.notNull) continue;
                ((Sql)sql2).append(" not null");
            }
            if (table.primaryKey != null) {
                ((Sql)sql2).append(",\n  constraint ");
                ((Sql)sql2).append(this.rpad(table.primaryKey.name, 30));
                ((Sql)sql2).listStart(" primary key (");
                for (String name : table.primaryKey.columnNames) {
                    ((Sql)sql2).listSeparator(", ");
                    ((Sql)sql2).append(name);
                }
                ((Sql)sql2).listEnd(")");
            }
            for (Table.Unique u : table.uniques) {
                ((Sql)sql2).append(",\n  constraint ");
                ((Sql)sql2).append(this.rpad(u.name, 30));
                ((Sql)sql2).listStart(" unique (");
                for (String name : u.columnNames) {
                    ((Sql)sql2).listSeparator(", ");
                    ((Sql)sql2).append(name);
                }
                ((Sql)sql2).listEnd(")");
            }
            for (Table.Check check : table.checks) {
                ((Sql)sql2).append(",\n  constraint ");
                ((Sql)sql2).append(this.rpad(check.name, 30));
                ((Sql)sql2).append(" check (");
                ((Sql)sql2).append(check.expression);
                ((Sql)sql2).append(")");
            }
            ((Sql)sql2).append("\n)");
            if (table.customClauses.containsKey((Object)flavor)) {
                ((Sql)sql2).append(" ").append((String)table.customClauses.get((Object)flavor));
            }
            this.executeOrPrint((Sql)sql2, db, script);
            sql2 = new Sql();
            if (flavor != Flavor.oracle && flavor != Flavor.postgresql) continue;
            if (table.comment != null) {
                ((Sql)sql2).append("comment on table ");
                ((Sql)sql2).append(table.name);
                ((Sql)sql2).append(" is \n'");
                ((Sql)sql2).append(table.comment.replace("'", "''"));
                ((Sql)sql2).append("'");
                this.executeOrPrint((Sql)sql2, db, script);
                sql2 = new Sql();
            }
            for (Table.Column c : table.columns) {
                if (c.comment == null) continue;
                ((Sql)sql2).append("comment on column ");
                ((Sql)sql2).append(table.name);
                ((Sql)sql2).append(".");
                ((Sql)sql2).append(c.name);
                ((Sql)sql2).append(" is \n'");
                ((Sql)sql2).append(c.comment.replace("'", "''"));
                ((Sql)sql2).append("'");
                this.executeOrPrint((Sql)sql2, db, script);
                sql2 = new Sql();
            }
        }
        for (Table table : this.tables) {
            for (Table.ForeignKey fk : table.foreignKeys) {
                sql = new Sql();
                sql.append("alter table ");
                sql.append(table.name);
                sql.append(" add constraint ");
                sql.append(fk.name);
                sql.listStart("\n  foreign key (");
                for (String name : fk.columnNames) {
                    sql.listSeparator(", ");
                    sql.append(name);
                }
                sql.listEnd(") references ");
                sql.append(fk.foreignTable);
                this.executeOrPrint(sql, db, script);
            }
        }
        for (Table table : this.tables) {
            for (Table.Index index : table.indexes) {
                sql = new Sql();
                sql.append("create index ");
                sql.append(index.name);
                sql.append(" on ");
                sql.append(table.name);
                sql.listStart(" (");
                for (String name : index.columnNames) {
                    sql.listSeparator(", ");
                    sql.append(name);
                }
                sql.listEnd(")");
                this.executeOrPrint(sql, db, script);
            }
        }
        for (Sequence sequence : this.sequences) {
            sql2 = new Sql();
            ((Sql)sql2).append("create sequence ");
            ((Sql)sql2).append(sequence.name);
            ((Sql)sql2).append(flavor.sequenceOptions());
            ((Sql)sql2).append(" minvalue ");
            ((Sql)sql2).append(sequence.min);
            ((Sql)sql2).append(" maxvalue ");
            ((Sql)sql2).append(sequence.max);
            ((Sql)sql2).append(" start with ");
            ((Sql)sql2).append(sequence.start);
            ((Sql)sql2).append(" increment by ");
            ((Sql)sql2).append(sequence.increment);
            ((Sql)sql2).append(flavor.sequenceCacheClause(sequence.cache));
            ((Sql)sql2).append(flavor.sequenceOrderClause(sequence.order));
            ((Sql)sql2).append(flavor.sequenceCycleClause(sequence.cycle));
            this.executeOrPrint((Sql)sql2, db, script);
        }
        if (db == null) {
            return script.toString();
        }
        return null;
    }

    private void executeOrPrint(Sql sql, Database db, StringBuilder script) {
        if (db != null) {
            db.ddl(sql.toString()).execute();
        } else {
            script.append(sql.toString());
            script.append(";\n\n");
        }
    }

    private String toName(String name) {
        if (!(name = name.toLowerCase().trim()).matches("[a-z][a-z0-9_]{0,28}[a-z0-9]?")) {
            throw new IllegalArgumentException("Identifier name should match pattern [a-z][a-z0-9_]{0,28}[a-z0-9]?");
        }
        return name;
    }

    private String rpad(String s, int size) {
        if (s.length() < size) {
            s = s + "                                                       ".substring(0, size - s.length());
        }
        return s;
    }

    public class Table {
        private final String name;
        private String comment;
        private List<Column> columns = new ArrayList<Column>();
        private PrimaryKey primaryKey;
        private List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
        private List<Index> indexes = new ArrayList<Index>();
        private List<Check> checks = new ArrayList<Check>();
        private List<Unique> uniques = new ArrayList<Unique>();
        private Map<Flavor, String> customClauses = new HashMap<Flavor, String>();
        private boolean createTracking;
        private String createTrackingFkName;
        private String createTrackingFkTable;
        private boolean updateTracking;
        private String updateTrackingFkName;
        private String updateTrackingFkTable;
        private boolean updateSequence;
        private boolean historyTable;

        public Table(String name) {
            this.name = Schema.this.toName(name);
            if (this.name.length() > 27) {
                throw new RuntimeException("Table name should be 27 characters or less");
            }
        }

        public void validate() {
            if (this.columns.size() < 1) {
                throw new RuntimeException("Table " + this.name + " needs at least one column");
            }
            for (Column column : this.columns) {
                column.validate();
            }
            if (this.primaryKey != null) {
                this.primaryKey.validate();
            }
            for (ForeignKey foreignKey : this.foreignKeys) {
                foreignKey.validate();
            }
            for (Check check : this.checks) {
                check.validate();
            }
            for (Index index : this.indexes) {
                index.validate();
            }
        }

        public Schema schema() {
            if (this.createTracking) {
                this.addColumn("create_time").asDate().table();
            }
            if (this.createTrackingFkName != null) {
                this.addColumn("create_user").foreignKey(this.createTrackingFkName).references(this.createTrackingFkTable).table();
            }
            if (this.updateTracking || this.updateSequence) {
                this.addColumn("update_time").asDate().table();
            }
            if (this.updateTrackingFkName != null) {
                this.addColumn("update_user").foreignKey(this.updateTrackingFkName).references(this.updateTrackingFkTable).table();
            }
            if (this.updateSequence) {
                this.addColumn("update_sequence").asLong().table();
            }
            if (Schema.this.indexForeignKeys) {
                for (ForeignKey fk : this.foreignKeys) {
                    if (this.primaryKey != null && fk.columnNames.equals(this.primaryKey.columnNames)) continue;
                    boolean skip = false;
                    for (Index i : this.indexes) {
                        if (!fk.columnNames.equals(i.columnNames)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    this.addIndex(fk.name + "_ix", fk.columnNames.toArray(new String[fk.columnNames.size()]));
                }
            }
            this.validate();
            if (this.historyTable) {
                String historyTableName = this.name + "_history";
                if (historyTableName.length() > 27 && historyTableName.length() <= 30) {
                    historyTableName = this.name + "_hist";
                }
                Table hist = Schema.this.addTable(historyTableName);
                hist.columns.addAll(this.columns);
                hist.addColumn("is_deleted").asBoolean().table();
                ArrayList<String> pkColumns = new ArrayList<String>();
                pkColumns.addAll(this.primaryKey.columnNames);
                hist.addIndex(historyTableName + "_ix", pkColumns.toArray(new String[pkColumns.size()]));
                pkColumns.add("update_sequence");
                hist.addPrimaryKey(historyTableName + "_pk", pkColumns.toArray(new String[pkColumns.size()]));
                hist.schema();
            }
            return Schema.this;
        }

        public Table withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Table withStandardPk() {
            return this.addColumn(this.name + "_id").primaryKey().table();
        }

        public Table trackCreateTime() {
            this.createTracking = true;
            return this;
        }

        public Table trackCreateTimeAndUser(String fkConstraintName) {
            return this.trackCreateTimeAndUser(fkConstraintName, Schema.this.userTableName);
        }

        public Table trackCreateTimeAndUser(String fkConstraintName, String fkReferencesTable) {
            this.createTracking = true;
            this.createTrackingFkName = fkConstraintName;
            this.createTrackingFkTable = fkReferencesTable;
            return this;
        }

        public Table trackUpdateTime() {
            this.updateTracking = true;
            this.updateSequence = true;
            return this;
        }

        public Table trackUpdateTimeAndUser(String fkConstraintName) {
            return this.trackUpdateTimeAndUser(fkConstraintName, Schema.this.userTableName);
        }

        public Table trackUpdateTimeAndUser(String fkConstraintName, String fkReferencesTable) {
            this.updateTracking = true;
            this.updateSequence = true;
            this.updateTrackingFkName = fkConstraintName;
            this.updateTrackingFkTable = fkReferencesTable;
            return this;
        }

        public Table withHistoryTable() {
            this.updateSequence = true;
            this.historyTable = true;
            return this;
        }

        public Column addColumn(String name) {
            Column column = new Column(name);
            this.columns.add(column);
            return column;
        }

        public PrimaryKey addPrimaryKey(String name, String ... columnNames) {
            if (this.primaryKey != null) {
                throw new RuntimeException("Only one primary key is allowed. For composite keys use addPrimaryKey(name, c1, c2, ...).");
            }
            this.primaryKey = new PrimaryKey(name, columnNames);
            return this.primaryKey;
        }

        public ForeignKey addForeignKey(String name, String ... columnNames) {
            ForeignKey foreignKey = new ForeignKey(name, columnNames);
            this.foreignKeys.add(foreignKey);
            return foreignKey;
        }

        public Check addCheck(String name, String expression) {
            Check check = new Check(name, expression);
            this.checks.add(check);
            return check;
        }

        public Unique addUnique(String name, String ... columnNames) {
            Unique unique = new Unique(name, columnNames);
            this.uniques.add(unique);
            return unique;
        }

        public Index addIndex(String name, String ... columnNames) {
            Index index = new Index(name, columnNames);
            this.indexes.add(index);
            return index;
        }

        public Table customTableClause(Flavor flavor, String clause) {
            this.customClauses.put(flavor, clause);
            return this;
        }

        public class Column {
            private final String name;
            private ColumnType type;
            private int scale;
            private int precision;
            private boolean notNull;
            private String comment;

            public Column(String name) {
                this.name = Schema.this.toName(name);
            }

            public Column asBoolean() {
                return this.asType(ColumnType.Boolean);
            }

            public Column asBoolean(String checkConstraintName) {
                return this.asBoolean().check(checkConstraintName, this.name + " in ('Y', 'N')");
            }

            public Column asInteger() {
                return this.asType(ColumnType.Integer);
            }

            public Column asLong() {
                return this.asType(ColumnType.Long);
            }

            public Column asFloat() {
                return this.asType(ColumnType.Float);
            }

            public Column asDouble() {
                return this.asType(ColumnType.Double);
            }

            public Column asBigDecimal(int scale, int precision) {
                this.scale = scale;
                this.precision = precision;
                return this.asType(ColumnType.BigDecimal);
            }

            public Column asString(int scale) {
                this.scale = scale;
                return this.asType(ColumnType.StringVar);
            }

            public Column asStringFixed(int scale) {
                this.scale = scale;
                return this.asType(ColumnType.StringFixed);
            }

            public Column asDate() {
                return this.asType(ColumnType.Date);
            }

            public Column asClob() {
                return this.asType(ColumnType.Clob);
            }

            public Column asBlob() {
                return this.asType(ColumnType.Blob);
            }

            private Column asType(ColumnType type) {
                this.type = type;
                return this;
            }

            public Column notNull() {
                this.notNull = true;
                return this;
            }

            private void validate() {
                if (this.type == null) {
                    throw new RuntimeException("Call as*() on column " + this.name + " table " + Table.this.name);
                }
            }

            public Table table() {
                this.validate();
                return Table.this;
            }

            public ForeignKey foreignKey(String constraintName) {
                if (this.type == null) {
                    this.asLong();
                }
                return this.table().addForeignKey(constraintName, this.name);
            }

            public Column check(String checkConstraintName, String expression) {
                this.table().addCheck(checkConstraintName, expression).table();
                return this;
            }

            public Column primaryKey() {
                if (this.type == null) {
                    this.asLong();
                }
                if (this.comment == null) {
                    this.comment = "Internally generated primary key";
                }
                this.notNull();
                Table.this.addPrimaryKey(Table.this.name + "_pk", this.name);
                return this;
            }

            public Column unique(String constraintName) {
                this.notNull();
                Table.this.addUnique(constraintName, this.name);
                return this;
            }

            public Column withComment(String comment) {
                this.comment = comment;
                return this;
            }

            public Schema schema() {
                return this.table().schema();
            }
        }

        public class Index {
            private final String name;
            private final List<String> columnNames = new ArrayList<String>();
            private boolean unique;

            public Index(String name, String[] columnNames) {
                this.name = Schema.this.toName(name);
                for (String s : columnNames) {
                    this.columnNames.add(Schema.this.toName(s));
                }
            }

            public Index unique() {
                this.unique = true;
                return this;
            }

            private void validate() {
                if (this.columnNames.size() < 1) {
                    throw new RuntimeException("Index " + this.name + " needs at least one column");
                }
            }

            public Table table() {
                this.validate();
                return Table.this;
            }
        }

        public class Check {
            private final String name;
            private final String expression;

            public Check(String name, String expression) {
                this.name = Schema.this.toName(name);
                this.expression = expression;
            }

            private void validate() {
                if (this.expression == null) {
                    throw new RuntimeException("Expression needed for check constraint " + this.name + " on table " + Table.this.name);
                }
            }

            public Table table() {
                this.validate();
                return Table.this;
            }
        }

        public class ForeignKey {
            private final String name;
            private final List<String> columnNames = new ArrayList<String>();
            public String foreignTable;

            public ForeignKey(String name, String[] columnNames) {
                this.name = Schema.this.toName(name);
                for (String s : columnNames) {
                    this.columnNames.add(Schema.this.toName(s));
                }
            }

            public ForeignKey references(String tableName) {
                this.foreignTable = Schema.this.toName(tableName);
                return this;
            }

            private void validate() {
                if (this.foreignTable == null) {
                    throw new RuntimeException("Foreign key " + this.name + " must reference a table");
                }
            }

            public Table table() {
                this.validate();
                return Table.this;
            }
        }

        public class Unique {
            private final String name;
            private final List<String> columnNames = new ArrayList<String>();

            public Unique(String name, String[] columnNames) {
                this.name = Schema.this.toName(name);
                for (String s : columnNames) {
                    this.columnNames.add(Schema.this.toName(s));
                }
            }

            public void validate() {
            }

            public Table table() {
                this.validate();
                return Table.this;
            }
        }

        public class PrimaryKey {
            private final String name;
            private final List<String> columnNames = new ArrayList<String>();

            public PrimaryKey(String name, String[] columnNames) {
                this.name = Schema.this.toName(name);
                for (String s : columnNames) {
                    this.columnNames.add(Schema.this.toName(s));
                }
            }

            public void validate() {
            }

            public Table table() {
                this.validate();
                return Table.this;
            }
        }
    }

    public class Sequence {
        private final String name;
        private long min = 1L;
        private long max = 999999999999999999L;
        private int increment = 1;
        private long start = 1L;
        private int cache = 20;
        private boolean order;
        private boolean cycle;

        public Sequence(String name) {
            this.name = Schema.this.toName(name);
        }

        public Sequence min(long min) {
            if (this.start == this.min) {
                this.start = min;
            }
            this.min = min;
            return this;
        }

        public Sequence max(long max) {
            this.max = max;
            return this;
        }

        public Sequence increment(int increment) {
            this.increment = increment;
            return this;
        }

        public Sequence start(long start) {
            this.start = start;
            return this;
        }

        public Sequence cache(int cache) {
            this.cache = cache;
            return this;
        }

        public Sequence order() {
            this.order = true;
            return this;
        }

        public Sequence cycle() {
            this.cycle = true;
            return this;
        }

        private void validate() {
        }

        public Schema schema() {
            this.validate();
            return Schema.this;
        }
    }

    public static enum ColumnType {
        Integer,
        Long,
        Float,
        Double,
        BigDecimal,
        StringVar,
        StringFixed,
        Clob,
        Blob,
        Date,
        Boolean;

    }
}

