/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import com.github.susom.database.SqlArgs;
import com.github.susom.database.SqlInsert;
import com.github.susom.database.SqlSelect;
import com.github.susom.database.SqlUpdate;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Sql
implements SqlInsert.Apply,
SqlUpdate.Apply,
SqlSelect.Apply {
    private StringBuilder sql = new StringBuilder();
    private Stack<Boolean> listFirstItem = new Stack();
    private String finalSql;
    private List<SqlArgs> batched;
    private SqlArgs sqlArgs = new SqlArgs();

    public Sql() {
    }

    public Sql(String sql) {
        this.sql.append(sql);
    }

    public static Sql insert(String table, SqlArgs args) {
        return Sql.insert(table, Collections.singletonList(args));
    }

    public static Sql insert(String table, List<SqlArgs> args) {
        Sql sql = null;
        List<String> expectedColumns = null;
        for (SqlArgs arg : args) {
            if (arg.positionalCount() > 0) {
                throw new DatabaseException("The SqlArgs must all be named to do this");
            }
            List<String> columns = arg.names();
            if (columns.size() < 1) {
                throw new DatabaseException("You must add named arguments to SqlArgs");
            }
            if (sql == null) {
                expectedColumns = columns;
                sql = new Sql("insert into ").append(table);
                sql.listStart(" (");
                for (String column : columns) {
                    sql.listSeparator(",");
                    sql.append(column);
                }
                sql.listEnd(") values (");
                sql.appendQuestionMarks(columns.size());
                sql.append(")");
            } else {
                if (!expectedColumns.equals(columns)) {
                    throw new DatabaseException("The columns for all rows in a batch must match. \nFirst: " + expectedColumns + "\nCurrent: " + columns);
                }
                sql.batch();
            }
            sql.setSqlArgs(arg.makePositional());
        }
        return sql;
    }

    public Sql setSqlArgs(SqlArgs args) {
        this.sqlArgs = args;
        return this;
    }

    public Sql batch() {
        if (this.sqlArgs.argCount() > 0) {
            if (this.batched == null) {
                this.batched = new ArrayList<SqlArgs>();
            }
            this.batched.add(this.sqlArgs);
            this.sqlArgs = new SqlArgs();
        }
        return this;
    }

    public int argCount() {
        return this.sqlArgs.argCount();
    }

    public Sql appendQuestionMarks(int howMany) {
        boolean first = true;
        for (int i = 0; i < howMany; ++i) {
            if (first) {
                first = false;
                this.append("?");
                continue;
            }
            this.append(",?");
        }
        return this;
    }

    public Sql append(String sql) {
        assert (this.finalSql == null);
        this.sql.append(sql);
        return this;
    }

    public Sql append(boolean value) {
        assert (this.finalSql == null);
        this.sql.append(value);
        return this;
    }

    public Sql append(int value) {
        assert (this.finalSql == null);
        this.sql.append(value);
        return this;
    }

    public Sql append(long value) {
        assert (this.finalSql == null);
        this.sql.append(value);
        return this;
    }

    public Sql append(float value) {
        assert (this.finalSql == null);
        this.sql.append(value);
        return this;
    }

    public Sql append(double value) {
        assert (this.finalSql == null);
        this.sql.append(value);
        return this;
    }

    public Sql deleteCharAt(int index) {
        assert (this.finalSql == null);
        this.sql.deleteCharAt(index);
        return this;
    }

    public Sql replace(int start, int end, String str) {
        assert (this.finalSql == null);
        this.sql.replace(start, end, str);
        return this;
    }

    public Sql insert(int offset, String str) {
        assert (this.finalSql == null);
        this.sql.insert(offset, str);
        return this;
    }

    public Sql insert(int offset, boolean value) {
        assert (this.finalSql == null);
        this.sql.insert(offset, value);
        return this;
    }

    public Sql insert(int offset, int value) {
        assert (this.finalSql == null);
        this.sql.insert(offset, value);
        return this;
    }

    public Sql insert(int offset, long value) {
        assert (this.finalSql == null);
        this.sql.insert(offset, value);
        return this;
    }

    public Sql insert(int offset, double value) {
        assert (this.finalSql == null);
        this.sql.insert(offset, value);
        return this;
    }

    public Sql insert(int offset, float value) {
        assert (this.finalSql == null);
        this.sql.insert(offset, value);
        return this;
    }

    public int indexOf(String str) {
        return this.sql.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.sql.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.sql.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.sql.lastIndexOf(str, fromIndex);
    }

    public Sql listStart(String sql) {
        this.listFirstItem.push(true);
        return this.append(sql);
    }

    public Sql listSeparator(String sql) {
        if (this.listFirstItem.peek().booleanValue()) {
            this.listFirstItem.pop();
            this.listFirstItem.push(false);
            return this;
        }
        return this.append(sql);
    }

    public Sql listEnd(String sql) {
        this.listFirstItem.pop();
        return this.append(sql);
    }

    public String sql() {
        if (this.finalSql == null) {
            this.finalSql = this.sql.toString();
        }
        return this.finalSql;
    }

    public String toString() {
        return this.sql();
    }

    @Nonnull
    public Sql argBoolean(@Nullable Boolean arg) {
        this.sqlArgs.argBoolean(arg);
        return this;
    }

    @Nonnull
    public Sql argBoolean(@Nonnull String argName, @Nullable Boolean arg) {
        this.sqlArgs.argBoolean(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argInteger(@Nullable Integer arg) {
        this.sqlArgs.argInteger(arg);
        return this;
    }

    @Nonnull
    public Sql argInteger(@Nonnull String argName, @Nullable Integer arg) {
        this.sqlArgs.argInteger(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argLong(@Nullable Long arg) {
        this.sqlArgs.argLong(arg);
        return this;
    }

    @Nonnull
    public Sql argLong(@Nonnull String argName, @Nullable Long arg) {
        this.sqlArgs.argLong(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argFloat(@Nullable Float arg) {
        this.sqlArgs.argFloat(arg);
        return this;
    }

    @Nonnull
    public Sql argFloat(@Nonnull String argName, @Nullable Float arg) {
        this.sqlArgs.argFloat(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argDouble(@Nullable Double arg) {
        this.sqlArgs.argDouble(arg);
        return this;
    }

    @Nonnull
    public Sql argDouble(@Nonnull String argName, @Nullable Double arg) {
        this.sqlArgs.argDouble(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argBigDecimal(@Nullable BigDecimal arg) {
        this.sqlArgs.argBigDecimal(arg);
        return this;
    }

    @Nonnull
    public Sql argBigDecimal(@Nonnull String argName, @Nullable BigDecimal arg) {
        this.sqlArgs.argBigDecimal(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argString(@Nullable String arg) {
        this.sqlArgs.argString(arg);
        return this;
    }

    @Nonnull
    public Sql argString(@Nonnull String argName, @Nullable String arg) {
        this.sqlArgs.argString(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argDate(@Nullable Date arg) {
        this.sqlArgs.argDate(arg);
        return this;
    }

    @Nonnull
    public Sql argDate(@Nonnull String argName, @Nullable Date arg) {
        this.sqlArgs.argDate(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argDateNowPerApp() {
        this.sqlArgs.argDateNowPerApp();
        return this;
    }

    @Nonnull
    public Sql argDateNowPerApp(@Nonnull String argName) {
        this.sqlArgs.argDateNowPerApp(argName);
        return this;
    }

    @Nonnull
    public Sql argDateNowPerDb() {
        this.sqlArgs.argDateNowPerDb();
        return this;
    }

    @Nonnull
    public Sql argDateNowPerDb(@Nonnull String argName) {
        this.sqlArgs.argDateNowPerDb(argName);
        return this;
    }

    @Nonnull
    public Sql argBlobBytes(@Nullable byte[] arg) {
        this.sqlArgs.argBlobBytes(arg);
        return this;
    }

    @Nonnull
    public Sql argBlobBytes(@Nonnull String argName, @Nullable byte[] arg) {
        this.sqlArgs.argBlobBytes(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argBlobInputStream(@Nullable InputStream arg) {
        this.sqlArgs.argBlobInputStream(arg);
        return this;
    }

    @Nonnull
    public Sql argBlobInputStream(@Nonnull String argName, @Nullable InputStream arg) {
        this.sqlArgs.argBlobInputStream(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argClobString(@Nullable String arg) {
        this.sqlArgs.argClobString(arg);
        return this;
    }

    @Nonnull
    public Sql argClobString(@Nonnull String argName, @Nullable String arg) {
        this.sqlArgs.argClobString(argName, arg);
        return this;
    }

    @Nonnull
    public Sql argClobReader(@Nullable Reader arg) {
        this.sqlArgs.argClobReader(arg);
        return this;
    }

    @Nonnull
    public Sql argClobReader(@Nonnull String argName, @Nullable Reader arg) {
        this.sqlArgs.argClobReader(argName, arg);
        return this;
    }

    @Override
    public void apply(SqlSelect select) {
        if (this.batched != null) {
            throw new DatabaseException("Batch not supported for select");
        }
        this.sqlArgs.apply(select);
    }

    @Override
    public void apply(SqlInsert insert) {
        if (this.batched != null) {
            this.batch();
            for (SqlArgs args : this.batched) {
                args.apply(insert);
                insert.batch();
            }
        } else {
            this.sqlArgs.apply(insert);
        }
    }

    @Override
    public void apply(SqlUpdate update) {
        if (this.batched != null) {
            throw new DatabaseException("Batch not supported for update");
        }
        this.sqlArgs.apply(update);
    }

    private static class Invocation {
        ColumnType columnType;
        String argName;
        Object arg;

        Invocation(ColumnType columnType, String argName, Object arg) {
            this.columnType = columnType;
            this.argName = argName;
            this.arg = arg;
        }
    }

    public static enum ColumnType {
        Integer,
        Long,
        Float,
        Double,
        BigDecimal,
        String,
        ClobString,
        ClobStream,
        BlobBytes,
        BlobStream,
        Date,
        DateNowPerApp,
        DateNowPerDb,
        Boolean;

    }
}

