/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import com.github.susom.database.Row;
import com.github.susom.database.SqlInsert;
import com.github.susom.database.SqlSelect;
import com.github.susom.database.SqlUpdate;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlArgs
implements SqlInsert.Apply,
SqlUpdate.Apply,
SqlSelect.Apply {
    private List<Invocation> invocations = new ArrayList<Invocation>();

    @Nonnull
    public SqlArgs argBoolean(@Nullable Boolean arg) {
        this.invocations.add(new Invocation(ColumnType.Boolean, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBoolean(@Nonnull String argName, @Nullable Boolean arg) {
        this.invocations.add(new Invocation(ColumnType.Boolean, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argInteger(@Nullable Integer arg) {
        this.invocations.add(new Invocation(ColumnType.Integer, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argInteger(@Nonnull String argName, @Nullable Integer arg) {
        this.invocations.add(new Invocation(ColumnType.Integer, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argLong(@Nullable Long arg) {
        this.invocations.add(new Invocation(ColumnType.Long, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argLong(@Nonnull String argName, @Nullable Long arg) {
        this.invocations.add(new Invocation(ColumnType.Long, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argFloat(@Nullable Float arg) {
        this.invocations.add(new Invocation(ColumnType.Float, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argFloat(@Nonnull String argName, @Nullable Float arg) {
        this.invocations.add(new Invocation(ColumnType.Float, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argDouble(@Nullable Double arg) {
        this.invocations.add(new Invocation(ColumnType.Double, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argDouble(@Nonnull String argName, @Nullable Double arg) {
        this.invocations.add(new Invocation(ColumnType.Double, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBigDecimal(@Nullable BigDecimal arg) {
        this.invocations.add(new Invocation(ColumnType.BigDecimal, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBigDecimal(@Nonnull String argName, @Nullable BigDecimal arg) {
        this.invocations.add(new Invocation(ColumnType.BigDecimal, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argString(@Nullable String arg) {
        this.invocations.add(new Invocation(ColumnType.String, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argString(@Nonnull String argName, @Nullable String arg) {
        this.invocations.add(new Invocation(ColumnType.String, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argDate(@Nullable Date arg) {
        this.invocations.add(new Invocation(ColumnType.Date, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argDate(@Nonnull String argName, @Nullable Date arg) {
        this.invocations.add(new Invocation(ColumnType.Date, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argDateNowPerApp() {
        this.invocations.add(new Invocation(ColumnType.DateNowPerApp, null, null));
        return this;
    }

    @Nonnull
    public SqlArgs argDateNowPerApp(@Nonnull String argName) {
        this.invocations.add(new Invocation(ColumnType.DateNowPerApp, argName, null));
        return this;
    }

    @Nonnull
    public SqlArgs argDateNowPerDb() {
        this.invocations.add(new Invocation(ColumnType.DateNowPerDb, null, null));
        return this;
    }

    @Nonnull
    public SqlArgs argDateNowPerDb(@Nonnull String argName) {
        this.invocations.add(new Invocation(ColumnType.DateNowPerDb, argName, null));
        return this;
    }

    @Nonnull
    public SqlArgs argBlobBytes(@Nullable byte[] arg) {
        this.invocations.add(new Invocation(ColumnType.BlobBytes, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBlobBytes(@Nonnull String argName, @Nullable byte[] arg) {
        this.invocations.add(new Invocation(ColumnType.BlobBytes, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBlobInputStream(@Nullable InputStream arg) {
        this.invocations.add(new Invocation(ColumnType.BlobStream, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argBlobInputStream(@Nonnull String argName, @Nullable InputStream arg) {
        this.invocations.add(new Invocation(ColumnType.BlobStream, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argClobString(@Nullable String arg) {
        this.invocations.add(new Invocation(ColumnType.ClobString, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argClobString(@Nonnull String argName, @Nullable String arg) {
        this.invocations.add(new Invocation(ColumnType.ClobString, argName, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argClobReader(@Nullable Reader arg) {
        this.invocations.add(new Invocation(ColumnType.ClobStream, null, arg));
        return this;
    }

    @Nonnull
    public SqlArgs argClobReader(@Nonnull String argName, @Nullable Reader arg) {
        this.invocations.add(new Invocation(ColumnType.ClobStream, argName, arg));
        return this;
    }

    @Nonnull
    public static Builder fromMetadata(Row r) {
        return new Builder(r);
    }

    @Nonnull
    public static SqlArgs readRow(Row r) {
        return new Builder(r).read(r);
    }

    @Nonnull
    public SqlArgs makePositional() {
        for (Invocation invocation : this.invocations) {
            invocation.argName = null;
        }
        return this;
    }

    @Nonnull
    public List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (Invocation invocation : this.invocations) {
            if (invocation.argName == null) continue;
            names.add(invocation.argName);
        }
        return names;
    }

    public int argCount() {
        return this.invocations.size();
    }

    public int positionalCount() {
        int count = 0;
        for (Invocation invocation : this.invocations) {
            if (invocation.argName != null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void apply(SqlSelect select) {
        for (Invocation i : this.invocations) {
            switch (i.columnType) {
                case Boolean: {
                    if (i.argName == null) {
                        select.argBoolean((Boolean)i.arg);
                        break;
                    }
                    select.argBoolean(i.argName, (Boolean)i.arg);
                    break;
                }
                case Integer: {
                    if (i.argName == null) {
                        select.argInteger((Integer)i.arg);
                        break;
                    }
                    select.argInteger(i.argName, (Integer)i.arg);
                    break;
                }
                case Long: {
                    if (i.argName == null) {
                        select.argLong((Long)i.arg);
                        break;
                    }
                    select.argLong(i.argName, (Long)i.arg);
                    break;
                }
                case Float: {
                    if (i.argName == null) {
                        select.argFloat((Float)i.arg);
                        break;
                    }
                    select.argFloat(i.argName, (Float)i.arg);
                    break;
                }
                case Double: {
                    if (i.argName == null) {
                        select.argDouble((Double)i.arg);
                        break;
                    }
                    select.argDouble(i.argName, (Double)i.arg);
                    break;
                }
                case BigDecimal: {
                    if (i.argName == null) {
                        select.argBigDecimal((BigDecimal)i.arg);
                        break;
                    }
                    select.argBigDecimal(i.argName, (BigDecimal)i.arg);
                    break;
                }
                case String: {
                    if (i.argName == null) {
                        select.argString((String)i.arg);
                        break;
                    }
                    select.argString(i.argName, (String)i.arg);
                    break;
                }
                case ClobString: {
                    if (i.argName == null) {
                        select.argString((String)i.arg);
                        break;
                    }
                    select.argString(i.argName, (String)i.arg);
                    break;
                }
                case ClobStream: {
                    throw new DatabaseException("Don't use Clob stream parameters with select statements");
                }
                case BlobBytes: {
                    throw new DatabaseException("Don't use Blob parameters with select statements");
                }
                case BlobStream: {
                    throw new DatabaseException("Don't use Blob parameters with select statements");
                }
                case Date: {
                    if (i.argName == null) {
                        select.argDate((Date)i.arg);
                        break;
                    }
                    select.argDate(i.argName, (Date)i.arg);
                    break;
                }
                case DateNowPerApp: {
                    if (i.argName == null) {
                        select.argDateNowPerApp();
                        break;
                    }
                    select.argDateNowPerApp(i.argName);
                    break;
                }
                case DateNowPerDb: {
                    if (i.argName == null) {
                        select.argDateNowPerDb();
                        break;
                    }
                    select.argDateNowPerDb(i.argName);
                }
            }
        }
    }

    @Override
    public void apply(SqlInsert insert) {
        for (Invocation i : this.invocations) {
            switch (i.columnType) {
                case Boolean: {
                    if (i.argName == null) {
                        insert.argBoolean((Boolean)i.arg);
                        break;
                    }
                    insert.argBoolean(i.argName, (Boolean)i.arg);
                    break;
                }
                case Integer: {
                    if (i.argName == null) {
                        insert.argInteger((Integer)i.arg);
                        break;
                    }
                    insert.argInteger(i.argName, (Integer)i.arg);
                    break;
                }
                case Long: {
                    if (i.argName == null) {
                        insert.argLong((Long)i.arg);
                        break;
                    }
                    insert.argLong(i.argName, (Long)i.arg);
                    break;
                }
                case Float: {
                    if (i.argName == null) {
                        insert.argFloat((Float)i.arg);
                        break;
                    }
                    insert.argFloat(i.argName, (Float)i.arg);
                    break;
                }
                case Double: {
                    if (i.argName == null) {
                        insert.argDouble((Double)i.arg);
                        break;
                    }
                    insert.argDouble(i.argName, (Double)i.arg);
                    break;
                }
                case BigDecimal: {
                    if (i.argName == null) {
                        insert.argBigDecimal((BigDecimal)i.arg);
                        break;
                    }
                    insert.argBigDecimal(i.argName, (BigDecimal)i.arg);
                    break;
                }
                case String: {
                    if (i.argName == null) {
                        insert.argString((String)i.arg);
                        break;
                    }
                    insert.argString(i.argName, (String)i.arg);
                    break;
                }
                case ClobString: {
                    if (i.argName == null) {
                        insert.argClobString((String)i.arg);
                        break;
                    }
                    insert.argClobString(i.argName, (String)i.arg);
                    break;
                }
                case ClobStream: {
                    if (i.argName == null) {
                        insert.argClobReader((Reader)i.arg);
                        break;
                    }
                    insert.argClobReader(i.argName, (Reader)i.arg);
                    break;
                }
                case BlobBytes: {
                    if (i.argName == null) {
                        insert.argBlobBytes((byte[])i.arg);
                        break;
                    }
                    insert.argBlobBytes(i.argName, (byte[])i.arg);
                    break;
                }
                case BlobStream: {
                    if (i.argName == null) {
                        insert.argBlobStream((InputStream)i.arg);
                        break;
                    }
                    insert.argBlobStream(i.argName, (InputStream)i.arg);
                    break;
                }
                case Date: {
                    if (i.argName == null) {
                        insert.argDate((Date)i.arg);
                        break;
                    }
                    insert.argDate(i.argName, (Date)i.arg);
                    break;
                }
                case DateNowPerApp: {
                    if (i.argName == null) {
                        insert.argDateNowPerApp();
                        break;
                    }
                    insert.argDateNowPerApp(i.argName);
                    break;
                }
                case DateNowPerDb: {
                    if (i.argName == null) {
                        insert.argDateNowPerDb();
                        break;
                    }
                    insert.argDateNowPerDb(i.argName);
                }
            }
        }
    }

    @Override
    public void apply(SqlUpdate update) {
        for (Invocation i : this.invocations) {
            switch (i.columnType) {
                case Boolean: {
                    if (i.argName == null) {
                        update.argBoolean((Boolean)i.arg);
                        break;
                    }
                    update.argBoolean(i.argName, (Boolean)i.arg);
                    break;
                }
                case Integer: {
                    if (i.argName == null) {
                        update.argInteger((Integer)i.arg);
                        break;
                    }
                    update.argInteger(i.argName, (Integer)i.arg);
                    break;
                }
                case Long: {
                    if (i.argName == null) {
                        update.argLong((Long)i.arg);
                        break;
                    }
                    update.argLong(i.argName, (Long)i.arg);
                    break;
                }
                case Float: {
                    if (i.argName == null) {
                        update.argFloat((Float)i.arg);
                        break;
                    }
                    update.argFloat(i.argName, (Float)i.arg);
                    break;
                }
                case Double: {
                    if (i.argName == null) {
                        update.argDouble((Double)i.arg);
                        break;
                    }
                    update.argDouble(i.argName, (Double)i.arg);
                    break;
                }
                case BigDecimal: {
                    if (i.argName == null) {
                        update.argBigDecimal((BigDecimal)i.arg);
                        break;
                    }
                    update.argBigDecimal(i.argName, (BigDecimal)i.arg);
                    break;
                }
                case String: {
                    if (i.argName == null) {
                        update.argString((String)i.arg);
                        break;
                    }
                    update.argString(i.argName, (String)i.arg);
                    break;
                }
                case ClobString: {
                    if (i.argName == null) {
                        update.argClobString((String)i.arg);
                        break;
                    }
                    update.argClobString(i.argName, (String)i.arg);
                    break;
                }
                case ClobStream: {
                    if (i.argName == null) {
                        update.argClobReader((Reader)i.arg);
                        break;
                    }
                    update.argClobReader(i.argName, (Reader)i.arg);
                    break;
                }
                case BlobBytes: {
                    if (i.argName == null) {
                        update.argBlobBytes((byte[])i.arg);
                        break;
                    }
                    update.argBlobBytes(i.argName, (byte[])i.arg);
                    break;
                }
                case BlobStream: {
                    if (i.argName == null) {
                        update.argBlobStream((InputStream)i.arg);
                        break;
                    }
                    update.argBlobStream(i.argName, (InputStream)i.arg);
                    break;
                }
                case Date: {
                    if (i.argName == null) {
                        update.argDate((Date)i.arg);
                        break;
                    }
                    update.argDate(i.argName, (Date)i.arg);
                    break;
                }
                case DateNowPerApp: {
                    if (i.argName == null) {
                        update.argDateNowPerApp();
                        break;
                    }
                    update.argDateNowPerApp(i.argName);
                    break;
                }
                case DateNowPerDb: {
                    if (i.argName == null) {
                        update.argDateNowPerDb();
                        break;
                    }
                    update.argDateNowPerDb(i.argName);
                }
            }
        }
    }

    public static String[] tidyColumnNames(String[] names) {
        LinkedHashSet<String> uniqueNames = new LinkedHashSet<String>();
        for (String name : names) {
            if (name == null || name.length() == 0) {
                name = "column_" + (uniqueNames.size() + 1);
            }
            name = name.replaceAll("[^a-zA-Z0-9]", " ");
            name = name.replaceAll("([a-z])([A-Z])", "$1_$2");
            name = name.trim().toLowerCase();
            if (Character.isDigit((name = name.replaceAll("\\s", "_")).charAt(0))) {
                name = "a" + name;
            }
            if (name.length() > 29) {
                name = name.substring(0, 28);
            }
            int i = 2;
            String uniqueName = name;
            while (uniqueNames.contains(uniqueName)) {
                if (name.length() > 27) {
                    name = name.substring(0, 26);
                }
                if (i > 9 && name.length() > 26) {
                    name = name.substring(0, 25);
                }
                uniqueName = name + "_" + i++;
            }
            name = uniqueName;
            uniqueNames.add(name);
        }
        return uniqueNames.toArray(new String[uniqueNames.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlArgs sqlArgs = (SqlArgs)o;
        return Objects.equals(this.invocations, sqlArgs.invocations);
    }

    public int hashCode() {
        return Objects.hash(this.invocations);
    }

    public String toString() {
        return "SqlArgs" + this.invocations;
    }

    public static class Builder {
        private String[] names;
        private final int[] types;
        private final int[] precision;
        private final int[] scale;

        public Builder(Row r) {
            try {
                ResultSetMetaData metadata = r.getMetadata();
                int columnCount = metadata.getColumnCount();
                this.names = new String[columnCount];
                this.types = new int[columnCount];
                this.precision = new int[columnCount];
                this.scale = new int[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    this.names[i] = metadata.getColumnLabel(i + 1);
                    this.types[i] = metadata.getColumnType(i + 1);
                    this.precision[i] = metadata.getPrecision(i + 1);
                    this.scale[i] = metadata.getScale(i + 1);
                }
                this.names = SqlArgs.tidyColumnNames(this.names);
            }
            catch (SQLException e) {
                throw new DatabaseException("Unable to retrieve metadata from ResultSet", e);
            }
        }

        @Nonnull
        public SqlArgs read(Row r) {
            SqlArgs args = new SqlArgs();
            block11: for (int i = 0; i < this.names.length; ++i) {
                switch (this.types[i]) {
                    case 4: 
                    case 5: {
                        args.argInteger(this.names[i], r.getIntegerOrNull());
                        continue block11;
                    }
                    case -5: {
                        args.argLong(this.names[i], r.getLongOrNull());
                        continue block11;
                    }
                    case 7: 
                    case 100: {
                        args.argFloat(this.names[i], r.getFloatOrNull());
                        continue block11;
                    }
                    case 8: 
                    case 101: {
                        args.argDouble(this.names[i], r.getDoubleOrNull());
                        continue block11;
                    }
                    case 2: {
                        if (this.precision[i] == 10 && this.scale[i] == 0) {
                            args.argInteger(this.names[i], r.getIntegerOrNull());
                            continue block11;
                        }
                        if (this.precision[i] == 19 && this.scale[i] == 0) {
                            args.argLong(this.names[i], r.getLongOrNull());
                            continue block11;
                        }
                        args.argBigDecimal(this.names[i], r.getBigDecimalOrNull());
                        continue block11;
                    }
                    case -3: 
                    case -2: 
                    case 2004: {
                        args.argBlobBytes(this.names[i], r.getBlobBytesOrNull());
                        continue block11;
                    }
                    case 2005: 
                    case 2011: {
                        args.argClobString(this.names[i], r.getClobStringOrNull());
                        continue block11;
                    }
                    case 93: {
                        args.argDate(this.names[i], r.getDateOrNull());
                        continue block11;
                    }
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: {
                        if (this.precision[i] >= Integer.MAX_VALUE) {
                            args.argClobString(this.names[i], r.getClobStringOrNull());
                            continue block11;
                        }
                        args.argString(this.names[i], r.getStringOrNull());
                        continue block11;
                    }
                    default: {
                        throw new DatabaseException("Don't know how to deal with column type: " + this.types[i]);
                    }
                }
            }
            return args;
        }
    }

    private static class Invocation {
        ColumnType columnType;
        String argName;
        Object arg;

        Invocation(ColumnType columnType, String argName, Object arg) {
            this.columnType = columnType;
            this.argName = argName;
            this.arg = arg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Invocation that = (Invocation)o;
            return this.columnType == that.columnType && Objects.equals(this.argName, that.argName) && Objects.deepEquals(this.arg, that.arg);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.columnType, this.argName, this.arg});
        }

        public String toString() {
            return "{name=" + this.argName + ", type=" + (Object)((Object)this.columnType) + ", arg=" + this.arg + '}';
        }
    }

    public static enum ColumnType {
        Integer,
        Long,
        Float,
        Double,
        BigDecimal,
        String,
        ClobString,
        ClobStream,
        BlobBytes,
        BlobStream,
        Date,
        DateNowPerApp,
        DateNowPerDb,
        Boolean;

    }
}

