/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.DatabaseMock;
import com.github.susom.database.DebugSql;
import com.github.susom.database.Metric;
import com.github.susom.database.MixedParameterSql;
import com.github.susom.database.Options;
import com.github.susom.database.RowStub;
import com.github.susom.database.RowsAdaptor;
import com.github.susom.database.RowsHandler;
import com.github.susom.database.SqlArgs;
import com.github.susom.database.SqlInsert;
import com.github.susom.database.SqlSelectImpl;
import com.github.susom.database.StatementAdaptor;
import com.github.susom.database.WrongNumberOfRowsException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInsertImpl
implements SqlInsert {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final Connection connection;
    private final DatabaseMock mock;
    private final StatementAdaptor adaptor;
    private final String sql;
    private final Options options;
    private List<Batch> batched;
    private List<Object> parameterList;
    private Map<String, Object> parameterMap;
    private String pkArgName;
    private int pkPos;
    private String pkSeqName;
    private Long pkLong;

    public SqlInsertImpl(Connection connection, DatabaseMock mock, String sql, Options options) {
        this.connection = connection;
        this.mock = mock;
        this.sql = sql;
        this.options = options;
        this.adaptor = new StatementAdaptor(options);
    }

    @Override
    @Nonnull
    public SqlInsert argBoolean(Boolean arg) {
        return this.positionalArg(this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlInsert argBoolean(@Nonnull String argName, Boolean arg) {
        return this.namedArg(argName, this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlInsert argInteger(Integer arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argInteger(@Nonnull String argName, Integer arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argLong(Long arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argLong(@Nonnull String argName, Long arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argFloat(Float arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argFloat(@Nonnull String argName, Float arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argDouble(Double arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argDouble(@Nonnull String argName, Double arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argBigDecimal(BigDecimal arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argBigDecimal(@Nonnull String argName, BigDecimal arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argString(String arg) {
        return this.positionalArg(this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argString(@Nonnull String argName, String arg) {
        return this.namedArg(argName, this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argDate(Date arg) {
        return this.positionalArg(this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argDate(@Nonnull String argName, Date arg) {
        return this.namedArg(argName, this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argDateNowPerApp() {
        return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlInsert argDateNowPerApp(@Nonnull String argName) {
        return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlInsert argDateNowPerDb() {
        if (this.options.useDatePerAppOnly()) {
            return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.positionalArg(new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlInsert argDateNowPerDb(@Nonnull String argName) {
        if (this.options.useDatePerAppOnly()) {
            return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.namedArg(argName, new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlInsert argBlobBytes(byte[] arg) {
        return this.positionalArg(this.adaptor.nullBytes(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argBlobBytes(@Nonnull String argName, byte[] arg) {
        return this.namedArg(argName, this.adaptor.nullBytes(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argBlobStream(InputStream arg) {
        return this.positionalArg(this.adaptor.nullInputStream(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argBlobStream(@Nonnull String argName, InputStream arg) {
        return this.namedArg(argName, this.adaptor.nullInputStream(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argClobString(String arg) {
        return this.positionalArg(this.adaptor.nullClobReader(arg == null ? null : new StringReader(arg)));
    }

    @Override
    @Nonnull
    public SqlInsert argClobString(@Nonnull String argName, String arg) {
        return this.namedArg(argName, this.adaptor.nullClobReader(arg == null ? null : new StringReader(arg)));
    }

    @Override
    @Nonnull
    public SqlInsert argClobReader(Reader arg) {
        return this.positionalArg(this.adaptor.nullClobReader(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argClobReader(@Nonnull String argName, Reader arg) {
        return this.namedArg(argName, this.adaptor.nullClobReader(arg));
    }

    @Override
    @Nonnull
    public SqlInsert withArgs(SqlArgs args) {
        return this.apply(args);
    }

    @Override
    @Nonnull
    public SqlInsert apply(SqlInsert.Apply apply) {
        apply.apply(this);
        return this;
    }

    @Override
    public SqlInsert batch() {
        if (this.parameterList != null && !this.parameterList.isEmpty() || this.parameterMap != null && !this.parameterMap.isEmpty()) {
            if (this.batched == null) {
                this.batched = new ArrayList<Batch>();
            }
            this.batched.add(new Batch(this.parameterList, this.parameterMap));
            this.parameterList = new ArrayList<Object>();
            this.parameterMap = new HashMap<String, Object>();
        }
        return this;
    }

    @Override
    public int insert() {
        return this.updateInternal(0);
    }

    @Override
    public void insert(int expectedRowsUpdated) {
        this.updateInternal(expectedRowsUpdated);
    }

    @Override
    public void insertBatch() {
        int[] result;
        for (int r : result = this.updateBatch()) {
            if (r == 1 || r == -2) continue;
            throw new DatabaseException("Batch did not return the expected result: " + Arrays.toString(result));
        }
    }

    @Override
    public int[] insertBatchUnchecked() {
        return this.updateBatch();
    }

    @Override
    public Long insertReturningPkSeq(String primaryKeyColumnName) {
        if (!this.hasPk()) {
            throw new DatabaseException("Call argPkSeq() before insertReturningPkSeq()");
        }
        if (this.options.flavor().supportsInsertReturning()) {
            return this.updateInternal(1, primaryKeyColumnName);
        }
        Long pk = new SqlSelectImpl(this.connection, this.mock, this.options.flavor().sequenceSelectNextVal(this.pkSeqName), this.options).queryLongOrNull();
        if (pk == null) {
            throw new DatabaseException("Unable to retrieve next sequence value from " + this.pkSeqName);
        }
        if (this.pkArgName != null) {
            this.namedArg(this.pkArgName, this.adaptor.nullNumeric(pk));
        } else {
            this.parameterList.set(this.pkPos, this.adaptor.nullNumeric(pk));
        }
        this.updateInternal(1);
        return pk;
    }

    @Override
    public <T> T insertReturning(String tableName, String primaryKeyColumnName, RowsHandler<T> handler, String ... otherColumnNames) {
        if (!this.hasPk()) {
            throw new DatabaseException("Identify a primary key with argPk*() before insertReturning()");
        }
        if (this.options.flavor().supportsInsertReturning()) {
            return this.updateInternal(1, primaryKeyColumnName, handler, otherColumnNames);
        }
        if (this.pkSeqName != null) {
            Long pk = new SqlSelectImpl(this.connection, this.mock, this.options.flavor().sequenceSelectNextVal(this.pkSeqName), this.options).queryLongOrNull();
            if (pk == null) {
                throw new DatabaseException("Unable to retrieve next sequence value from " + this.pkSeqName);
            }
            if (this.pkArgName != null) {
                this.namedArg(this.pkArgName, this.adaptor.nullNumeric(pk));
            } else {
                this.parameterList.set(this.pkPos, this.adaptor.nullNumeric(pk));
            }
            this.updateInternal(1);
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(primaryKeyColumnName);
            for (String colName : otherColumnNames) {
                sql.append(", ").append(colName);
            }
            sql.append(" from ").append(tableName).append(" where ").append(primaryKeyColumnName).append("=?");
            return new SqlSelectImpl(this.connection, this.mock, sql.toString(), this.options).argLong(pk).query(handler);
        }
        if (this.pkLong != null) {
            this.updateInternal(1);
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(primaryKeyColumnName);
            for (String colName : otherColumnNames) {
                sql.append(", ").append(colName);
            }
            sql.append(" from ").append(tableName).append(" where ").append(primaryKeyColumnName).append("=?");
            return new SqlSelectImpl(this.connection, this.mock, sql.toString(), this.options).argLong(this.pkLong).query(handler);
        }
        throw new DatabaseException("Internal error");
    }

    @Override
    @Nonnull
    public SqlInsert argPkSeq(@Nonnull String sequenceName) {
        if (this.hasPk() && this.batched == null) {
            throw new DatabaseException("Only call one argPk*() method");
        }
        if (this.hasPk() && (!this.pkSeqName.equals(sequenceName) || this.pkPos != this.parameterList.size())) {
            throw new DatabaseException("The argPkSeq() calls must be in the same position across batch records");
        }
        this.pkSeqName = sequenceName;
        SqlInsert sqlInsert = this.positionalArg(new MixedParameterSql.RewriteArg(this.options.flavor().sequenceNextVal(sequenceName)));
        this.pkPos = this.parameterList.size() - 1;
        return sqlInsert;
    }

    @Override
    @Nonnull
    public SqlInsert argPkSeq(@Nonnull String argName, @Nonnull String sequenceName) {
        if (this.hasPk() && this.batched == null) {
            throw new DatabaseException("Only call one argPk*() method");
        }
        if (this.hasPk() && !argName.equals(this.pkArgName)) {
            throw new DatabaseException("The primary key argument name must match across batch rows");
        }
        this.pkArgName = argName;
        this.pkSeqName = sequenceName;
        return this.namedArg(argName, new MixedParameterSql.RewriteArg(this.options.flavor().sequenceNextVal(sequenceName)));
    }

    @Override
    @Nonnull
    public SqlInsert argPkLong(String argName, Long arg) {
        if (this.hasPk() && this.batched == null) {
            throw new DatabaseException("Only call one argPk*() method");
        }
        if (this.hasPk() && !argName.equals(this.pkArgName)) {
            throw new DatabaseException("The primary key argument name must match across batch rows");
        }
        this.pkArgName = argName;
        this.pkLong = arg;
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlInsert argPkLong(Long arg) {
        if (this.hasPk() && this.batched == null) {
            throw new DatabaseException("Only call one argPk*() method");
        }
        if (this.hasPk() && this.pkPos != this.parameterList.size()) {
            throw new DatabaseException("The argPkLong() calls must be in the same position across batch records");
        }
        this.pkLong = arg;
        SqlInsert sqlInsert = this.positionalArg(this.adaptor.nullNumeric(arg));
        this.pkPos = this.parameterList.size() - 1;
        return sqlInsert;
    }

    private boolean hasPk() {
        return this.pkArgName != null || this.pkSeqName != null || this.pkLong != null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int[] updateBatch() {
        int[] nArray;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        ArrayList<Object[]> parameters;
        Object[] firstRowParameters;
        String executeSql;
        Metric metric;
        PreparedStatement ps;
        block17: {
            Object[] params222222;
            this.batch();
            if (this.batched == null) throw new DatabaseException("Batch insert requires parameters");
            if (this.batched.size() == 0) {
                throw new DatabaseException("Batch insert requires parameters");
            }
            ps = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            firstRowParameters = null;
            parameters = new ArrayList<Object[]>();
            isSuccess = false;
            errorCode = null;
            logEx = null;
            for (Batch batch : this.batched) {
                MixedParameterSql mpSql = new MixedParameterSql(this.sql, batch.parameterList, batch.parameterMap);
                if (firstRowParameters == null) {
                    executeSql = mpSql.getSqlToExecute();
                    firstRowParameters = mpSql.getArgs();
                } else if (!executeSql.equals(mpSql.getSqlToExecute())) {
                    throw new DatabaseException("All rows in a batch must use parameters in the same way. \nSQL1: " + executeSql + "\nSQL2: " + mpSql.getSqlToExecute());
                }
                parameters.add(mpSql.getArgs());
            }
            if (this.connection == null) break block17;
            ps = this.connection.prepareStatement(executeSql);
            for (Object[] params222222 : parameters) {
                this.adaptor.addParameters(ps, params222222);
                ps.addBatch();
            }
            metric.checkpoint("prep", new Object[0]);
            int[] numAffectedRows = ps.executeBatch();
            metric.checkpoint("execBatch", parameters.size());
            isSuccess = true;
            params222222 = numAffectedRows;
            this.adaptor.closeQuietly(ps, log);
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Insert", log, metric, executeSql, firstRowParameters, this.options);
                return params222222;
            }
            DebugSql.logError("Insert", log, metric, errorCode, executeSql, firstRowParameters, this.options, logEx);
            return params222222;
        }
        try {
            int[] result = new int[parameters.size()];
            for (int i = 0; i < parameters.size(); ++i) {
                Object[] params = (Object[])parameters.get(i);
                Integer numAffectedRows = this.mock.insert(executeSql, DebugSql.printDebugOnlySqlString(executeSql, params, this.options));
                if (numAffectedRows == null) {
                    log.debug("Setting numAffectedRows to expected");
                    numAffectedRows = 1;
                }
                result[i] = numAffectedRows;
            }
            metric.checkpoint("stubBatch", parameters.size());
            isSuccess = true;
            nArray = result;
        }
        catch (WrongNumberOfRowsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, firstRowParameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(ps, log);
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Insert", log, metric, executeSql, firstRowParameters, this.options);
                    throw throwable;
                }
                DebugSql.logError("Insert", log, metric, errorCode, executeSql, firstRowParameters, this.options, logEx);
                throw throwable;
            }
        }
        this.adaptor.closeQuietly(ps, log);
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Insert", log, metric, executeSql, firstRowParameters, this.options);
            return nArray;
        }
        DebugSql.logError("Insert", log, metric, errorCode, executeSql, firstRowParameters, this.options, logEx);
        return nArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int updateInternal(int expectedNumAffectedRows) {
        int n;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        Object[] parameters;
        String executeSql;
        Metric metric;
        PreparedStatement ps;
        block12: {
            if (this.batched != null) {
                throw new DatabaseException("Call insertBatch() if you are using the batch() feature");
            }
            ps = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            parameters = null;
            isSuccess = false;
            errorCode = null;
            logEx = null;
            MixedParameterSql mpSql = new MixedParameterSql(this.sql, this.parameterList, this.parameterMap);
            executeSql = mpSql.getSqlToExecute();
            parameters = mpSql.getArgs();
            if (this.connection == null) break block12;
            ps = this.connection.prepareStatement(executeSql);
            this.adaptor.addParameters(ps, parameters);
            metric.checkpoint("prep", new Object[0]);
            int numAffectedRows = ps.executeUpdate();
            metric.checkpoint("exec", numAffectedRows);
            if (expectedNumAffectedRows > 0 && numAffectedRows != expectedNumAffectedRows) {
                errorCode = this.options.generateErrorCode();
                throw new WrongNumberOfRowsException("The number of affected rows was " + numAffectedRows + ", but " + expectedNumAffectedRows + " were expected." + "\n" + DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options));
            }
            isSuccess = true;
            int n2 = numAffectedRows;
            this.adaptor.closeQuietly(ps, log);
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                return n2;
            }
            DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
            return n2;
        }
        try {
            Integer numAffectedRows = this.mock.insert(executeSql, DebugSql.printDebugOnlySqlString(executeSql, parameters, this.options));
            if (numAffectedRows == null) {
                log.debug("Setting numAffectedRows to expected");
                numAffectedRows = expectedNumAffectedRows;
            }
            metric.checkpoint("stub", numAffectedRows);
            isSuccess = true;
            n = numAffectedRows;
        }
        catch (WrongNumberOfRowsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(ps, log);
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                    throw throwable;
                }
                DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
                throw throwable;
            }
        }
        this.adaptor.closeQuietly(ps, log);
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
            return n;
        }
        DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long updateInternal(int expectedNumAffectedRows, @Nonnull String pkToReturn) {
        Long l;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        Object[] parameters;
        String executeSql;
        Metric metric;
        ResultSet rs;
        PreparedStatement ps;
        block13: {
            if (this.batched != null) {
                throw new DatabaseException("Call insertBatch() if you are using the batch() feature");
            }
            ps = null;
            rs = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            parameters = null;
            isSuccess = false;
            errorCode = null;
            logEx = null;
            MixedParameterSql mpSql = new MixedParameterSql(this.sql, this.parameterList, this.parameterMap);
            executeSql = mpSql.getSqlToExecute();
            parameters = mpSql.getArgs();
            if (this.connection == null) break block13;
            ps = this.connection.prepareStatement(executeSql, new String[]{pkToReturn});
            this.adaptor.addParameters(ps, parameters);
            metric.checkpoint("prep", new Object[0]);
            int numAffectedRows = ps.executeUpdate();
            metric.checkpoint("exec", numAffectedRows);
            if (expectedNumAffectedRows > 0 && numAffectedRows != expectedNumAffectedRows) {
                errorCode = this.options.generateErrorCode();
                throw new WrongNumberOfRowsException("The number of affected rows was " + numAffectedRows + ", but " + expectedNumAffectedRows + " were expected." + "\n" + DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options));
            }
            rs = ps.getGeneratedKeys();
            Long pk = null;
            if (rs != null && rs.next()) {
                pk = rs.getLong(1);
            }
            isSuccess = true;
            Long l2 = pk;
            this.adaptor.closeQuietly(rs, log);
            this.adaptor.closeQuietly(ps, log);
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                return l2;
            }
            DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
            return l2;
        }
        try {
            String debugSql = DebugSql.printDebugOnlySqlString(executeSql, parameters, this.options);
            Long pk = this.mock.insertReturningPk(executeSql, debugSql);
            if (pk == null) {
                log.debug("Setting pk to hash of debugSql");
                pk = debugSql.hashCode();
            }
            metric.checkpoint("stub", new Object[0]);
            isSuccess = true;
            l = pk;
        }
        catch (WrongNumberOfRowsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(rs, log);
                this.adaptor.closeQuietly(ps, log);
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                    throw throwable;
                }
                DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
                throw throwable;
            }
        }
        this.adaptor.closeQuietly(rs, log);
        this.adaptor.closeQuietly(ps, log);
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
            return l;
        }
        DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T updateInternal(int expectedNumAffectedRows, @Nonnull String pkToReturn, RowsHandler<T> handler, String ... otherCols) {
        T t;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        Object[] parameters;
        String executeSql;
        Metric metric;
        ResultSet rs;
        PreparedStatement ps;
        block12: {
            if (this.batched != null) {
                throw new DatabaseException("Call insertBatch() if you are using the batch() feature");
            }
            ps = null;
            rs = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            parameters = null;
            isSuccess = false;
            errorCode = null;
            logEx = null;
            MixedParameterSql mpSql = new MixedParameterSql(this.sql, this.parameterList, this.parameterMap);
            executeSql = mpSql.getSqlToExecute();
            parameters = mpSql.getArgs();
            String[] returnCols = new String[otherCols.length + 1];
            returnCols[0] = pkToReturn;
            System.arraycopy(otherCols, 0, returnCols, 1, otherCols.length);
            if (this.connection == null) break block12;
            ps = this.connection.prepareStatement(executeSql, returnCols);
            this.adaptor.addParameters(ps, parameters);
            metric.checkpoint("prep", new Object[0]);
            int numAffectedRows = ps.executeUpdate();
            metric.checkpoint("exec", numAffectedRows);
            if (expectedNumAffectedRows > 0 && numAffectedRows != expectedNumAffectedRows) {
                errorCode = this.options.generateErrorCode();
                throw new WrongNumberOfRowsException("The number of affected rows was " + numAffectedRows + ", but " + expectedNumAffectedRows + " were expected." + "\n" + DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options));
            }
            ResultSet finalRs = rs = ps.getGeneratedKeys();
            T result = handler.process(new RowsAdaptor(finalRs, this.options));
            metric.checkpoint("read", new Object[0]);
            isSuccess = true;
            T t2 = result;
            this.adaptor.closeQuietly(rs, log);
            this.adaptor.closeQuietly(ps, log);
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                return t2;
            }
            DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
            return t2;
        }
        try {
            RowStub stub = this.mock.insertReturning(executeSql, DebugSql.printDebugOnlySqlString(executeSql, parameters, this.options));
            if (stub == null) {
                stub = new RowStub();
            }
            metric.checkpoint("stub", new Object[0]);
            T result = handler.process(stub.toRows());
            metric.checkpoint("read", new Object[0]);
            isSuccess = true;
            t = result;
        }
        catch (WrongNumberOfRowsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(rs, log);
                this.adaptor.closeQuietly(ps, log);
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
                    throw throwable;
                }
                DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
                throw throwable;
            }
        }
        this.adaptor.closeQuietly(rs, log);
        this.adaptor.closeQuietly(ps, log);
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Insert", log, metric, executeSql, parameters, this.options);
            return t;
        }
        DebugSql.logError("Insert", log, metric, errorCode, executeSql, parameters, this.options, logEx);
        return t;
    }

    private SqlInsert positionalArg(Object arg) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<Object>();
        }
        this.parameterList.add(arg);
        return this;
    }

    private SqlInsert namedArg(String argName, Object arg) {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, Object>();
        }
        if (argName.startsWith(":")) {
            argName = argName.substring(1);
        }
        this.parameterMap.put(argName, arg);
        return this;
    }

    private String booleanToString(Boolean b) {
        return b == null ? null : (b != false ? "Y" : "N");
    }

    private class Batch {
        private List<Object> parameterList;
        private Map<String, Object> parameterMap;

        public Batch(List<Object> parameterList, Map<String, Object> parameterMap) {
            this.parameterList = parameterList;
            this.parameterMap = parameterMap;
        }
    }
}

