/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.ConstraintViolationException;
import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.DatabaseMock;
import com.github.susom.database.DebugSql;
import com.github.susom.database.Metric;
import com.github.susom.database.MixedParameterSql;
import com.github.susom.database.Options;
import com.github.susom.database.QueryTimedOutException;
import com.github.susom.database.RowHandler;
import com.github.susom.database.RowStub;
import com.github.susom.database.Rows;
import com.github.susom.database.RowsAdaptor;
import com.github.susom.database.RowsHandler;
import com.github.susom.database.SqlArgs;
import com.github.susom.database.SqlSelect;
import com.github.susom.database.StatementAdaptor;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSelectImpl
implements SqlSelect {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final Connection connection;
    private final DatabaseMock mock;
    private final StatementAdaptor adaptor;
    private PreparedStatement ps;
    private final Object cancelLock = new Object();
    private final String sql;
    private final Options options;
    private List<Object> parameterList;
    private Map<String, Object> parameterMap;
    private int timeoutSeconds = -1;
    private int maxRows = -1;

    public SqlSelectImpl(Connection connection, DatabaseMock mock, String sql, Options options) {
        this.connection = connection;
        this.mock = mock;
        this.sql = sql;
        this.options = options;
        this.adaptor = new StatementAdaptor(options);
    }

    @Override
    @Nonnull
    public SqlSelect argBoolean(Boolean arg) {
        return this.positionalArg(this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlSelect argBoolean(@Nonnull String argName, Boolean arg) {
        return this.namedArg(argName, this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlSelect argInteger(Integer arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argInteger(@Nonnull String argName, Integer arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argLong(Long arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argLong(@Nonnull String argName, Long arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argFloat(Float arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argFloat(@Nonnull String argName, Float arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argDouble(Double arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argDouble(@Nonnull String argName, Double arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argBigDecimal(BigDecimal arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argBigDecimal(@Nonnull String argName, BigDecimal arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argString(String arg) {
        return this.positionalArg(this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argString(@Nonnull String argName, String arg) {
        return this.namedArg(argName, this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argDate(Date arg) {
        return this.positionalArg(this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argDate(@Nonnull String argName, Date arg) {
        return this.namedArg(argName, this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlSelect argDateNowPerApp() {
        return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlSelect argDateNowPerApp(@Nonnull String argName) {
        return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlSelect argDateNowPerDb() {
        if (this.options.useDatePerAppOnly()) {
            return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.positionalArg(new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlSelect argDateNowPerDb(@Nonnull String argName) {
        if (this.options.useDatePerAppOnly()) {
            return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.namedArg(argName, new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlSelect withTimeoutSeconds(int seconds) {
        this.timeoutSeconds = seconds;
        return this;
    }

    @Override
    @Nonnull
    public SqlSelect withMaxRows(int rows) {
        this.maxRows = rows;
        return this;
    }

    @Override
    @Nonnull
    public SqlSelect withArgs(SqlArgs args) {
        return this.apply(args);
    }

    @Override
    @Nonnull
    public SqlSelect apply(SqlSelect.Apply apply) {
        apply.apply(this);
        return this;
    }

    @Override
    @Nullable
    public Boolean queryBooleanOrNull() {
        return this.queryWithTimeout(new RowsHandler<Boolean>(){

            @Override
            public Boolean process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getBooleanOrNull();
                }
                return null;
            }
        });
    }

    @Override
    public boolean queryBooleanOrFalse() {
        Boolean result = this.queryBooleanOrNull();
        return result == null ? false : result;
    }

    @Override
    public boolean queryBooleanOrTrue() {
        Boolean result = this.queryBooleanOrNull();
        return result == null ? true : result;
    }

    @Override
    @Nullable
    public Long queryLongOrNull() {
        return this.queryWithTimeout(new RowsHandler<Long>(){

            @Override
            public Long process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getLongOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    public long queryLongOrZero() {
        return this.queryWithTimeout(new RowsHandler<Long>(){

            @Override
            public Long process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getLongOrZero(1);
                }
                return 0L;
            }
        });
    }

    @Override
    @Nonnull
    public List<Long> queryLongs() {
        return this.queryWithTimeout(new RowsHandler<List<Long>>(){

            @Override
            public List<Long> process(Rows rs) throws Exception {
                ArrayList<Long> result = new ArrayList<Long>();
                while (rs.next()) {
                    Long value = rs.getLongOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    @Nullable
    public Integer queryIntegerOrNull() {
        return this.queryWithTimeout(new RowsHandler<Integer>(){

            @Override
            public Integer process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getIntegerOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    public int queryIntegerOrZero() {
        return this.queryWithTimeout(new RowsHandler<Integer>(){

            @Override
            public Integer process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getIntegerOrZero(1);
                }
                return 0;
            }
        });
    }

    @Override
    @Nonnull
    public List<Integer> queryIntegers() {
        return this.queryWithTimeout(new RowsHandler<List<Integer>>(){

            @Override
            public List<Integer> process(Rows rs) throws Exception {
                ArrayList<Integer> result = new ArrayList<Integer>();
                while (rs.next()) {
                    Integer value = rs.getIntegerOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    @Nullable
    public Float queryFloatOrNull() {
        return this.queryWithTimeout(new RowsHandler<Float>(){

            @Override
            public Float process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getFloatOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    public float queryFloatOrZero() {
        return this.queryWithTimeout(new RowsHandler<Float>(){

            @Override
            public Float process(Rows rs) throws Exception {
                if (rs.next()) {
                    return Float.valueOf(rs.getFloatOrZero(1));
                }
                return Float.valueOf(0.0f);
            }
        }).floatValue();
    }

    @Override
    @Nonnull
    public List<Float> queryFloats() {
        return this.queryWithTimeout(new RowsHandler<List<Float>>(){

            @Override
            public List<Float> process(Rows rs) throws Exception {
                ArrayList<Float> result = new ArrayList<Float>();
                while (rs.next()) {
                    Float value = rs.getFloatOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    @Nullable
    public Double queryDoubleOrNull() {
        return this.queryWithTimeout(new RowsHandler<Double>(){

            @Override
            public Double process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getDoubleOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    public double queryDoubleOrZero() {
        return this.queryWithTimeout(new RowsHandler<Double>(){

            @Override
            public Double process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getDoubleOrZero(1);
                }
                return 0.0;
            }
        });
    }

    @Override
    @Nonnull
    public List<Double> queryDoubles() {
        return this.queryWithTimeout(new RowsHandler<List<Double>>(){

            @Override
            public List<Double> process(Rows rs) throws Exception {
                ArrayList<Double> result = new ArrayList<Double>();
                while (rs.next()) {
                    Double value = rs.getDoubleOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    @Nullable
    public BigDecimal queryBigDecimalOrNull() {
        return this.queryWithTimeout(new RowsHandler<BigDecimal>(){

            @Override
            public BigDecimal process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getBigDecimalOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public BigDecimal queryBigDecimalOrZero() {
        return this.queryWithTimeout(new RowsHandler<BigDecimal>(){

            @Override
            public BigDecimal process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getBigDecimalOrZero(1);
                }
                return new BigDecimal(0);
            }
        });
    }

    @Override
    @Nonnull
    public List<BigDecimal> queryBigDecimals() {
        return this.queryWithTimeout(new RowsHandler<List<BigDecimal>>(){

            @Override
            public List<BigDecimal> process(Rows rs) throws Exception {
                ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
                while (rs.next()) {
                    BigDecimal value = rs.getBigDecimalOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    public String queryStringOrNull() {
        return this.queryWithTimeout(new RowsHandler<String>(){

            @Override
            public String process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getStringOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public String queryStringOrEmpty() {
        return this.queryWithTimeout(new RowsHandler<String>(){

            @Override
            public String process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getStringOrEmpty(1);
                }
                return "";
            }
        });
    }

    @Override
    @Nonnull
    public List<String> queryStrings() {
        return this.queryWithTimeout(new RowsHandler<List<String>>(){

            @Override
            public List<String> process(Rows rs) throws Exception {
                ArrayList<String> result = new ArrayList<String>();
                while (rs.next()) {
                    String value = rs.getStringOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    @Nullable
    public Date queryDateOrNull() {
        return this.queryWithTimeout(new RowsHandler<Date>(){

            @Override
            public Date process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rs.getDateOrNull(1);
                }
                return null;
            }
        });
    }

    @Override
    @Nonnull
    public List<Date> queryDates() {
        return this.queryWithTimeout(new RowsHandler<List<Date>>(){

            @Override
            public List<Date> process(Rows rs) throws Exception {
                ArrayList<Date> result = new ArrayList<Date>();
                while (rs.next()) {
                    Date value = rs.getDateOrNull(1);
                    if (value == null) continue;
                    result.add(value);
                }
                return result;
            }
        });
    }

    @Override
    public <T> T query(RowsHandler<T> rowsHandler) {
        return this.queryWithTimeout(rowsHandler);
    }

    @Override
    public <T> T queryOneOrNull(final RowHandler<T> rowHandler) {
        return this.queryWithTimeout(new RowsHandler<T>(){

            @Override
            public T process(Rows rs) throws Exception {
                if (rs.next()) {
                    Object result = rowHandler.process(rs);
                    if (rs.next()) {
                        throw new ConstraintViolationException("Expected exactly one row to be returned but found multiple");
                    }
                    return result;
                }
                return null;
            }
        });
    }

    @Override
    public <T> T queryOneOrThrow(RowHandler<T> rowHandler) {
        T result = this.queryOneOrNull(rowHandler);
        if (result == null) {
            throw new ConstraintViolationException("Expected exactly one row to be returned but found none");
        }
        return result;
    }

    @Override
    public <T> T queryFirstOrNull(final RowHandler<T> rowHandler) {
        return this.queryWithTimeout(new RowsHandler<T>(){

            @Override
            public T process(Rows rs) throws Exception {
                if (rs.next()) {
                    return rowHandler.process(rs);
                }
                return null;
            }
        });
    }

    @Override
    public <T> T queryFirstOrThrow(RowHandler<T> rowHandler) {
        T result = this.queryFirstOrNull(rowHandler);
        if (result == null) {
            throw new ConstraintViolationException("Expected one or more rows to be returned but found none");
        }
        return result;
    }

    @Override
    public <T> List<T> queryMany(final RowHandler<T> rowHandler) {
        return (List)this.queryWithTimeout(new RowsHandler<List<T>>(){

            @Override
            public List<T> process(Rows rs) throws Exception {
                ArrayList result = new ArrayList();
                while (rs.next()) {
                    Object row = rowHandler.process(rs);
                    if (row == null) continue;
                    result.add(row);
                }
                return result;
            }
        });
    }

    private SqlSelect positionalArg(Object arg) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<Object>();
        }
        this.parameterList.add(arg);
        return this;
    }

    private SqlSelect namedArg(String argName, Object arg) {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, Object>();
        }
        if (argName.startsWith(":")) {
            argName = argName.substring(1);
        }
        this.parameterMap.put(argName, arg);
        return this;
    }

    private String booleanToString(Boolean b) {
        return b == null ? null : (b != false ? "Y" : "N");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private <T> T queryWithTimeout(RowsHandler<T> handler) {
        T t;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        boolean isWarn;
        Object[] parameters;
        String executeSql;
        Metric metric;
        ResultSet rs;
        block25: {
            assert (this.ps == null);
            rs = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            parameters = null;
            isWarn = false;
            isSuccess = false;
            errorCode = null;
            logEx = null;
            MixedParameterSql mpSql = new MixedParameterSql(this.sql, this.parameterList, this.parameterMap);
            executeSql = mpSql.getSqlToExecute();
            parameters = mpSql.getArgs();
            if (this.connection == null) break block25;
            Object object = this.cancelLock;
            // MONITORENTER : object
            this.ps = this.connection.prepareStatement(executeSql);
            // MONITOREXIT : object
            if (this.timeoutSeconds >= 0) {
                this.ps.setQueryTimeout(this.timeoutSeconds);
            }
            if (this.maxRows > 0) {
                this.ps.setMaxRows(this.maxRows);
            }
            this.adaptor.addParameters(this.ps, parameters);
            metric.checkpoint("prep", new Object[0]);
            rs = this.ps.executeQuery();
            metric.checkpoint("exec", new Object[0]);
            ResultSet finalRs = rs;
            T result = handler.process(new RowsAdaptor(finalRs, this.options));
            metric.checkpoint("read", new Object[0]);
            isSuccess = true;
            T t2 = result;
            this.adaptor.closeQuietly(rs, log);
            this.adaptor.closeQuietly(this.ps, log);
            Object object2 = this.cancelLock;
            // MONITORENTER : object2
            this.ps = null;
            // MONITOREXIT : object2
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Query", log, metric, executeSql, parameters, this.options);
                return t2;
            }
            if (isWarn) {
                DebugSql.logWarning("Query", log, metric, "QueryTimedOutException", executeSql, parameters, this.options, logEx);
                return t2;
            }
            DebugSql.logError("Query", log, metric, errorCode, executeSql, parameters, this.options, logEx);
            return t2;
        }
        try {
            RowStub stub = this.mock.query(executeSql, DebugSql.printDebugOnlySqlString(executeSql, parameters, this.options));
            if (stub == null) {
                stub = new RowStub();
            }
            metric.checkpoint("stub", new Object[0]);
            T result = handler.process(stub.toRows());
            metric.checkpoint("read", new Object[0]);
            isSuccess = true;
            t = result;
            this.adaptor.closeQuietly(rs, log);
            this.adaptor.closeQuietly(this.ps, log);
            Object object = this.cancelLock;
        }
        catch (SQLException e) {
            try {
                if (e.getErrorCode() == 1013) {
                    isWarn = true;
                    throw new QueryTimedOutException("Timeout of " + this.timeoutSeconds + " seconds exceeded or user cancelled", e);
                }
                errorCode = this.options.generateErrorCode();
                logEx = e;
                throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e);
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(rs, log);
                this.adaptor.closeQuietly(this.ps, log);
                Object object = this.cancelLock;
                // MONITORENTER : object
                this.ps = null;
                // MONITOREXIT : object
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Query", log, metric, executeSql, parameters, this.options);
                    throw throwable;
                }
                if (isWarn) {
                    DebugSql.logWarning("Query", log, metric, "QueryTimedOutException", executeSql, parameters, this.options, logEx);
                    throw throwable;
                }
                DebugSql.logError("Query", log, metric, errorCode, executeSql, parameters, this.options, logEx);
                throw throwable;
            }
        }
        // MONITORENTER : object
        this.ps = null;
        // MONITOREXIT : object
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Query", log, metric, executeSql, parameters, this.options);
            return t;
        }
        if (isWarn) {
            DebugSql.logWarning("Query", log, metric, "QueryTimedOutException", executeSql, parameters, this.options, logEx);
            return t;
        }
        DebugSql.logError("Query", log, metric, errorCode, executeSql, parameters, this.options, logEx);
        return t;
    }
}

