/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.Database;
import com.github.susom.database.DatabaseException;
import com.github.susom.database.DatabaseMock;
import com.github.susom.database.DebugSql;
import com.github.susom.database.Metric;
import com.github.susom.database.MixedParameterSql;
import com.github.susom.database.Options;
import com.github.susom.database.SqlArgs;
import com.github.susom.database.SqlUpdate;
import com.github.susom.database.StatementAdaptor;
import com.github.susom.database.WrongNumberOfRowsException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUpdateImpl
implements SqlUpdate {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final Connection connection;
    private final DatabaseMock mock;
    private final StatementAdaptor adaptor;
    private final String sql;
    private final Options options;
    private List<Object> parameterList;
    private Map<String, Object> parameterMap;

    public SqlUpdateImpl(Connection connection, DatabaseMock mock, @Nonnull String sql, Options options) {
        this.connection = connection;
        this.mock = mock;
        this.sql = sql;
        this.options = options;
        this.adaptor = new StatementAdaptor(options);
    }

    @Override
    @Nonnull
    public SqlUpdate argBoolean(Boolean arg) {
        return this.positionalArg(this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlUpdate argBoolean(@Nonnull String argName, Boolean arg) {
        return this.namedArg(argName, this.adaptor.nullString(this.booleanToString(arg)));
    }

    @Override
    @Nonnull
    public SqlUpdate argInteger(@Nullable Integer arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argInteger(@Nonnull String argName, @Nullable Integer arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argLong(@Nullable Long arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argLong(@Nonnull String argName, @Nullable Long arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argFloat(@Nullable Float arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argFloat(@Nonnull String argName, @Nullable Float arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argDouble(@Nullable Double arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argDouble(@Nonnull String argName, @Nullable Double arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argBigDecimal(@Nullable BigDecimal arg) {
        return this.positionalArg(this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argBigDecimal(@Nonnull String argName, @Nullable BigDecimal arg) {
        return this.namedArg(argName, this.adaptor.nullNumeric(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argString(@Nullable String arg) {
        return this.positionalArg(this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argString(@Nonnull String argName, @Nullable String arg) {
        return this.namedArg(argName, this.adaptor.nullString(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argDate(@Nullable Date arg) {
        return this.positionalArg(this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argDate(@Nonnull String argName, @Nullable Date arg) {
        return this.namedArg(argName, this.adaptor.nullDate(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argDateNowPerApp() {
        return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlUpdate argDateNowPerApp(@Nonnull String argName) {
        return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
    }

    @Override
    @Nonnull
    public SqlUpdate argDateNowPerDb() {
        if (this.options.useDatePerAppOnly()) {
            return this.positionalArg(this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.positionalArg(new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlUpdate argDateNowPerDb(@Nonnull String argName) {
        if (this.options.useDatePerAppOnly()) {
            return this.namedArg(argName, this.adaptor.nullDate(this.options.currentDate()));
        }
        return this.namedArg(argName, new MixedParameterSql.RewriteArg(this.options.flavor().dbTimeMillis()));
    }

    @Override
    @Nonnull
    public SqlUpdate argBlobBytes(@Nullable byte[] arg) {
        return this.positionalArg(this.adaptor.nullBytes(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argBlobBytes(@Nonnull String argName, @Nullable byte[] arg) {
        return this.namedArg(argName, this.adaptor.nullBytes(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argBlobStream(@Nullable InputStream arg) {
        return this.positionalArg(this.adaptor.nullInputStream(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argBlobStream(@Nonnull String argName, @Nullable InputStream arg) {
        return this.namedArg(argName, this.adaptor.nullInputStream(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argClobString(@Nullable String arg) {
        return this.positionalArg(this.adaptor.nullClobReader(arg == null ? null : new StringReader(arg)));
    }

    @Override
    @Nonnull
    public SqlUpdate argClobString(@Nonnull String argName, @Nullable String arg) {
        return this.namedArg(argName, this.adaptor.nullClobReader(arg == null ? null : new StringReader(arg)));
    }

    @Override
    @Nonnull
    public SqlUpdate argClobReader(@Nullable Reader arg) {
        return this.positionalArg(this.adaptor.nullClobReader(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate argClobReader(@Nonnull String argName, @Nullable Reader arg) {
        return this.namedArg(argName, this.adaptor.nullClobReader(arg));
    }

    @Override
    @Nonnull
    public SqlUpdate withArgs(SqlArgs args) {
        return this.apply(args);
    }

    @Override
    @Nonnull
    public SqlUpdate apply(SqlUpdate.Apply apply) {
        apply.apply(this);
        return this;
    }

    @Override
    public int update() {
        return this.updateInternal(0);
    }

    @Override
    public void update(int expectedNumAffectedRows) {
        this.updateInternal(expectedNumAffectedRows);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int updateInternal(int expectedNumAffectedRows) {
        int n;
        Exception logEx;
        String errorCode;
        boolean isSuccess;
        Object[] parameters;
        String executeSql;
        Metric metric;
        PreparedStatement ps;
        block10: {
            ps = null;
            metric = new Metric(log.isDebugEnabled());
            executeSql = this.sql;
            parameters = null;
            isSuccess = false;
            errorCode = null;
            logEx = null;
            MixedParameterSql mpSql = new MixedParameterSql(this.sql, this.parameterList, this.parameterMap);
            executeSql = mpSql.getSqlToExecute();
            parameters = mpSql.getArgs();
            if (this.connection == null) break block10;
            ps = this.connection.prepareStatement(executeSql);
            this.adaptor.addParameters(ps, parameters);
            metric.checkpoint("prep", new Object[0]);
            int numAffectedRows = ps.executeUpdate();
            metric.checkpoint("exec", numAffectedRows);
            if (expectedNumAffectedRows > 0 && numAffectedRows != expectedNumAffectedRows) {
                errorCode = this.options.generateErrorCode();
                throw new WrongNumberOfRowsException("The number of affected rows was " + numAffectedRows + ", but " + expectedNumAffectedRows + " were expected." + "\n" + DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options));
            }
            isSuccess = true;
            int n2 = numAffectedRows;
            this.adaptor.closeQuietly(ps, log);
            metric.done("close", new Object[0]);
            if (isSuccess) {
                DebugSql.logSuccess("Update", log, metric, executeSql, parameters, this.options);
                return n2;
            }
            DebugSql.logError("Update", log, metric, errorCode, executeSql, parameters, this.options, logEx);
            return n2;
        }
        try {
            int numAffectedRows = this.mock.update(executeSql, DebugSql.printDebugOnlySqlString(executeSql, parameters, this.options));
            metric.checkpoint("stub", numAffectedRows);
            isSuccess = true;
            n = numAffectedRows;
        }
        catch (WrongNumberOfRowsException e) {
            try {
                throw e;
                catch (Exception e2) {
                    errorCode = this.options.generateErrorCode();
                    logEx = e2;
                    throw DatabaseException.wrap(DebugSql.exceptionMessage(executeSql, parameters, errorCode, this.options), e2);
                }
            }
            catch (Throwable throwable) {
                this.adaptor.closeQuietly(ps, log);
                metric.done("close", new Object[0]);
                if (isSuccess) {
                    DebugSql.logSuccess("Update", log, metric, executeSql, parameters, this.options);
                    throw throwable;
                }
                DebugSql.logError("Update", log, metric, errorCode, executeSql, parameters, this.options, logEx);
                throw throwable;
            }
        }
        this.adaptor.closeQuietly(ps, log);
        metric.done("close", new Object[0]);
        if (isSuccess) {
            DebugSql.logSuccess("Update", log, metric, executeSql, parameters, this.options);
            return n;
        }
        DebugSql.logError("Update", log, metric, errorCode, executeSql, parameters, this.options, logEx);
        return n;
    }

    @Nonnull
    private SqlUpdate positionalArg(@Nullable Object arg) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<Object>();
        }
        this.parameterList.add(arg);
        return this;
    }

    @Nonnull
    private SqlUpdate namedArg(@Nonnull String argName, @Nullable Object arg) {
        if (this.parameterMap == null) {
            this.parameterMap = new HashMap<String, Object>();
        }
        if (argName.startsWith(":")) {
            argName = argName.substring(1);
        }
        this.parameterMap.put(argName, arg);
        return this;
    }

    private String booleanToString(Boolean b) {
        return b == null ? null : (b != false ? "Y" : "N");
    }
}

