/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import com.github.susom.database.DatabaseException;
import com.github.susom.database.Flavor;
import com.github.susom.database.MixedParameterSql;
import com.github.susom.database.Options;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Scanner;
import javax.annotation.Nullable;
import oracle.jdbc.OraclePreparedStatement;
import org.slf4j.Logger;

public class StatementAdaptor {
    private final Options options;

    public StatementAdaptor(Options options) {
        this.options = options;
    }

    public void addParameters(PreparedStatement ps, Object[] parameters) throws SQLException {
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter instanceof MixedParameterSql.SecretArg) {
                parameter = ((MixedParameterSql.SecretArg)parameter).getArg();
            }
            if (parameter == null) {
                int parameterType;
                try {
                    ParameterMetaData metaData = ps.getParameterMetaData();
                    parameterType = metaData.getParameterType(i + 1);
                }
                catch (SQLException e) {
                    throw new DatabaseException("Parameter " + (i + 1) + " was null and the JDBC driver could not report the type of this column." + " Please update the JDBC driver to support PreparedStatement.getParameterMetaData()" + " or use SqlNull in place of null values to this query.", e);
                }
                ps.setNull(i + 1, parameterType);
                continue;
            }
            if (parameter instanceof SqlNull) {
                SqlNull sqlNull = (SqlNull)parameter;
                if (this.options.useBytesForBlob() && sqlNull.getType() == 2004) {
                    ps.setBytes(i + 1, null);
                    continue;
                }
                ps.setNull(i + 1, sqlNull.getType());
                continue;
            }
            if (parameter instanceof Date) {
                ps.setTimestamp(i + 1, StatementAdaptor.toSqlTimestamp((Date)parameter), this.options.calendarForTimestamps());
                continue;
            }
            if (parameter instanceof Reader) {
                if (this.options.useStringForClob()) {
                    ps.setString(i + 1, StatementAdaptor.readerToString((Reader)parameter));
                    continue;
                }
                ps.setCharacterStream(i + 1, (Reader)parameter);
                continue;
            }
            if (parameter instanceof InputStream) {
                if (this.options.useBytesForBlob()) {
                    ps.setBytes(i + 1, StatementAdaptor.streamToBytes((InputStream)parameter));
                    continue;
                }
                ps.setBinaryStream(i + 1, (InputStream)parameter);
                continue;
            }
            if (parameter instanceof Float) {
                if (this.options.flavor() == Flavor.oracle && ps.isWrapperFor(OraclePreparedStatement.class)) {
                    ps.unwrap(OraclePreparedStatement.class).setBinaryFloat(i + 1, ((Float)parameter).floatValue());
                    continue;
                }
                ps.setFloat(i + 1, ((Float)parameter).floatValue());
                continue;
            }
            if (parameter instanceof Double) {
                if (this.options.flavor() == Flavor.oracle && ps.isWrapperFor(OraclePreparedStatement.class)) {
                    ps.unwrap(OraclePreparedStatement.class).setBinaryDouble(i + 1, ((Double)parameter).doubleValue());
                    continue;
                }
                ps.setDouble(i + 1, (Double)parameter);
                continue;
            }
            ps.setObject(i + 1, parameter);
        }
    }

    private static String readerToString(Reader r) {
        Scanner s = new Scanner(r).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static byte[] streamToBytes(InputStream is) throws SQLException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new SQLException("Unable to convert InputStream parameter to bytes", e);
        }
        return out.toByteArray();
    }

    private static Timestamp toSqlTimestamp(Date date) {
        long millis = date.getTime();
        int fractionalSecondMillis = (int)(millis % 1000L);
        if (fractionalSecondMillis == 0) {
            if (date instanceof Timestamp) {
                return (Timestamp)date;
            }
            return new Timestamp(millis);
        }
        int tsNanos = fractionalSecondMillis * 1000000;
        long tsMillis = millis - (long)fractionalSecondMillis;
        Timestamp timestamp = new Timestamp(tsMillis);
        timestamp.setNanos(tsNanos);
        return timestamp;
    }

    public Object nullDate(Date arg) {
        if (arg == null) {
            return new SqlNull(93);
        }
        return new Timestamp(arg.getTime());
    }

    public Object nullNumeric(Number arg) {
        if (arg == null) {
            return new SqlNull(2);
        }
        return arg;
    }

    public Object nullString(String arg) {
        if (arg == null) {
            return new SqlNull(12);
        }
        return arg;
    }

    public Object nullClobReader(Reader arg) {
        if (arg == null) {
            return new SqlNull(12);
        }
        return arg;
    }

    public Object nullBytes(byte[] arg) {
        if (arg == null) {
            return new SqlNull(2004);
        }
        return arg;
    }

    public Object nullInputStream(InputStream arg) {
        if (arg == null) {
            return new SqlNull(2004);
        }
        return arg;
    }

    public void closeQuietly(@Nullable ResultSet rs, @Nullable Logger log) {
        block3: {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    if (log == null) break block3;
                    log.warn("Caught exception closing the ResultSet", (Throwable)e);
                }
            }
        }
    }

    public void closeQuietly(@Nullable Statement s, @Nullable Logger log) {
        block3: {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception e) {
                    if (log == null) break block3;
                    log.warn("Caught exception closing the Statement", (Throwable)e);
                }
            }
        }
    }

    class SqlNull {
        int type;

        SqlNull(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }
    }
}

