/*
 * Decompiled with CFR 0.152.
 */
package com.github.susom.database;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Map;
import org.slf4j.MDC;

public class VertxUtil {
    public static <T> void executeBlocking(Vertx vertx, Handler<Future<T>> future, Handler<AsyncResult<T>> handler) {
        VertxUtil.executeBlocking(vertx, future, true, handler);
    }

    public static <T> void executeBlocking(Vertx vertx, Handler<Future<T>> future, boolean ordered, Handler<AsyncResult<T>> handler) {
        Map mdc = MDC.getCopyOfContextMap();
        vertx.executeBlocking(f -> {
            try {
                if (mdc != null) {
                    MDC.setContextMap((Map)mdc);
                }
                future.handle(f);
            }
            finally {
                MDC.clear();
            }
        }, ordered, h -> {
            try {
                if (mdc != null) {
                    MDC.setContextMap((Map)mdc);
                }
                handler.handle(h);
            }
            finally {
                MDC.clear();
            }
        });
    }
}

