/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.github.susom.database.shaded.com.zaxxer.hikari.metrics;

import java.util.concurrent.atomic.AtomicLong;
import shaded.com.github.susom.database.shaded.com.zaxxer.hikari.util.ClockSource;

public abstract class PoolStats {
    private final ClockSource clock;
    private final AtomicLong reloadAt;
    private final long timeoutMs;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;

    public PoolStats(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.reloadAt = new AtomicLong();
        this.clock = ClockSource.INSTANCE;
    }

    public int getTotalConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.totalConnections;
    }

    public int getIdleConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.idleConnections;
    }

    public int getActiveConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.activeConnections;
    }

    public int getPendingThreads() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.pendingThreads;
    }

    protected abstract void update();

    private boolean shouldLoad() {
        long now;
        long reloadTime;
        do {
            now = this.clock.currentTime();
            reloadTime = this.reloadAt.get();
            if (reloadTime <= now) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(reloadTime, this.clock.plusMillis(now, this.timeoutMs)));
        return true;
    }
}

