/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class SecurePatternLayout
extends Layout {
    private static final String DEFAULT_RECORD_SEPARATOR = "\u00ae";
    private static final String DEFAULT_ESCAPE_CHARACTER = "\u00ae";
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    private StringBuffer sbuf = new StringBuffer(256);
    private String pattern;
    private PatternConverter head;
    private String recordSeparator = "\u00ae";
    private String escapeCharacter = "\u00ae";

    public SecurePatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public SecurePatternLayout(String pattern) {
        this.pattern = pattern;
        this.head = this.createPatternParser(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern).parse();
    }

    public void setConversionPattern(String conversionPattern) {
        this.pattern = conversionPattern;
        this.head = this.createPatternParser(conversionPattern).parse();
    }

    public String getConversionPattern() {
        return this.pattern;
    }

    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public void activateOptions() {
    }

    public boolean ignoresThrowable() {
        return false;
    }

    protected PatternParser createPatternParser(String pattern) {
        return new PatternParser(pattern);
    }

    public String format(LoggingEvent event) {
        int nextOccurence;
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        PatternConverter c = this.head;
        while (c != null) {
            c.format(this.sbuf, event);
            c = c.next;
        }
        String[] s = event.getThrowableStrRep();
        if (s != null) {
            int len = s.length;
            for (int i = 0; i < len; ++i) {
                this.sbuf.append(s[i]);
                this.sbuf.append(Layout.LINE_SEP);
            }
        }
        int offset = 0;
        while ((nextOccurence = this.sbuf.indexOf(this.escapeCharacter, offset)) != -1) {
            this.sbuf.insert(nextOccurence, this.escapeCharacter);
            offset = nextOccurence + 2;
        }
        if (!this.recordSeparator.equals(this.escapeCharacter)) {
            offset = 0;
            while ((nextOccurence = this.sbuf.indexOf(this.recordSeparator, offset)) != -1) {
                this.sbuf.insert(nextOccurence, this.escapeCharacter);
                offset = nextOccurence + 2;
            }
        }
        if (this.sbuf.lastIndexOf(Layout.LINE_SEP) == this.sbuf.length() - Layout.LINE_SEP_LEN) {
            this.sbuf.insert(this.sbuf.length() - Layout.LINE_SEP_LEN, this.recordSeparator);
        } else {
            this.sbuf.append(this.recordSeparator);
            this.sbuf.append(Layout.LINE_SEP);
        }
        return this.sbuf.toString();
    }
}

