/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext servletContext = contextEvent.getServletContext();
        String contextPath = servletContext.getContextPath();
        String log4jConfig = servletContext.getInitParameter("log4j.configuration");
        if (log4jConfig != null) {
            if (log4jConfig.contains("${context.path}")) {
                contextPath = contextPath.length() == 0 ? "ROOT" : contextPath.substring(1);
                log4jConfig = log4jConfig.replaceAll("\\$\\{context.path\\}", contextPath);
            }
            try {
                log4jConfig = new File(log4jConfig).getAbsolutePath();
                DOMConfigurator.configure((String)log4jConfig);
            }
            catch (Exception e) {
                servletContext.log("Unable to configure log4j for " + contextPath + " using file: " + log4jConfig, (Throwable)e);
            }
            Logger log = Logger.getLogger(Log4jContextListener.class);
            log.info((Object)("Initialized log4j for " + contextPath + " using file: " + log4jConfig));
        } else {
            servletContext.log("Set servlet context parameter log4j.configuration to enable log4j for " + contextPath);
        }
    }

    public void contextDestroyed(ServletContextEvent contextEvent) {
        ServletContext servletContext = contextEvent.getServletContext();
        String contextPath = servletContext.getContextPath();
        LogManager.shutdown();
        servletContext.log("Shutdown log4j for " + contextPath);
    }
}

