/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.evaluation;

import cc.kave.commons.model.events.completionevents.CompletionEvent;
import cc.kave.commons.model.naming.codeelements.IMethodName;
import com.github.svstoll.csccrecommender.ProductionModule;
import com.github.svstoll.csccrecommender.index.MethodInvocationIndexer;
import com.github.svstoll.csccrecommender.mining.CompletionEventExtractor;
import com.github.svstoll.csccrecommender.recommender.CsccRecommender;
import com.github.svstoll.csccrecommender.recommender.RecommendationResult;
import com.github.svstoll.csccrecommender.utility.StatisticsUtility;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CompletionEventEvaluator {
    public static final Logger LOGGER = LoggerFactory.getLogger(CsccRecommender.class);
    private final String resultsDirectoryPath;
    private final CompletionEventExtractor completionEventExtractor;
    private final CsccRecommender csccRecommender;
    private int recommendationsRequested = 0;
    private int recommendationsMade = 0;
    private long totalRecommendationTimeInMs = 0L;
    private int top1Recommendations = 0;
    private int tp3Recommendations = 0;
    private int top10Recommendations = 0;
    private int extensionContextRecommendationsRequested = 0;
    private int extensionContextRecommendationsMade = 0;
    private int top3ExtensionContextRecommendations = 0;
    private int noneExtensionContextRecommendationsRequested = 0;
    private int noneExtensionContextRecommendationsMade = 0;
    private int top3NoneExtensionContextRecommendations = 0;

    @Inject
    protected CompletionEventEvaluator(@Named(value="resultsDirectory") String resultsDirectoryPath, CompletionEventExtractor completionEventExtractor, CsccRecommender csccRecommender) {
        this.resultsDirectoryPath = resultsDirectoryPath;
        this.completionEventExtractor = completionEventExtractor;
        this.csccRecommender = csccRecommender;
    }

    public static void main(String[] args) {
        LOGGER.info("Starting evaluation of completion events.");
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProductionModule()});
        MethodInvocationIndexer methodInvocationIndexer = (MethodInvocationIndexer)injector.getInstance(MethodInvocationIndexer.class);
        CompletionEventEvaluator completionEventEvaluator = (CompletionEventEvaluator)injector.getInstance(CompletionEventEvaluator.class);
        if (args.length > 0 && "-index".equals(args[0])) {
            methodInvocationIndexer.indexAllAvailableContexts(true);
        }
        completionEventEvaluator.executeEvaluation();
    }

    public void executeEvaluation() {
        this.completionEventExtractor.processAllCompletionEvents(completionEvents -> {
            LOGGER.info("Performing recommendations for {} completion events.", (Object)completionEvents.size());
            for (CompletionEvent completionEvent : completionEvents) {
                List<RecommendationResult> recommendationResults = this.csccRecommender.recommendMethods(completionEvent);
                for (RecommendationResult recommendationResult : recommendationResults) {
                    this.updateStatistics(completionEvent, recommendationResult);
                }
            }
        });
        this.writeEvaluationResults();
    }

    private void updateStatistics(CompletionEvent completionEvent, RecommendationResult recommendationResult) {
        this.updateTotalRecommendationsRequested(recommendationResult);
        this.totalRecommendationTimeInMs += recommendationResult.getRecommendationTimeInMs();
        List<String> recommendedMethods = recommendationResult.getRecommendedMethods();
        String selectedMethodName = ((IMethodName)Objects.requireNonNull(completionEvent.getLastSelectedProposal().getName())).getFullName();
        if (recommendedMethods.isEmpty()) {
            return;
        }
        boolean isTop1 = false;
        boolean isTop3 = false;
        boolean isTop10 = false;
        for (int i = 0; i < recommendedMethods.size() && recommendedMethods.size() < 10; ++i) {
            if (!recommendedMethods.get(i).equals(selectedMethodName)) continue;
            isTop10 = true;
            if (i == 0) {
                isTop1 = true;
                isTop3 = true;
                break;
            }
            if (i >= 3) break;
            isTop3 = true;
            break;
        }
        this.updateRecommendationsMade(recommendationResult);
        this.updateSuccessfulRecommendations(recommendationResult, isTop1, isTop3, isTop10);
    }

    private void updateTotalRecommendationsRequested(RecommendationResult recommendationResult) {
        ++this.recommendationsRequested;
        if (recommendationResult.isOccurredWithinExtensionMethod()) {
            ++this.extensionContextRecommendationsRequested;
        } else {
            ++this.noneExtensionContextRecommendationsRequested;
        }
    }

    private void updateRecommendationsMade(RecommendationResult recommendationResult) {
        ++this.recommendationsMade;
        if (recommendationResult.isOccurredWithinExtensionMethod()) {
            ++this.extensionContextRecommendationsMade;
        } else {
            ++this.noneExtensionContextRecommendationsMade;
        }
    }

    private void updateSuccessfulRecommendations(RecommendationResult recommendationResult, boolean isTop1, boolean isTop3, boolean isTop10) {
        if (isTop1) {
            ++this.top1Recommendations;
        }
        if (isTop3) {
            ++this.tp3Recommendations;
            if (recommendationResult.isOccurredWithinExtensionMethod()) {
                ++this.top3ExtensionContextRecommendations;
            } else {
                ++this.top3NoneExtensionContextRecommendations;
            }
        }
        if (isTop10) {
            ++this.top10Recommendations;
        }
    }

    private void writeEvaluationResults() {
        File resultsDirectory = new File(this.resultsDirectoryPath);
        if (!resultsDirectory.exists()) {
            resultsDirectory.mkdirs();
        }
        Path resultsFilePath = Paths.get(this.resultsDirectoryPath, "completion-event-evaluation-" + System.currentTimeMillis() + ".txt");
        try (PrintWriter pw = new PrintWriter(new FileWriter(resultsFilePath.toFile()));){
            pw.println("Recommendations requested: " + this.recommendationsRequested);
            pw.println("Recommendations made: " + this.recommendationsMade);
            double averageRecommendationTime = 0.0;
            if (this.recommendationsRequested > 0) {
                averageRecommendationTime = (double)this.totalRecommendationTimeInMs / (double)this.recommendationsRequested;
            }
            pw.println("Average recommendation time (ms): " + averageRecommendationTime);
            pw.println();
            pw.println("Overall recall: " + StatisticsUtility.calculateRecall(this.recommendationsRequested, this.recommendationsMade));
            pw.println("Top-1 precision: " + StatisticsUtility.calculatePrecision(this.recommendationsMade, this.top1Recommendations));
            pw.println("Top-3 precision: " + StatisticsUtility.calculatePrecision(this.recommendationsMade, this.tp3Recommendations));
            pw.println("Top-10 precision: " + StatisticsUtility.calculatePrecision(this.recommendationsMade, this.top10Recommendations));
            pw.println();
            pw.println("Recommendations requested within extension methods: " + this.extensionContextRecommendationsRequested);
            pw.println("Recommendations made within extension methods: " + this.extensionContextRecommendationsMade);
            pw.println("Overall recall within extension methods: " + StatisticsUtility.calculateRecall(this.extensionContextRecommendationsRequested, this.extensionContextRecommendationsMade));
            pw.println("Top-3 precision within extension methods: " + StatisticsUtility.calculatePrecision(this.extensionContextRecommendationsMade, this.top3ExtensionContextRecommendations));
            pw.println();
            pw.println("Recommendations requested NONE within extension methods: " + this.noneExtensionContextRecommendationsRequested);
            pw.println("Recommendations made within NONE extension methods: " + this.noneExtensionContextRecommendationsMade);
            pw.println("Overall recall within NONE extension methods: " + StatisticsUtility.calculateRecall(this.noneExtensionContextRecommendationsRequested, this.noneExtensionContextRecommendationsMade));
            pw.println("Top-3 precision within NONE extension methods: " + StatisticsUtility.calculatePrecision(this.noneExtensionContextRecommendationsMade, this.top3NoneExtensionContextRecommendations));
            LOGGER.info("Evaluation finished. The results have been saved to '{}'.", (Object)resultsFilePath);
        }
        catch (IOException e) {
            LOGGER.info("Error writing context evaluation results.", (Throwable)e);
        }
    }
}

