/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.evaluation;

import com.github.svstoll.csccrecommender.utility.StatisticsUtility;

public class ContextEvaluationStatistics {
    private int recommendationsRequested = 0;
    private int recommendationsMade = 0;
    private int top1Recommendations = 0;
    private int top3Recommendations = 0;
    private int top10Recommendations = 0;

    public void update(boolean isRecommendationMade, boolean isTop1, boolean isTop3, boolean isTop10) {
        ++this.recommendationsRequested;
        if (!isRecommendationMade) {
            return;
        }
        ++this.recommendationsMade;
        if (isTop1) {
            ++this.top1Recommendations;
        }
        if (isTop3) {
            ++this.top3Recommendations;
        }
        if (isTop10) {
            ++this.top10Recommendations;
        }
    }

    public double calculateRecall() {
        return StatisticsUtility.calculateRecall(this.recommendationsRequested, this.recommendationsMade);
    }

    public double calculateTop1Precision() {
        return StatisticsUtility.calculatePrecision(this.recommendationsMade, this.top1Recommendations);
    }

    public double calculateTop3Precision() {
        return StatisticsUtility.calculatePrecision(this.recommendationsMade, this.top3Recommendations);
    }

    public double calculateTop10Precision() {
        return StatisticsUtility.calculatePrecision(this.recommendationsMade, this.top10Recommendations);
    }

    public double calculateTop1FMeasure() {
        return StatisticsUtility.calculateFMeasure(this.calculateTop1Precision(), this.calculateRecall());
    }

    public double calculateTop3FMeasure() {
        return StatisticsUtility.calculateFMeasure(this.calculateTop3Precision(), this.calculateRecall());
    }

    public double calculateTop10FMeasure() {
        return StatisticsUtility.calculateFMeasure(this.calculateTop10Precision(), this.calculateRecall());
    }

    public int getRecommendationsRequested() {
        return this.recommendationsRequested;
    }

    public int getRecommendationsMade() {
        return this.recommendationsMade;
    }

    public int getTop1Recommendations() {
        return this.top1Recommendations;
    }

    public int getTop3Recommendations() {
        return this.top3Recommendations;
    }

    public int getTop10Recommendations() {
        return this.top10Recommendations;
    }
}

