/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.evaluation;

import com.github.svstoll.csccrecommender.ProductionModule;
import com.github.svstoll.csccrecommender.evaluation.ContextEvaluationStatistics;
import com.github.svstoll.csccrecommender.index.MethodInvocationIndex;
import com.github.svstoll.csccrecommender.index.MethodInvocationIndexer;
import com.github.svstoll.csccrecommender.recommender.CsccRecommender;
import com.github.svstoll.csccrecommender.utility.FileUtility;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Named;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrossProjectEvaluator.class);
    private static final String MASKED_FILE_ENDING = ".masked";
    private final String contextsDirectoryPath;
    private final String resultsDirectoryPath;
    private final MethodInvocationIndex methodInvocationIndex;
    private final MethodInvocationIndexer methodInvocationIndexer;
    private final CsccRecommender csccRecommender;

    @Inject
    protected CrossProjectEvaluator(@Named(value="contextsDirectory") String contextsDirectoryPath, @Named(value="resultsDirectory") String resultsDirectoryPath, MethodInvocationIndex methodInvocationIndex, MethodInvocationIndexer methodInvocationIndexer, CsccRecommender csccRecommender) {
        this.contextsDirectoryPath = contextsDirectoryPath;
        this.resultsDirectoryPath = resultsDirectoryPath;
        this.methodInvocationIndex = methodInvocationIndex;
        this.methodInvocationIndexer = methodInvocationIndexer;
        this.csccRecommender = csccRecommender;
    }

    public static void main(String[] args) {
        LOGGER.info("Starting context based evaluation.");
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProductionModule()});
        CrossProjectEvaluator evaluator = (CrossProjectEvaluator)injector.getInstance(CrossProjectEvaluator.class);
        int splits = 2;
        if (args.length > 0) {
            try {
                splits = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("The provided number of project splits could not be parsed. Using default of 2.", (Throwable)e);
            }
        }
        evaluator.trainAndEvaluateOnContextDataset(splits);
    }

    public void trainAndEvaluateOnContextDataset(int splits) {
        List<String[]> groups;
        this.methodInvocationIndex.clearIndex();
        try {
            groups = this.splitContextDataset(splits);
        }
        catch (IllegalStateException e) {
            LOGGER.error("Context evaluation could not be executed.", (Throwable)e);
            return;
        }
        int evaluationGroup = 0;
        List<String> maskedFiles = this.maskZipFiles(groups.get(evaluationGroup));
        this.methodInvocationIndexer.indexAllAvailableContexts(true);
        this.unmaskZipFiles(maskedFiles);
        maskedFiles.clear();
        for (int j = 0; j < splits; ++j) {
            if (j == evaluationGroup) continue;
            maskedFiles.addAll(this.maskZipFiles(groups.get(j)));
        }
        ContextEvaluationStatistics statistics = new ContextEvaluationStatistics();
        this.csccRecommender.recommendForAllInvocationsInAvailableContexts(statistics);
        this.unmaskZipFiles(maskedFiles);
        this.writeEvaluationResults(statistics);
    }

    private List<String[]> splitContextDataset(int splits) {
        File file = new File(this.contextsDirectoryPath);
        String[] directories = file.list((current, name) -> new File(current, name).isDirectory());
        if (directories == null || directories.length == 0) {
            throw new IllegalStateException("Contexts directory does not exist or is empty.");
        }
        if (directories.length < splits) {
            throw new IllegalStateException("Number of splits is greater than number of available projects.");
        }
        LOGGER.info("Splitting context dataset.");
        Collections.shuffle(Arrays.asList(directories), new Random(949666788L));
        int groupSize = directories.length / splits;
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < splits; ++i) {
            String[] groupNames = new String[groupSize];
            System.arraycopy(directories, i * groupSize, groupNames, 0, groupSize);
            LOGGER.info("Projects in group {}: {}", (Object)i, (Object)groupNames);
            list.add(groupNames);
        }
        return list;
    }

    private List<String> maskZipFiles(String[] toBeMasked) {
        ArrayList<String> maskedZips = new ArrayList<String>();
        for (String zipFile : toBeMasked) {
            List<String> zips = FileUtility.findAllZipFilePaths(Paths.get(this.contextsDirectoryPath, zipFile).toString());
            for (String zip : zips) {
                File file = new File(zip);
                boolean success = file.renameTo(new File(file + MASKED_FILE_ENDING));
                if (!success) {
                    LOGGER.warn("Failed to mask zip '{}'.", (Object)zip);
                }
                maskedZips.add(file + MASKED_FILE_ENDING);
            }
        }
        return maskedZips;
    }

    private void unmaskZipFiles(List<String> maskedZips) {
        for (String maskedZip : maskedZips) {
            String fileName;
            File file = new File(maskedZip);
            boolean success = file.renameTo(new File((fileName = file.getAbsolutePath()).substring(0, fileName.length() - MASKED_FILE_ENDING.length())));
            if (success) continue;
            LOGGER.warn("Failed to unmask zip '{}'.", (Object)maskedZip);
        }
    }

    private void writeEvaluationResults(ContextEvaluationStatistics statistics) {
        File resultsDirectory = new File(this.resultsDirectoryPath);
        if (!resultsDirectory.exists()) {
            resultsDirectory.mkdirs();
        }
        Path resultsFilePath = Paths.get(this.resultsDirectoryPath, "cross-project-evaluation-" + System.currentTimeMillis() + ".txt");
        try (PrintWriter pw = new PrintWriter(new FileWriter(resultsFilePath.toFile()));){
            pw.println("Requested recommendations: " + statistics.getRecommendationsRequested());
            pw.println("Recommendations made: " + statistics.getRecommendationsMade());
            pw.println("Overall recall: " + statistics.calculateRecall());
            pw.println();
            pw.println("Top-1 precision: " + statistics.calculateTop1Precision());
            pw.println("Top-1 F-measure: " + statistics.calculateTop1FMeasure());
            pw.println();
            pw.println("Top-3 precision: " + statistics.calculateTop3Precision());
            pw.println("Top-3 F-measure: " + statistics.calculateTop3FMeasure());
            pw.println();
            pw.println("Top-10 precision: " + statistics.calculateTop10Precision());
            pw.println("Top-10 F-measure: " + statistics.calculateTop10FMeasure());
            pw.println();
            LOGGER.info("Evaluation finished. The results have been saved to '{}'.", (Object)resultsFilePath);
        }
        catch (IOException e) {
            LOGGER.info("Error writing context evaluation results.", (Throwable)e);
        }
    }
}

