/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.index;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MethodInvocationIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodInvocationIndex.class);
    private final String indexDirectoryPath;

    @Inject
    protected MethodInvocationIndex(@Named(value="indexDirectory") String indexDirectoryPath) {
        this.indexDirectoryPath = indexDirectoryPath;
    }

    public void clearIndex() {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)analyzer);
        try (FSDirectory indexDirectory = FSDirectory.open((Path)Paths.get(this.indexDirectoryPath, new String[0]));
             IndexWriter indexWriter = new IndexWriter((Directory)indexDirectory, indexWriterConfig);){
            indexWriter.deleteAll();
            indexWriter.commit();
            LOGGER.info("Index cleared.");
        }
        catch (IOException exception) {
            LOGGER.error("Error clearing method call index.", (Throwable)exception);
        }
    }

    public void indexDocuments(List<Document> documents) {
        long start = System.currentTimeMillis();
        StandardAnalyzer analyzer = new StandardAnalyzer();
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)analyzer);
        try (FSDirectory indexDirectory = FSDirectory.open((Path)Paths.get(this.indexDirectoryPath, new String[0]));
             IndexWriter indexWriter = new IndexWriter((Directory)indexDirectory, indexWriterConfig);){
            for (Document document : documents) {
                indexWriter.addDocument((Iterable)document);
            }
            indexWriter.commit();
            long end = System.currentTimeMillis();
            LOGGER.info("Indexing {} documents took {} ms.", (Object)documents.size(), (Object)(end - start));
        }
        catch (IOException exception) {
            LOGGER.error("Error indexing cached documents.", (Throwable)exception);
        }
    }

    public List<Document> searchMethodInvocationDocuments(String type, List<String> tokens) {
        TermQuery typeQuery = new TermQuery(new Term("type", type));
        BooleanQuery.Builder contextQueryBuilder = new BooleanQuery.Builder();
        for (String token : tokens) {
            TermQuery tokenQuery = new TermQuery(new Term("overallContext", token));
            contextQueryBuilder.add((Query)tokenQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery contextQuery = contextQueryBuilder.build();
        BooleanQuery query = new BooleanQuery.Builder().add((Query)typeQuery, BooleanClause.Occur.MUST).add((Query)contextQuery, BooleanClause.Occur.MUST).build();
        ArrayList<Document> documents = new ArrayList<Document>();
        try (FSDirectory indexDirectory = FSDirectory.open((Path)Paths.get(this.indexDirectoryPath, new String[0]));
             DirectoryReader indexReader = DirectoryReader.open((Directory)indexDirectory);){
            IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
            TopDocs topDocs = searcher.search((Query)query, 200);
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                documents.add(searcher.doc(scoreDoc.doc));
            }
        }
        catch (IOException exception) {
            LOGGER.error("Error searching index for method call documents.", (Throwable)exception);
        }
        return documents;
    }
}

