/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import cc.kave.commons.model.events.IIDEEvent;
import cc.kave.commons.model.events.completionevents.CompletionEvent;
import cc.kave.commons.model.events.completionevents.TerminationState;
import cc.kave.commons.model.naming.codeelements.IMethodName;
import cc.kave.commons.utils.io.ReadingArchive;
import com.github.svstoll.csccrecommender.mining.CompletionEventExtractionConsumer;
import com.github.svstoll.csccrecommender.utility.FileUtility;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionEventExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompletionEventExtractor.class);
    private final String eventsDirectory;

    @Inject
    protected CompletionEventExtractor(@Named(value="eventsDirectory") String eventsDirectory) {
        this.eventsDirectory = eventsDirectory;
    }

    public void processAllCompletionEvents(CompletionEventExtractionConsumer consumer) {
        List<String> userZips = FileUtility.findAllZipFilePaths(this.eventsDirectory);
        for (String zipFilePath : userZips) {
            LOGGER.info("Extracting events from '{}'.", (Object)zipFilePath);
            long start = System.currentTimeMillis();
            ArrayList<CompletionEvent> completionEvents = new ArrayList<CompletionEvent>();
            try (ReadingArchive readingArchive = new ReadingArchive(new File(zipFilePath));){
                while (readingArchive.hasNext()) {
                    IIDEEvent event = (IIDEEvent)readingArchive.getNext(IIDEEvent.class);
                    this.identifyCompletionEvent(event, completionEvents);
                }
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Extraction took {} ms.", (Object)(end - start));
            consumer.consume(completionEvents);
        }
    }

    private void identifyCompletionEvent(IIDEEvent event, List<CompletionEvent> completionEvents) {
        CompletionEvent completionEvent;
        if (event instanceof CompletionEvent && (completionEvent = (CompletionEvent)event).getLastSelectedProposal() != null && completionEvent.terminatedState == TerminationState.Applied && completionEvent.getLastSelectedProposal().getName() instanceof IMethodName) {
            completionEvents.add(completionEvent);
        }
    }
}

