/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import cc.kave.commons.model.events.completionevents.Context;
import cc.kave.commons.utils.io.ReadingArchive;
import com.github.svstoll.csccrecommender.mining.ContextExtractionConsumer;
import com.github.svstoll.csccrecommender.utility.FileUtility;
import com.github.svstoll.csccrecommender.utility.StringUtility;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextExtractor.class);
    private final String miningDirectory;

    @Inject
    protected ContextExtractor(@Named(value="contextsDirectory") String miningDirectory) {
        this.miningDirectory = miningDirectory;
    }

    public void processAllContexts(ContextExtractionConsumer contextExtractionConsumer) {
        if (StringUtility.isNullOrEmpty(this.miningDirectory)) {
            return;
        }
        for (String zipFilePath : FileUtility.findAllZipFilePaths(this.miningDirectory)) {
            LOGGER.info("Extracting contexts from '{}'.", (Object)zipFilePath);
            long start = System.currentTimeMillis();
            List<Context> contexts = this.extractContextsFromZipFile(zipFilePath);
            long end = System.currentTimeMillis();
            LOGGER.info("Extraction took {} ms.", (Object)(end - start));
            contextExtractionConsumer.consume(contexts);
        }
    }

    private List<Context> extractContextsFromZipFile(String zipFilePath) {
        LinkedList contexts = Lists.newLinkedList();
        try (ReadingArchive readingArchive = new ReadingArchive(new File(zipFilePath));){
            while (readingArchive.hasNext()) {
                contexts.add(readingArchive.getNext(Context.class));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract context from ZIP File '{}'.", (Object)zipFilePath, (Object)e);
        }
        return contexts;
    }
}

