/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import cc.kave.commons.model.naming.codeelements.IMethodName;
import cc.kave.commons.model.ssts.visitor.ISSTNode;
import cc.kave.commons.model.ssts.visitor.ISSTNodeVisitor;
import com.github.svstoll.csccrecommender.mining.LineContext;
import com.github.svstoll.csccrecommender.mining.LineContextVisitor;
import com.github.svstoll.csccrecommender.utility.CollectionUtility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class CsccContext {
    public static final String EMPTY_CONTEXT_IDENTIFIER = "!EMPTY!";
    private final Queue<LineContext> lineContexts = new ArrayDeque<LineContext>();
    private final LineContextVisitor lineContextVisitor;
    private IMethodName currentMethodName = null;
    private boolean currentlyWithinExtensionMethod = false;
    private LineContext mostRecentLineContext = null;

    public CsccContext(LineContextVisitor lineContextVisitor) {
        this.lineContextVisitor = lineContextVisitor;
    }

    public void addLineContext(ISSTNode node, String ... tokens) {
        LineContext lineContext = new LineContext(this);
        lineContext.setNode(node);
        for (String token : tokens) {
            lineContext.addToken(token);
        }
        if (this.lineContexts.size() > 4) {
            this.lineContexts.poll();
        }
        this.lineContexts.add(lineContext);
        this.mostRecentLineContext = lineContext;
        if (node != null) {
            lineContext.getNode().accept((ISSTNodeVisitor)this.lineContextVisitor, (Object)lineContext);
        }
    }

    public List<String> getOverallContextTokens() {
        ArrayList<String> overallContext = new ArrayList<String>();
        for (LineContext lineContext : this.lineContexts) {
            overallContext.addAll(lineContext.getTokens());
        }
        if (overallContext.isEmpty()) {
            overallContext.add(EMPTY_CONTEXT_IDENTIFIER);
        }
        return CollectionUtility.removeDuplicates(overallContext);
    }

    public List<String> getLineContextTokens() {
        return CollectionUtility.removeDuplicates(this.mostRecentLineContext.getTokens());
    }

    public void clear() {
        this.lineContexts.clear();
        this.mostRecentLineContext = null;
    }

    public IMethodName getCurrentMethodName() {
        return this.currentMethodName;
    }

    public void setCurrentMethodName(IMethodName currentMethodName) {
        this.currentMethodName = currentMethodName;
    }

    public boolean isCurrentlyWithinExtensionMethod() {
        return this.currentlyWithinExtensionMethod;
    }

    public void setCurrentlyWithinExtensionMethod(boolean currentlyWithinExtensionMethod) {
        this.currentlyWithinExtensionMethod = currentlyWithinExtensionMethod;
    }
}

