/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import cc.kave.commons.model.ssts.blocks.CatchBlockKind;
import cc.kave.commons.model.ssts.blocks.ICaseBlock;
import cc.kave.commons.model.ssts.blocks.ICatchBlock;
import cc.kave.commons.model.ssts.blocks.IDoLoop;
import cc.kave.commons.model.ssts.blocks.IForEachLoop;
import cc.kave.commons.model.ssts.blocks.IForLoop;
import cc.kave.commons.model.ssts.blocks.IIfElseBlock;
import cc.kave.commons.model.ssts.blocks.ILockBlock;
import cc.kave.commons.model.ssts.blocks.ISwitchBlock;
import cc.kave.commons.model.ssts.blocks.ITryBlock;
import cc.kave.commons.model.ssts.blocks.IUncheckedBlock;
import cc.kave.commons.model.ssts.blocks.IUnsafeBlock;
import cc.kave.commons.model.ssts.blocks.IUsingBlock;
import cc.kave.commons.model.ssts.blocks.IWhileLoop;
import cc.kave.commons.model.ssts.declarations.IDelegateDeclaration;
import cc.kave.commons.model.ssts.declarations.IEventDeclaration;
import cc.kave.commons.model.ssts.declarations.IFieldDeclaration;
import cc.kave.commons.model.ssts.declarations.IMethodDeclaration;
import cc.kave.commons.model.ssts.declarations.IPropertyDeclaration;
import cc.kave.commons.model.ssts.expressions.assignable.ICompletionExpression;
import cc.kave.commons.model.ssts.expressions.assignable.ILambdaExpression;
import cc.kave.commons.model.ssts.expressions.loopheader.ILoopHeaderBlockExpression;
import cc.kave.commons.model.ssts.impl.visitor.AbstractTraversingNodeVisitor;
import cc.kave.commons.model.ssts.statements.IAssignment;
import cc.kave.commons.model.ssts.statements.IBreakStatement;
import cc.kave.commons.model.ssts.statements.IContinueStatement;
import cc.kave.commons.model.ssts.statements.IEventSubscriptionStatement;
import cc.kave.commons.model.ssts.statements.IExpressionStatement;
import cc.kave.commons.model.ssts.statements.IGotoStatement;
import cc.kave.commons.model.ssts.statements.ILabelledStatement;
import cc.kave.commons.model.ssts.statements.IReturnStatement;
import cc.kave.commons.model.ssts.statements.IThrowStatement;
import cc.kave.commons.model.ssts.statements.IVariableDeclaration;
import cc.kave.commons.model.ssts.visitor.ISSTNode;
import cc.kave.commons.model.ssts.visitor.ISSTNodeVisitor;
import cc.kave.commons.utils.ssts.SSTPrintingContext;
import cc.kave.commons.utils.ssts.SSTPrintingVisitor;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CsccContextVisitor
extends AbstractTraversingNodeVisitor<CsccContext, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsccContextVisitor.class);

    public Void visit(IDelegateDeclaration stmt, CsccContext context) {
        return null;
    }

    public Void visit(IEventDeclaration stmt, CsccContext context) {
        return null;
    }

    public Void visit(IFieldDeclaration stmt, CsccContext context) {
        return null;
    }

    public Void visit(IMethodDeclaration decl, CsccContext context) {
        context.clear();
        context.setCurrentMethodName(decl.getName());
        context.setCurrentlyWithinExtensionMethod(decl.getName().isExtensionMethod());
        if (LOGGER.isDebugEnabled()) {
            SSTPrintingContext printingContext = new SSTPrintingContext();
            decl.accept((ISSTNodeVisitor)new SSTPrintingVisitor(), (Object)printingContext);
            LOGGER.debug("Method currently traversed:\n{}", (Object)printingContext);
        }
        this.visit(decl.getBody(), context);
        return null;
    }

    public Void visit(IPropertyDeclaration decl, CsccContext context) {
        context.clear();
        this.visit(decl.getGet(), context);
        context.clear();
        this.visit(decl.getSet(), context);
        return null;
    }

    public Void visit(IVariableDeclaration stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IAssignment stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IBreakStatement stmt, CsccContext context) {
        context.addLineContext(null, "break");
        return null;
    }

    public Void visit(IContinueStatement stmt, CsccContext context) {
        context.addLineContext(null, "continue");
        return null;
    }

    public Void visit(IEventSubscriptionStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IExpressionStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IGotoStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        return null;
    }

    public Void visit(ILabelledStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getStatement().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IReturnStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IThrowStatement stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt, new String[0]);
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IDoLoop block, CsccContext context) {
        context.addLineContext(null, "do");
        this.visit(block.getBody(), context);
        context.addLineContext((ISSTNode)block.getCondition(), "while");
        block.getCondition().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IForEachLoop block, CsccContext context) {
        context.addLineContext((ISSTNode)block, new String[0]);
        block.getDeclaration().accept((ISSTNodeVisitor)this, (Object)context);
        block.getLoopedReference().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(block.getBody(), context);
        return null;
    }

    public Void visit(IForLoop block, CsccContext context) {
        context.addLineContext((ISSTNode)block, new String[0]);
        this.visit(block.getInit(), context);
        block.getCondition().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(block.getStep(), context);
        this.visit(block.getBody(), context);
        return null;
    }

    public Void visit(IIfElseBlock block, CsccContext context) {
        context.addLineContext((ISSTNode)block.getCondition(), "if");
        block.getCondition().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(block.getThen(), context);
        this.visit(block.getElse(), context);
        return null;
    }

    public Void visit(ILockBlock stmt, CsccContext context) {
        context.addLineContext((ISSTNode)stmt.getReference(), "lock");
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(stmt.getBody(), context);
        return null;
    }

    public Void visit(ISwitchBlock block, CsccContext context) {
        context.addLineContext((ISSTNode)block.getReference(), "switch");
        block.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        for (ICaseBlock caseBlock : block.getSections()) {
            context.addLineContext((ISSTNode)caseBlock.getLabel(), "case");
            caseBlock.getLabel().accept((ISSTNodeVisitor)this, (Object)context);
            this.visit(caseBlock.getBody(), context);
        }
        if (!block.getDefaultSection().isEmpty()) {
            context.addLineContext(null, "default");
            this.visit(block.getDefaultSection(), context);
        }
        return null;
    }

    public Void visit(ITryBlock block, CsccContext context) {
        context.addLineContext(null, "try");
        this.visit(block.getBody(), context);
        for (ICatchBlock catchBlock : block.getCatchBlocks()) {
            if (catchBlock.getKind() == CatchBlockKind.General) {
                context.addLineContext(null, "catch");
            } else {
                context.addLineContext(null, "catch", catchBlock.getParameter().getValueType().getName());
            }
            this.visit(catchBlock.getBody(), context);
        }
        if (!block.getFinally().isEmpty()) {
            context.addLineContext(null, "finally");
            this.visit(block.getFinally(), context);
        }
        return null;
    }

    public Void visit(IUncheckedBlock block, CsccContext context) {
        context.addLineContext(null, "unchecked");
        this.visit(block.getBody(), context);
        return null;
    }

    public Void visit(IUnsafeBlock block, CsccContext context) {
        return null;
    }

    public Void visit(IUsingBlock block, CsccContext context) {
        context.addLineContext((ISSTNode)block.getReference(), "using");
        block.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(block.getBody(), context);
        return null;
    }

    public Void visit(IWhileLoop block, CsccContext context) {
        context.addLineContext((ISSTNode)block.getCondition(), "while");
        block.getCondition().accept((ISSTNodeVisitor)this, (Object)context);
        this.visit(block.getBody(), context);
        return null;
    }

    public Void visit(ICompletionExpression entity, CsccContext context) {
        if (entity.getVariableReference() != null) {
            entity.getVariableReference().accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(ILambdaExpression expr, CsccContext context) {
        context.addLineContext((ISSTNode)expr, new String[0]);
        this.visit(expr.getBody(), context);
        return null;
    }

    public Void visit(ILoopHeaderBlockExpression expr, CsccContext context) {
        this.visit(expr.getBody(), context);
        return null;
    }
}

