/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import com.github.svstoll.csccrecommender.index.MethodInvocationDocumentBuilder;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.github.svstoll.csccrecommender.mining.LineContextVisitor;
import com.github.svstoll.csccrecommender.utility.CollectionUtility;
import com.github.svstoll.csccrecommender.utility.SstUtility;
import com.github.tomtung.jsimhash.SimHashBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexingLineContextVisitor
extends LineContextVisitor {
    public static final Logger LOGGER = LoggerFactory.getLogger(IndexingLineContextVisitor.class);
    private final List<Document> cachedDocuments = new ArrayList<Document>();

    @Override
    protected void handleMethodInvocation(String methodName, String invocationType, CsccContext csccContext) {
        if (!SstUtility.isValidToken(methodName) || !SstUtility.isValidToken(invocationType)) {
            return;
        }
        LOGGER.debug("Indexing method invocation.\nMethod name: {}\nInvocation type: {}\nOverall context tokens: {}\nLine context tokens: {}", new Object[]{methodName, invocationType, csccContext.getOverallContextTokens(), csccContext.getLineContextTokens()});
        SimHashBuilder simHashBuilder = new SimHashBuilder();
        String overallContextTokens = CollectionUtility.concatenateStrings(csccContext.getOverallContextTokens(), " ");
        simHashBuilder.addStringFeature((CharSequence)overallContextTokens);
        long overallContextSimHash = simHashBuilder.computeResult();
        simHashBuilder.reset();
        String lineContextTokens = CollectionUtility.concatenateStrings(csccContext.getLineContextTokens(), " ");
        simHashBuilder.addStringFeature((CharSequence)lineContextTokens);
        long lineContextSimHash = simHashBuilder.computeResult();
        Document methodCallDocument = new MethodInvocationDocumentBuilder().withMethodName(methodName).withType(invocationType).withOverallContext(overallContextTokens).withLineContext(lineContextTokens).withOverallContextSimHash(overallContextSimHash).withLineContextSimHash(lineContextSimHash).createDocument();
        this.cachedDocuments.add(methodCallDocument);
    }

    public List<Document> getCachedDocuments() {
        return this.cachedDocuments;
    }
}

