/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import com.github.svstoll.csccrecommender.evaluation.ContextEvaluationStatistics;
import com.github.svstoll.csccrecommender.index.MethodInvocationIndex;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.github.svstoll.csccrecommender.mining.RecommendingLineContextVisitor;
import com.github.svstoll.csccrecommender.utility.SstUtility;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvocationRecommendationLineContextVisitor
extends RecommendingLineContextVisitor {
    public static final Logger LOGGER = LoggerFactory.getLogger(InvocationRecommendationLineContextVisitor.class);
    private final ContextEvaluationStatistics contextEvaluationStatistics;

    public InvocationRecommendationLineContextVisitor(MethodInvocationIndex methodInvocationIndex, ContextEvaluationStatistics contextEvaluationStatistics) {
        super(methodInvocationIndex);
        this.contextEvaluationStatistics = contextEvaluationStatistics;
    }

    @Override
    protected void handleMethodInvocation(String methodName, String invocationType, CsccContext csccContext) {
        if (!SstUtility.isValidToken(invocationType) || !SstUtility.isValidToken(methodName)) {
            return;
        }
        this.getRecommendationResults().clear();
        super.handleCompletionExpression(invocationType, csccContext);
        if (this.getRecommendationResults().isEmpty()) {
            return;
        }
        List<String> recommendations = this.getRecommendationResults().get(0).getRecommendedMethods();
        boolean isTop1 = false;
        boolean isTop3 = false;
        boolean isTop10 = false;
        for (int i = 0; i < recommendations.size() && i < 10; ++i) {
            if (!recommendations.get(i).equals(methodName)) continue;
            isTop10 = true;
            if (i < 1) {
                isTop1 = true;
                isTop3 = true;
                break;
            }
            if (i >= 3) break;
            isTop3 = true;
            break;
        }
        this.contextEvaluationStatistics.update(!recommendations.isEmpty(), isTop1, isTop3, isTop10);
    }
}

