/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import cc.kave.commons.model.naming.codeelements.IMethodName;
import cc.kave.commons.model.naming.codeelements.IParameterName;
import cc.kave.commons.model.ssts.IReference;
import cc.kave.commons.model.ssts.blocks.IForEachLoop;
import cc.kave.commons.model.ssts.blocks.IUncheckedBlock;
import cc.kave.commons.model.ssts.blocks.IUnsafeBlock;
import cc.kave.commons.model.ssts.blocks.IUsingBlock;
import cc.kave.commons.model.ssts.expressions.ISimpleExpression;
import cc.kave.commons.model.ssts.expressions.assignable.CastOperator;
import cc.kave.commons.model.ssts.expressions.assignable.IBinaryExpression;
import cc.kave.commons.model.ssts.expressions.assignable.ICastExpression;
import cc.kave.commons.model.ssts.expressions.assignable.ICompletionExpression;
import cc.kave.commons.model.ssts.expressions.assignable.IComposedExpression;
import cc.kave.commons.model.ssts.expressions.assignable.IIfElseExpression;
import cc.kave.commons.model.ssts.expressions.assignable.IIndexAccessExpression;
import cc.kave.commons.model.ssts.expressions.assignable.IInvocationExpression;
import cc.kave.commons.model.ssts.expressions.assignable.ILambdaExpression;
import cc.kave.commons.model.ssts.expressions.assignable.ITypeCheckExpression;
import cc.kave.commons.model.ssts.expressions.assignable.IUnaryExpression;
import cc.kave.commons.model.ssts.expressions.simple.IConstantValueExpression;
import cc.kave.commons.model.ssts.expressions.simple.INullExpression;
import cc.kave.commons.model.ssts.expressions.simple.IReferenceExpression;
import cc.kave.commons.model.ssts.impl.visitor.AbstractTraversingNodeVisitor;
import cc.kave.commons.model.ssts.references.IEventReference;
import cc.kave.commons.model.ssts.references.IFieldReference;
import cc.kave.commons.model.ssts.references.IIndexAccessReference;
import cc.kave.commons.model.ssts.references.IMethodReference;
import cc.kave.commons.model.ssts.references.IPropertyReference;
import cc.kave.commons.model.ssts.references.IVariableReference;
import cc.kave.commons.model.ssts.statements.IAssignment;
import cc.kave.commons.model.ssts.statements.IBreakStatement;
import cc.kave.commons.model.ssts.statements.IContinueStatement;
import cc.kave.commons.model.ssts.statements.IEventSubscriptionStatement;
import cc.kave.commons.model.ssts.statements.IExpressionStatement;
import cc.kave.commons.model.ssts.statements.IGotoStatement;
import cc.kave.commons.model.ssts.statements.ILabelledStatement;
import cc.kave.commons.model.ssts.statements.IReturnStatement;
import cc.kave.commons.model.ssts.statements.IThrowStatement;
import cc.kave.commons.model.ssts.statements.IVariableDeclaration;
import cc.kave.commons.model.ssts.visitor.ISSTNodeVisitor;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.github.svstoll.csccrecommender.mining.LineContext;
import com.github.svstoll.csccrecommender.utility.SstUtility;
import com.github.svstoll.csccrecommender.utility.StringUtility;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LineContextVisitor
extends AbstractTraversingNodeVisitor<LineContext, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineContextVisitor.class);
    private final Map<String, String> variableDeclarations = new HashMap<String, String>();

    public Void visit(ICompletionExpression entity, LineContext context) {
        if (entity.getVariableReference() != null) {
            String type = this.variableDeclarations.get(entity.getVariableReference().getIdentifier());
            if (SstUtility.isValidToken(type)) {
                this.handleCompletionExpression(type, context.getCsccContext());
            } else {
                LOGGER.warn("Recommendation failed because the type of the variable reference could not be resolved for the completion expression.");
            }
        } else if (entity.getTypeReference() != null) {
            String type = entity.getTypeReference().getFullName();
            if (SstUtility.isValidToken(type)) {
                this.handleCompletionExpression(entity.getTypeReference().getFullName(), context.getCsccContext());
            } else {
                LOGGER.warn("Recommendation failed because the type of the static reference could not be resolved for the completion expression.");
            }
        } else if (context.getCsccContext().getCurrentMethodName() != null) {
            String type = context.getCsccContext().getCurrentMethodName().getDeclaringType().getFullName();
            if (SstUtility.isValidToken(type)) {
                this.handleCompletionExpression(type, context.getCsccContext());
            } else {
                LOGGER.warn("Recommendation failed because the declaring type of the method where the completion expression occurred could not be resolved.");
            }
        } else {
            LOGGER.warn("Recommendation failed because there was neither a static type reference nor a variable reference associated with the completion expression and the type of the entity declaring the method was also unknown.");
        }
        return null;
    }

    protected void handleCompletionExpression(String invocationType, CsccContext csccContext) {
    }

    public Void visit(IVariableDeclaration stmt, LineContext context) {
        this.variableDeclarations.put(stmt.getReference().getIdentifier(), stmt.getType().getFullName());
        context.addToken(SstUtility.resolveTypeNameToken(stmt.getType()));
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IAssignment stmt, LineContext context) {
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        context.addToken("=");
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IBreakStatement stmt, LineContext context) {
        context.addToken("break");
        return null;
    }

    public Void visit(IContinueStatement stmt, LineContext context) {
        context.addToken("continue");
        return null;
    }

    public Void visit(IExpressionStatement stmt, LineContext context) {
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IGotoStatement stmt, LineContext context) {
        context.addToken("goto");
        return null;
    }

    public Void visit(ILabelledStatement stmt, LineContext context) {
        stmt.getStatement().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IReturnStatement stmt, LineContext context) {
        context.addToken("return");
        if (!stmt.isVoid()) {
            stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(IThrowStatement stmt, LineContext context) {
        context.addToken("throw");
        if (!stmt.isReThrow()) {
            context.addToken("new");
            stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(IForEachLoop block, LineContext context) {
        context.addToken("foreach");
        context.addToken(SstUtility.resolveTypeNameToken(block.getDeclaration().getType()));
        block.getDeclaration().getReference().accept((ISSTNodeVisitor)this, (Object)context);
        context.addToken("in");
        block.getLoopedReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IUncheckedBlock block, LineContext context) {
        context.addToken("unchecked");
        return null;
    }

    public Void visit(IUnsafeBlock block, LineContext context) {
        context.addToken("unsafe");
        return null;
    }

    public Void visit(IUsingBlock block, LineContext context) {
        context.addToken("using");
        block.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IComposedExpression expr, LineContext context) {
        context.addToken("composed");
        for (IReference reference : expr.getReferences()) {
            reference.accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(IIfElseExpression expr, LineContext context) {
        expr.getCondition().accept((ISSTNodeVisitor)this, (Object)context);
        context.addToken("?");
        expr.getThenExpression().accept((ISSTNodeVisitor)this, (Object)context);
        context.addToken(":");
        expr.getElseExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IInvocationExpression expr, LineContext context) {
        IMethodName methodName = expr.getMethodName();
        String type = methodName.getDeclaringType().getFullName();
        if (methodName.isConstructor()) {
            context.addToken("new");
            this.handleMethodInvocation(methodName.getName(), type, context.getCsccContext());
            context.addToken(methodName.getDeclaringType().getName());
        } else {
            if (methodName.isStatic()) {
                context.addToken(methodName.getDeclaringType().getName());
            } else {
                expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
            }
            this.handleMethodInvocation(methodName.getName(), type, context.getCsccContext());
            context.addToken(methodName.getName());
        }
        for (ISimpleExpression parameter : expr.getParameters()) {
            parameter.accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    protected void handleMethodInvocation(String methodCall, String invocationType, CsccContext csccContext) {
    }

    public Void visit(ILambdaExpression expr, LineContext context) {
        for (IParameterName parameterName : expr.getName().getParameters()) {
            if (parameterName.getValueType() == null) continue;
            context.addToken(parameterName.getValueType().getName());
        }
        context.addToken("=>");
        return null;
    }

    public Void visit(IConstantValueExpression expr, LineContext context) {
        String value = expr.getValue();
        if (!StringUtility.isNullOrEmpty(value) && (value.equals("false") || value.equals("true"))) {
            context.addToken(value);
        }
        return null;
    }

    public Void visit(INullExpression expr, LineContext context) {
        context.addToken("null");
        return null;
    }

    public Void visit(IReferenceExpression expr, LineContext context) {
        expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IEventReference eventRef, LineContext context) {
        if (SstUtility.isSelfReferenceToken(eventRef.getReference().getIdentifier())) {
            context.addToken(eventRef.getReference().getIdentifier());
        }
        context.addToken(eventRef.getEventName().getName());
        return null;
    }

    public Void visit(IMethodReference methodRef, LineContext context) {
        if (SstUtility.isSelfReferenceToken(methodRef.getReference().getIdentifier())) {
            context.addToken(methodRef.getReference().getIdentifier());
        }
        String methodCall = methodRef.getMethodName().getName();
        String type = methodRef.getMethodName().getDeclaringType().getFullName();
        this.handleMethodInvocation(methodCall, type, context.getCsccContext());
        context.addToken(methodRef.getMethodName().getName());
        return null;
    }

    public Void visit(IFieldReference fieldRef, LineContext context) {
        if (SstUtility.isSelfReferenceToken(fieldRef.getReference().getIdentifier())) {
            context.addToken(fieldRef.getReference().getIdentifier());
        }
        return null;
    }

    public Void visit(IPropertyReference propertyRef, LineContext context) {
        if (SstUtility.isSelfReferenceToken(propertyRef.getReference().getIdentifier())) {
            context.addToken(propertyRef.getReference().getIdentifier());
        }
        return null;
    }

    public Void visit(IVariableReference varRef, LineContext context) {
        if (SstUtility.isSelfReferenceToken(varRef.getIdentifier())) {
            context.addToken(varRef.getIdentifier());
        }
        return null;
    }

    public Void visit(IIndexAccessReference indexAccessRef, LineContext context) {
        indexAccessRef.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(ICastExpression expr, LineContext context) {
        if (expr.getOperator() == CastOperator.SafeCast) {
            expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
            context.addToken("as");
            context.addToken(SstUtility.resolveTypeNameToken(expr.getTargetType()));
        } else {
            context.addToken(SstUtility.resolveTypeNameToken(expr.getTargetType()));
            expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(ITypeCheckExpression expr, LineContext context) {
        expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        context.addToken("instanceof");
        context.addToken(SstUtility.resolveTypeNameToken(expr.getType()));
        return null;
    }

    public Void visit(IIndexAccessExpression expr, LineContext context) {
        expr.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        for (int i = 0; i < expr.getIndices().size(); ++i) {
            ((ISimpleExpression)expr.getIndices().get(i)).accept((ISSTNodeVisitor)this, (Object)context);
        }
        return null;
    }

    public Void visit(IUnaryExpression expr, LineContext context) {
        switch (expr.getOperator()) {
            case Not: {
                context.addToken("!");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            case PreIncrement: {
                context.addToken("++");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            case PostIncrement: {
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                context.addToken("++");
                break;
            }
            case PreDecrement: {
                context.addToken("--");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            case PostDecrement: {
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                context.addToken("--");
                break;
            }
            case Plus: {
                context.addToken("+");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            case Minus: {
                context.addToken("-");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            case Complement: {
                context.addToken("~");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
                break;
            }
            default: {
                context.addToken("?");
                expr.getOperand().accept((ISSTNodeVisitor)this, (Object)context);
            }
        }
        return null;
    }

    public Void visit(IBinaryExpression expr, LineContext context) {
        expr.getLeftOperand().accept((ISSTNodeVisitor)this, (Object)context);
        switch (expr.getOperator()) {
            case And: {
                context.addToken("&&");
                break;
            }
            case BitwiseAnd: {
                context.addToken("&");
                break;
            }
            case BitwiseOr: {
                context.addToken("|");
                break;
            }
            case BitwiseXor: {
                context.addToken("^");
                break;
            }
            case Divide: {
                context.addToken("/");
                break;
            }
            case Equal: {
                context.addToken("==");
                break;
            }
            case GreaterThan: {
                context.addToken(">");
                break;
            }
            case GreaterThanOrEqual: {
                context.addToken(">=");
                break;
            }
            case LessThan: {
                context.addToken("<");
                break;
            }
            case LessThanOrEqual: {
                context.addToken("<=");
                break;
            }
            case Minus: {
                context.addToken("-");
                break;
            }
            case Modulo: {
                context.addToken("%");
                break;
            }
            case Multiply: {
                context.addToken("*");
                break;
            }
            case NotEqual: {
                context.addToken("!=");
                break;
            }
            case Or: {
                context.addToken("||");
                break;
            }
            case Plus: {
                context.addToken("+");
                break;
            }
            case ShiftLeft: {
                context.addToken("<<");
                break;
            }
            case ShiftRight: {
                context.addToken(">>");
                break;
            }
            default: {
                context.addToken("??");
            }
        }
        expr.getRightOperand().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }

    public Void visit(IEventSubscriptionStatement stmt, LineContext context) {
        stmt.getReference().accept((ISSTNodeVisitor)this, (Object)context);
        switch (stmt.getOperation()) {
            case Add: {
                context.addToken("+=");
                break;
            }
            case Remove: {
                context.addToken("-=");
                break;
            }
            default: {
                context.addToken("??");
            }
        }
        stmt.getExpression().accept((ISSTNodeVisitor)this, (Object)context);
        return null;
    }
}

