/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.mining;

import com.github.svstoll.csccrecommender.index.MethodInvocationIndex;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.github.svstoll.csccrecommender.mining.LineContextVisitor;
import com.github.svstoll.csccrecommender.recommender.CandidateDocumentComparator;
import com.github.svstoll.csccrecommender.recommender.RecommendationResult;
import com.github.svstoll.csccrecommender.utility.CollectionUtility;
import com.github.tomtung.jsimhash.SimHashBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.document.Document;

public class RecommendingLineContextVisitor
extends LineContextVisitor {
    private static final int MAX_RECOMMENDATIONS = 10;
    private static final int MAX_REFINED_CANDIDATES = 200;
    private final MethodInvocationIndex methodInvocationIndex;
    private final List<RecommendationResult> recommendationResults = new ArrayList<RecommendationResult>();

    public RecommendingLineContextVisitor(MethodInvocationIndex methodInvocationIndex) {
        this.methodInvocationIndex = methodInvocationIndex;
    }

    @Override
    protected void handleCompletionExpression(String invocationType, CsccContext csccContext) {
        long startTime = System.currentTimeMillis();
        List<String> overallContextTokens = csccContext.getOverallContextTokens();
        List<String> lineContextTokens = csccContext.getLineContextTokens();
        String overallContextConcatenated = CollectionUtility.concatenateStrings(overallContextTokens, " ");
        String lineContextConcatenated = CollectionUtility.concatenateStrings(lineContextTokens, " ");
        List<Document> documents = this.methodInvocationIndex.searchMethodInvocationDocuments(invocationType, overallContextTokens);
        SimHashBuilder simHashBuilder = new SimHashBuilder();
        simHashBuilder.addStringFeature((CharSequence)overallContextConcatenated);
        long overallContextSimHash = simHashBuilder.computeResult();
        simHashBuilder.reset();
        simHashBuilder.addStringFeature((CharSequence)lineContextConcatenated);
        long lineContextSimHash = simHashBuilder.computeResult();
        ArrayList<CandidateDocumentComparator> comparisons = new ArrayList<CandidateDocumentComparator>();
        for (Document document : documents) {
            CandidateDocumentComparator candidateDocumentComparator = new CandidateDocumentComparator(document, overallContextSimHash, lineContextSimHash);
            comparisons.add(candidateDocumentComparator);
        }
        List<String> recommendedMethods = this.rankRecommendations(comparisons, overallContextConcatenated, lineContextConcatenated);
        long endTime = System.currentTimeMillis();
        RecommendationResult recommendationResult = new RecommendationResult.RecommendationResultBuilder().withRecommendedMethods(recommendedMethods).withOccurredWithinExtensionMethod(csccContext.isCurrentlyWithinExtensionMethod()).withRecommendationTimeInMs(endTime - startTime).createRecommendationResult();
        this.recommendationResults.add(recommendationResult);
    }

    private List<String> rankRecommendations(List<CandidateDocumentComparator> comparisons, String overallContext, String lineContext) {
        ArrayList<String> recommendedMethods = new ArrayList<String>();
        comparisons.sort(Comparator.comparingLong(CandidateDocumentComparator::getHammingDistanceForComparison));
        int refinedToIndex = comparisons.size() > 200 ? 200 : comparisons.size();
        List<CandidateDocumentComparator> refinedCandidates = comparisons.subList(0, refinedToIndex);
        refinedCandidates.sort(Comparator.comparingDouble(comparison -> comparison.compareOverallContexts(overallContext)).thenComparingDouble(comparison -> comparison.compareLineContexts(lineContext)));
        int k = 0;
        HashSet<String> includedMethods = new HashSet<String>();
        for (CandidateDocumentComparator comparison2 : refinedCandidates) {
            if (k >= 10) break;
            String recommendation = comparison2.getCandidateDocument().get("methodName");
            if (includedMethods.contains(recommendation)) continue;
            recommendedMethods.add(recommendation);
            includedMethods.add(recommendation);
            ++k;
        }
        return recommendedMethods;
    }

    public List<RecommendationResult> getRecommendationResults() {
        return this.recommendationResults;
    }
}

