/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.recommender;

import com.github.tomtung.jsimhash.Util;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.commons.text.similarity.LongestCommonSubsequence;
import org.apache.lucene.document.Document;

public class CandidateDocumentComparator {
    private static final int LINE_CONTEXT_SWITCH_THRESHOLD = 25;
    private final Document candidateDocument;
    private Double overallContextLcsDistance = null;
    private Double lineContextLevenshteinDistance = null;
    private final long hammingDistanceForComparison;

    public CandidateDocumentComparator(Document candidateDocument, long overallContextSimHashForProposal, long lineContextSimHashForProposal) {
        this.candidateDocument = candidateDocument;
        long overallContextSimHash = (Long)candidateDocument.getField("overallContextSimHash").numericValue();
        long lineContextSimHash = (Long)candidateDocument.getField("lineContextSimHash").numericValue();
        long overallContextHammingDistance = Util.hammingDistance((long)overallContextSimHash, (long)overallContextSimHashForProposal);
        long lineContextHammingDistance = Util.hammingDistance((long)lineContextSimHash, (long)lineContextSimHashForProposal);
        this.hammingDistanceForComparison = lineContextHammingDistance > 25L ? lineContextHammingDistance : overallContextHammingDistance;
    }

    public double compareOverallContexts(String overallContextForProposal) {
        if (this.overallContextLcsDistance != null) {
            return this.overallContextLcsDistance;
        }
        this.overallContextLcsDistance = this.getNormalizedLcs(overallContextForProposal);
        return this.overallContextLcsDistance;
    }

    public double compareLineContexts(String lineContextForProposal) {
        if (this.lineContextLevenshteinDistance != null) {
            return this.lineContextLevenshteinDistance;
        }
        this.lineContextLevenshteinDistance = this.getNormalizedLevenshteinDistance(lineContextForProposal);
        return this.lineContextLevenshteinDistance;
    }

    public Document getCandidateDocument() {
        return this.candidateDocument;
    }

    public long getHammingDistanceForComparison() {
        return this.hammingDistanceForComparison;
    }

    private double getNormalizedLcs(String queryOverallContext) {
        LongestCommonSubsequence longestCommonSubsequence = new LongestCommonSubsequence();
        String candidateOverallContext = this.candidateDocument.get("overallContext");
        int maxLength = Math.max(candidateOverallContext.length(), queryOverallContext.length());
        double lcs = longestCommonSubsequence.apply((CharSequence)candidateOverallContext, (CharSequence)queryOverallContext).intValue();
        return lcs / (double)maxLength;
    }

    private double getNormalizedLevenshteinDistance(String queryLineContext) {
        LevenshteinDistance levenshteinDistance = LevenshteinDistance.getDefaultInstance();
        String candidateLineContext = this.candidateDocument.get("lineContext");
        int maxLength = Math.max(candidateLineContext.length(), queryLineContext.length());
        double lev = levenshteinDistance.apply((CharSequence)candidateLineContext, (CharSequence)queryLineContext).intValue();
        return 1.0 - lev / (double)maxLength;
    }
}

