/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.recommender;

import cc.kave.commons.model.events.completionevents.CompletionEvent;
import cc.kave.commons.model.events.completionevents.Context;
import cc.kave.commons.model.naming.codeelements.IMethodName;
import cc.kave.commons.model.ssts.visitor.ISSTNodeVisitor;
import com.github.svstoll.csccrecommender.evaluation.ContextEvaluationStatistics;
import com.github.svstoll.csccrecommender.index.MethodInvocationIndex;
import com.github.svstoll.csccrecommender.mining.ContextExtractor;
import com.github.svstoll.csccrecommender.mining.CsccContext;
import com.github.svstoll.csccrecommender.mining.CsccContextVisitor;
import com.github.svstoll.csccrecommender.mining.InvocationRecommendationLineContextVisitor;
import com.github.svstoll.csccrecommender.mining.RecommendingLineContextVisitor;
import com.github.svstoll.csccrecommender.recommender.RecommendationResult;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CsccRecommender {
    public static final Logger LOGGER = LoggerFactory.getLogger(CsccRecommender.class);
    private final MethodInvocationIndex methodInvocationIndex;
    private final ContextExtractor contextExtractor;

    @Inject
    protected CsccRecommender(MethodInvocationIndex methodInvocationIndex, ContextExtractor contextExtractor) {
        this.methodInvocationIndex = methodInvocationIndex;
        this.contextExtractor = contextExtractor;
    }

    public List<RecommendationResult> recommendMethods(CompletionEvent completionEvent) {
        if (completionEvent.getLastSelectedProposal() == null || !(completionEvent.getLastSelectedProposal().getName() instanceof IMethodName)) {
            throw new IllegalArgumentException("Provide a valid method completion event where the last selected proposal is a IMethodName.");
        }
        LOGGER.debug("Recommendation process started. Originally applied selection: {}", (Object)((IMethodName)completionEvent.getLastSelectedProposal().getName()).getFullName());
        CsccContextVisitor csccContextVisitor = new CsccContextVisitor();
        RecommendingLineContextVisitor recommendingLineContextVisitor = new RecommendingLineContextVisitor(this.methodInvocationIndex);
        CsccContext csccContext = new CsccContext(recommendingLineContextVisitor);
        completionEvent.getContext().getSST().accept((ISSTNodeVisitor)csccContextVisitor, (Object)csccContext);
        return recommendingLineContextVisitor.getRecommendationResults();
    }

    public void recommendForAllInvocationsInAvailableContexts(ContextEvaluationStatistics statistics) {
        this.contextExtractor.processAllContexts(contexts -> {
            LOGGER.info("Performing recommendations for all method invocations within {} contexts.", (Object)contexts.size());
            InvocationRecommendationLineContextVisitor invocationRecommendationLineContextVisitor = new InvocationRecommendationLineContextVisitor(this.methodInvocationIndex, statistics);
            for (Context context : contexts) {
                context.getSST().accept((ISSTNodeVisitor)new CsccContextVisitor(), (Object)new CsccContext(invocationRecommendationLineContextVisitor));
            }
        });
    }
}

