/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CollectionUtility {
    private CollectionUtility() {
    }

    public static <T> boolean isNullOrEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> removeDuplicates(List<T> list) {
        ArrayList<T> noneDuplicatesList = new ArrayList<T>();
        if (CollectionUtility.isNullOrEmpty(list)) {
            return noneDuplicatesList;
        }
        HashSet<T> seenItems = new HashSet<T>();
        for (T object : list) {
            if (seenItems.contains(object)) continue;
            seenItems.add(object);
            noneDuplicatesList.add(object);
        }
        return noneDuplicatesList;
    }

    public static String concatenateStrings(List<String> strings, String separator) {
        if (CollectionUtility.isNullOrEmpty(strings)) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            stringBuilder.append(string);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }
}

