/*
 * Decompiled with CFR 0.152.
 */
package com.github.svstoll.csccrecommender.utility;

public class StatisticsUtility {
    private StatisticsUtility() {
    }

    public static double calculateRecall(int requestedRecommendations, int recommendationsMade) {
        if (requestedRecommendations < 0 || recommendationsMade < 0) {
            throw new IllegalArgumentException("Requested recommendations and recommendations made must not be lower than 0.");
        }
        if (requestedRecommendations == 0) {
            return 1.0;
        }
        if (recommendationsMade > requestedRecommendations) {
            return 1.0;
        }
        return (double)recommendationsMade / (double)requestedRecommendations;
    }

    public static double calculatePrecision(int recommendationsMade, int relevantRecommendations) {
        if (recommendationsMade < 0 || relevantRecommendations < 0) {
            throw new IllegalArgumentException("Recommendation made and relevant recommendations must not be lower than 0.");
        }
        if (recommendationsMade == 0) {
            return 1.0;
        }
        if (relevantRecommendations > recommendationsMade) {
            return 1.0;
        }
        return (double)relevantRecommendations / (double)recommendationsMade;
    }

    public static double calculateFMeasure(double precision, double recall) {
        if (precision < 0.0 || recall < 0.0) {
            throw new IllegalArgumentException("Precision and recall must be greater or equal to 0.");
        }
        if (precision <= 0.0 && recall <= 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }
}

