/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger;

import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.PerfLoggerConstants;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DriverConfig {
    private static final Logger LOGGER = Logger.getLogger(DriverConfig.class);
    public static final DriverConfig INSTANCE;
    private @Nullable Integer serverPort;
    private final List<InetSocketAddress> clientAddresses = new ArrayList<InetSocketAddress>();
    private final Map<String, String> driverPrefixToClassName = new HashMap<String, String>();

    static DriverConfig parseConfig(InputStream configFileStream) {
        try {
            int i;
            DriverConfig config = new DriverConfig();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.parse(configFileStream);
            Element root = (Element)doc.getElementsByTagName("jdbc-perf-logger").item(0);
            NodeList localServersList = root.getElementsByTagName("local-server");
            for (i = 0; i < localServersList.getLength(); ++i) {
                String port = localServersList.item(i).getAttributes().getNamedItem("port").getTextContent();
                config.serverPort = Integer.parseInt(port);
            }
            NodeList targetClientList = root.getElementsByTagName("target-console");
            for (i = 0; i < targetClientList.getLength(); ++i) {
                NamedNodeMap attributes = targetClientList.item(i).getAttributes();
                @NonNull String host = attributes.getNamedItem("host").getTextContent();
                @NonNull String port = attributes.getNamedItem("port").getTextContent();
                config.clientAddresses.add(InetSocketAddress.createUnresolved(host, Integer.parseInt(port)));
            }
            NodeList jdbcDriversRootNodesList = doc.getElementsByTagName("jdbc-drivers");
            if (jdbcDriversRootNodesList.getLength() > 0) {
                NodeList jdbcDriversNodeList = ((Element)jdbcDriversRootNodesList.item(0)).getElementsByTagName("jdbc-driver");
                for (int i2 = 0; i2 < jdbcDriversNodeList.getLength(); ++i2) {
                    Element jdbcDriverNode = (Element)jdbcDriversNodeList.item(i2);
                    NodeList prefixNode = jdbcDriverNode.getElementsByTagName("prefix");
                    NodeList classNameNode = jdbcDriverNode.getElementsByTagName("driver-class-name");
                    if (prefixNode.getLength() <= 0 || classNameNode.getLength() <= 0) continue;
                    String prefix = prefixNode.item(0).getTextContent();
                    String className = classNameNode.item(0).getTextContent();
                    if (prefix == null || className == null) continue;
                    config.driverPrefixToClassName.put(prefix.trim(), className.trim());
                }
            }
            return config;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    static InputStream openConfigFile() {
        InputStream configFileStream;
        String location = System.getProperty("jdbcperflogger.config.location");
        if (location == null) {
            LOGGER.debug("No System property jdbcperflogger.config.location defined, looking for config at jdbcperflogger.xml");
            location = "jdbcperflogger.xml";
        }
        if ((configFileStream = DriverConfig.openConfigFile(location)) == null && (configFileStream = DriverConfig.openConfigFile(location = "jdbcperflogger-fallback.xml")) == null) {
            throw new RuntimeException("Unexpected: cannot find jdbcperflogger-fallback.xml");
        }
        LOGGER.info("Using config file " + location);
        return configFileStream;
    }

    static @Nullable InputStream openConfigFile(String location) {
        InputStream configFileStream = PerfLoggerConstants.class.getResourceAsStream("/" + location);
        if (configFileStream == null) {
            LOGGER.debug("Cannot find config file " + location + " in the classpath, trying on filesystem");
            try {
                configFileStream = new FileInputStream(location);
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("Cannot find config file " + location + " on the filesystem");
            }
        }
        return configFileStream;
    }

    public @Nullable Integer getServerPort() {
        return this.serverPort;
    }

    public List<InetSocketAddress> getClientAddresses() {
        return this.clientAddresses;
    }

    public @Nullable String getClassNameForJdbcUrl(String jdbcUrl) {
        for (Map.Entry<String, String> driver : this.driverPrefixToClassName.entrySet()) {
            if (!jdbcUrl.startsWith(driver.getKey())) continue;
            return driver.getValue();
        }
        return null;
    }

    static {
        InputStream configFileStream = DriverConfig.openConfigFile();
        INSTANCE = DriverConfig.parseConfig(configFileStream);
    }
}

