/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.driver.LoggingResultSetInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;

public class LoggingStatementInvocationHandler
implements InvocationHandler {
    protected static final String CLEAR_BATCH = "clearBatch";
    protected static final String ADD_BATCH = "addBatch";
    protected static final String EXECUTE_BATCH = "executeBatch";
    protected static final String EXECUTE_LARGE_BATCH = "executeLargeBatch";
    protected static final String EXECUTE_UPDATE = "executeUpdate";
    protected static final String EXECUTE_LARGE_UPDATE = "executeLargeUpdate";
    protected static final String EXECUTE = "execute";
    protected static final String EXECUTE_QUERY = "executeQuery";
    protected static final String GET_RESULT_SET = "getResultSet";
    protected UUID connectionId;
    protected final DatabaseType databaseType;
    protected final Statement wrappedStatement;
    private final List<String> batchedNonPreparedStmtExecutions = new ArrayList<String>();
    protected @Nullable UUID lastExecutionLogId;

    LoggingStatementInvocationHandler(UUID connectionId, Statement statement, DatabaseType databaseType) {
        this.connectionId = connectionId;
        this.wrappedStatement = statement;
        this.databaseType = databaseType;
    }

    @Override
    public @Nullable Object invoke(@Nullable Object _proxy, Method method, Object @Nullable [] args) throws Throwable {
        String methodName = method.getName();
        if (EXECUTE_QUERY.equals(methodName) && args != null) {
            return this.internalExecuteQuery(method, args);
        }
        if ((EXECUTE.equals(methodName) || EXECUTE_UPDATE.equals(methodName) || EXECUTE_LARGE_UPDATE.equals(methodName)) && args != null) {
            return this.internalExecute(method, args);
        }
        if (EXECUTE_BATCH.equals(methodName) || EXECUTE_LARGE_BATCH.equals(methodName)) {
            return this.internalExecuteBatch(method, args);
        }
        if (GET_RESULT_SET.equals(methodName)) {
            assert (this.lastExecutionLogId != null);
            return this.getAndWrapResultSet(method, args, this.lastExecutionLogId);
        }
        Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
        if (ADD_BATCH.equals(methodName) && args != null) {
            this.batchedNonPreparedStmtExecutions.add((String)args[0]);
        } else if (CLEAR_BATCH.equals(methodName)) {
            this.batchedNonPreparedStmtExecutions.clear();
        }
        return result;
    }

    protected final ResultSet internalExecuteQuery(Method method, Object[] args) throws Throwable {
        UUID logId = UUID.randomUUID();
        long start = System.nanoTime();
        Connection connection = this.wrappedStatement.getConnection();
        PerfLogger.logBeforeStatement(this.connectionId, logId, (String)args[0], StatementType.NON_PREPARED_QUERY_STMT, this.wrappedStatement.getQueryTimeout(), connection.getAutoCommit(), connection.getTransactionIsolation());
        Throwable exc = null;
        try {
            ResultSet resultSet = this.getAndWrapResultSet(method, args, logId);
            return resultSet;
        }
        catch (Throwable e) {
            exc = e;
            throw exc;
        }
        finally {
            long end = System.nanoTime();
            PerfLogger.logStatementExecuted(logId, end - start, null, exc);
            this.lastExecutionLogId = logId;
        }
    }

    private ResultSet getAndWrapResultSet(Method method, Object @Nullable [] args, UUID logId) throws Throwable {
        ResultSet resultSet = (ResultSet)Utils.invokeUnwrapExceptionReturnNonNull(this.wrappedStatement, method, args);
        return (ResultSet)Proxy.newProxyInstance(resultSet.getClass().getClassLoader(), Utils.extractAllInterfaces(resultSet.getClass()), (InvocationHandler)new LoggingResultSetInvocationHandler(resultSet, logId));
    }

    protected final @Nullable Object internalExecute(Method method, Object[] args) throws Throwable {
        Object object;
        UUID logId = UUID.randomUUID();
        Connection connection = this.wrappedStatement.getConnection();
        PerfLogger.logBeforeStatement(this.connectionId, logId, (String)args[0], StatementType.BASE_NON_PREPARED_STMT, this.wrappedStatement.getQueryTimeout(), connection.getAutoCommit(), connection.getTransactionIsolation());
        Throwable exc = null;
        Long updateCount = null;
        long start = System.nanoTime();
        try {
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if (result instanceof Number) {
                updateCount = ((Number)result).longValue();
            }
            object = result;
        }
        catch (Throwable e) {
            try {
                exc = e;
                throw exc;
            }
            catch (Throwable throwable) {
                long end = System.nanoTime();
                PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
                this.lastExecutionLogId = logId;
                throw throwable;
            }
        }
        long end = System.nanoTime();
        PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
        this.lastExecutionLogId = logId;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable Object internalExecuteBatch(Method method, Object @Nullable [] args) throws Throwable {
        UUID logId = UUID.randomUUID();
        Connection connection = this.wrappedStatement.getConnection();
        PerfLogger.logNonPreparedBatchedStatements(this.connectionId, logId, this.batchedNonPreparedStmtExecutions, this.databaseType, this.wrappedStatement.getQueryTimeout(), connection.getAutoCommit(), connection.getTransactionIsolation());
        try {
            Object object = this.internalExecuteBatchInternal(method, args, logId);
            return object;
        }
        finally {
            this.batchedNonPreparedStmtExecutions.clear();
            this.lastExecutionLogId = logId;
        }
    }

    protected @Nullable Object internalExecuteBatchInternal(Method method, Object @Nullable [] args, UUID logId) throws Throwable {
        Throwable exc = null;
        long updateCount = -1L;
        long start = System.nanoTime();
        try {
            long totalRows;
            Object[] nbRows;
            Object result = Utils.invokeUnwrapException(this.wrappedStatement, method, args);
            if (result instanceof int[]) {
                nbRows = (int[])result;
                totalRows = 0L;
                for (int i = 0; i < nbRows.length; ++i) {
                    totalRows += (long)nbRows[i];
                }
                updateCount = totalRows;
            } else if (result instanceof long[]) {
                nbRows = (long[])result;
                totalRows = 0L;
                for (int i = 0; i < nbRows.length; ++i) {
                    totalRows += nbRows[i];
                }
                updateCount = totalRows;
            }
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            exc = e;
            throw exc;
        }
        finally {
            long end = System.nanoTime();
            PerfLogger.logStatementExecuted(logId, end - start, updateCount, exc);
            this.lastExecutionLogId = logId;
        }
    }
}

