/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DriverConfig;
import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.driver.LoggingConnectionInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jdt.annotation.Nullable;

public class WrappingDriver
implements Driver {
    public static final String URL_PREFIX = "jdbcperflogger:";
    private static final Logger LOGGER = Logger.getLogger(WrappingDriver.class);
    public static final WrappingDriver INSTANCE = new WrappingDriver();
    private static final Map<String, Driver> underlyingDrivers = new ConcurrentHashMap<String, Driver>();
    private static boolean registered;
    private static final AtomicInteger connectionCounter;

    public static synchronized Driver load() {
        if (!registered) {
            try {
                LOGGER.debug("classloader is " + INSTANCE.getClass().getClassLoader());
                DriverManager.registerDriver(INSTANCE, WrappingDriverAction.ACTION_INSTANCE);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            PerfLoggerRemoting.start();
            registered = true;
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        if (registered) {
            try {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                PerfLoggerRemoting.stop();
            }
        }
    }

    @Override
    public @Nullable Connection connect(String url, final @Nullable Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        LOGGER.debug("connect url=[" + url + "]");
        final String unWrappedUrl = this.extractUrlForWrappedDriver(url);
        Driver underlyingDriver = null;
        String underlyingDriverClassName = DriverConfig.INSTANCE.getClassNameForJdbcUrl(unWrappedUrl);
        if (underlyingDriverClassName != null) {
            underlyingDriver = underlyingDrivers.get(underlyingDriverClassName);
        }
        if (underlyingDriver == null && underlyingDriverClassName != null) {
            try {
                Class<?> underlyingDriverClass = Class.forName(underlyingDriverClassName);
                underlyingDriver = (Driver)underlyingDriverClass.newInstance();
                underlyingDrivers.put(underlyingDriverClassName, underlyingDriver);
            }
            catch (ClassNotFoundException e) {
                String msg = MessageFormat.format("Cannot find driver class {0} for JDBC url {1}", underlyingDriverClassName, unWrappedUrl);
                LOGGER.warn(msg, e);
            }
            catch (InstantiationException e) {
                throw new SQLException(e);
            }
            catch (IllegalAccessException e) {
                throw new SQLException(e);
            }
        }
        if (underlyingDriver == null) {
            try {
                underlyingDriver = DriverManager.getDriver(unWrappedUrl);
            }
            catch (SQLException e) {
                throw new SQLException("Cannot get underlying JDBC driver for [" + unWrappedUrl + "]. The underlying driver must be either registered with the DriverManager or listed in a jdbcperflogger.xml file, see documentation.", e);
            }
        }
        final Driver finalUnderlyingDriver = underlyingDriver;
        Connection connection = this.wrapConnection(unWrappedUrl, info, new Callable<Connection>(){

            @Override
            public @Nullable Connection call() throws Exception {
                return finalUnderlyingDriver.connect(unWrappedUrl, info);
            }
        });
        return connection;
    }

    public @Nullable Connection wrapConnection(String url, @Nullable Properties info, Callable<@Nullable Connection> underlyingConnectionCreator) throws SQLException {
        Connection connection;
        long startNanos = System.nanoTime();
        try {
            connection = underlyingConnectionCreator.call();
        }
        catch (Exception e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
        if (connection == null) {
            return null;
        }
        if (Proxy.isProxyClass(connection.getClass()) && Proxy.getInvocationHandler(connection).getClass() == LoggingConnectionInvocationHandler.class) {
            return connection;
        }
        long connectionCreationDuration = System.nanoTime() - startNanos;
        Properties cleanedConnectionProperties = new Properties();
        if (info != null) {
            for (String str : info.stringPropertyNames()) {
                if (str.toLowerCase().contains("password")) continue;
                cleanedConnectionProperties.setProperty(str, info.getProperty(str));
            }
        }
        LoggingConnectionInvocationHandler connectionInvocationHandler = new LoggingConnectionInvocationHandler(connectionCounter.incrementAndGet(), connection, url, cleanedConnectionProperties);
        connection = (Connection)Proxy.newProxyInstance(connection.getClass().getClassLoader(), Utils.extractAllInterfaces(connection.getClass()), (InvocationHandler)connectionInvocationHandler);
        PerfLoggerRemoting.connectionCreated(connectionInvocationHandler, connectionCreationDuration);
        return connection;
    }

    @Override
    public boolean acceptsURL(@Nullable String url) throws SQLException {
        return url != null && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(@Nullable String url, @Nullable Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private String extractUrlForWrappedDriver(String url) {
        return url.substring(URL_PREFIX.length());
    }

    static {
        WrappingDriver.load();
        connectionCounter = new AtomicInteger();
    }

    private static class WrappingDriverAction
    implements DriverAction {
        static WrappingDriverAction ACTION_INSTANCE = new WrappingDriverAction();

        private WrappingDriverAction() {
        }

        @Override
        public void deregister() {
            WrappingDriver.unload();
        }
    }
}

