/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.TxCompletionType;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import ch.sla.jdbcperflogger.model.BatchedNonPreparedStatementsLog;
import ch.sla.jdbcperflogger.model.BatchedPreparedStatementsLog;
import ch.sla.jdbcperflogger.model.PreparedStatementValuesHolder;
import ch.sla.jdbcperflogger.model.ResultSetLog;
import ch.sla.jdbcperflogger.model.SqlTypedValue;
import ch.sla.jdbcperflogger.model.StatementExecutedLog;
import ch.sla.jdbcperflogger.model.StatementLog;
import ch.sla.jdbcperflogger.model.TxCompleteLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class PerfLogger {
    private static final Logger LOGGER_ORIGINAL_SQL = Logger.getLogger(PerfLogger.class.getName() + ".originalSql");
    private static final Logger LOGGER_FILLED_SQL = Logger.getLogger(PerfLogger.class.getName() + ".filledSql");
    private static final Logger LOGGER_EXECUTED = Logger.getLogger(PerfLogger.class.getName() + ".executed");
    private static final Logger LOGGER_CLOSED_RESULTSET = Logger.getLogger(PerfLogger.class.getName() + ".closedResultSet");
    private static final Logger LOGGER_BATCHED_STATEMENTS_DETAIL = Logger.getLogger(PerfLogger.class.getName() + ".batchedStatementDetail");
    private static final Pattern PSTMT_PARAMETERS_PATTERN = Pattern.compile("\\?");
    private static Map<Integer, String> typesMap = new HashMap<Integer, String>();

    public static void logBeforeStatement(UUID connectionId, UUID logId, String sql, StatementType statementType, int timeout, boolean autoCommit, int transactionIsolation) {
        if (LOGGER_ORIGINAL_SQL.isDebugEnabled()) {
            LOGGER_ORIGINAL_SQL.debug("Before execution of non-prepared stmt " + logId + ": " + sql);
        }
        long now = System.currentTimeMillis();
        PerfLoggerRemoting.postLog(new StatementLog(connectionId, logId, now, statementType, sql, Thread.currentThread().getName(), timeout, autoCommit, transactionIsolation));
    }

    public static void logBeforePreparedStatement(UUID connectionId, UUID logId, String rawSql, PreparedStatementValuesHolder pstmtValues, StatementType statementType, DatabaseType databaseType, int timeout, boolean autoCommit, int transactionIsolation) {
        if (LOGGER_ORIGINAL_SQL.isDebugEnabled()) {
            LOGGER_ORIGINAL_SQL.debug("Before execution of prepared stmt " + logId + ": " + rawSql);
        }
        String filledSql = PerfLogger.fillParameters(rawSql, pstmtValues, databaseType);
        if (LOGGER_FILLED_SQL.isDebugEnabled()) {
            LOGGER_FILLED_SQL.debug("Before execution of prepared stmt " + logId + ": " + filledSql);
        }
        long now = System.currentTimeMillis();
        PerfLoggerRemoting.postLog(new StatementLog(connectionId, logId, now, statementType, rawSql, filledSql, Thread.currentThread().getName(), timeout, autoCommit, transactionIsolation));
    }

    public static void logNonPreparedBatchedStatements(UUID connectionId, UUID logId, List<String> batchedExecutions, DatabaseType databaseType, int timeout, boolean autoCommit, int transactionIsolation) {
        long now = System.currentTimeMillis();
        if (LOGGER_ORIGINAL_SQL.isDebugEnabled()) {
            LOGGER_ORIGINAL_SQL.debug("Before execution of " + batchedExecutions.size() + " batched non-prepared statements");
        }
        for (int i = 0; i < batchedExecutions.size(); ++i) {
            String sql = batchedExecutions.get(i);
            if (!LOGGER_BATCHED_STATEMENTS_DETAIL.isDebugEnabled()) continue;
            LOGGER_BATCHED_STATEMENTS_DETAIL.debug("#" + i + ": " + sql);
        }
        PerfLoggerRemoting.postLog(new BatchedNonPreparedStatementsLog(connectionId, logId, now, batchedExecutions, Thread.currentThread().getName(), timeout, autoCommit, transactionIsolation));
    }

    public static void logPreparedBatchedStatements(UUID connectionId, UUID logId, String rawSql, List<Object> batchedExecutions, DatabaseType databaseType, int timeout, boolean autoCommit, int transactionIsolation) {
        long now = System.currentTimeMillis();
        if (LOGGER_ORIGINAL_SQL.isDebugEnabled()) {
            LOGGER_ORIGINAL_SQL.debug("Before execution of " + batchedExecutions.size() + " batched prepared statements with raw sql " + rawSql);
        }
        ArrayList<String> filledSqlList = new ArrayList<String>(batchedExecutions.size());
        for (int i = 0; i < batchedExecutions.size(); ++i) {
            Object exec = batchedExecutions.get(i);
            String filledSql = exec instanceof PreparedStatementValuesHolder ? PerfLogger.fillParameters(rawSql, (PreparedStatementValuesHolder)exec, databaseType) : exec.toString();
            filledSqlList.add(filledSql);
            if (!LOGGER_BATCHED_STATEMENTS_DETAIL.isDebugEnabled()) continue;
            LOGGER_BATCHED_STATEMENTS_DETAIL.debug("#" + i + ": " + filledSql);
        }
        PerfLoggerRemoting.postLog(new BatchedPreparedStatementsLog(connectionId, logId, now, rawSql, filledSqlList, Thread.currentThread().getName(), timeout, autoCommit, transactionIsolation));
    }

    public static void logStatementExecuted(UUID logId, long durationNanos, @Nullable Long updateCount, @Nullable Throwable sqlException) {
        if (LOGGER_EXECUTED.isDebugEnabled()) {
            LOGGER_EXECUTED.debug(TimeUnit.NANOSECONDS.toMillis(durationNanos) + "ms to execute  stmt #" + logId, sqlException);
        }
        String excString = null;
        if (sqlException != null) {
            excString = PerfLogger.dumpException(sqlException);
        }
        PerfLoggerRemoting.postLog(new StatementExecutedLog(logId, durationNanos, updateCount, excString));
    }

    private static String dumpException(Throwable th) {
        StringWriter stringWriter = new StringWriter(500);
        th.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void logClosedResultSet(UUID logId, long resultSetIterationTimeNanos, long fetchDurationNanos, int nbRowsIterated) {
        if (LOGGER_CLOSED_RESULTSET.isDebugEnabled()) {
            LOGGER_CLOSED_RESULTSET.debug(TimeUnit.NANOSECONDS.toMillis(resultSetIterationTimeNanos) + "ms to use and close ResultSet, " + TimeUnit.NANOSECONDS.toMillis(fetchDurationNanos) + "ms in calls to rset.next(), iterating " + nbRowsIterated + " rows for statement #" + logId);
        }
        PerfLoggerRemoting.postLog(new ResultSetLog(logId, resultSetIterationTimeNanos, fetchDurationNanos, nbRowsIterated));
    }

    public static void logTransactionComplete(UUID connectionUuid, long startTimeStamp, TxCompletionType txCompletionType, long durationNanos, @Nullable String savePointDescription) {
        TxCompleteLog log = new TxCompleteLog(connectionUuid, startTimeStamp, txCompletionType, durationNanos, Thread.currentThread().getName(), savePointDescription);
        PerfLoggerRemoting.postLog(log);
    }

    static String fillParameters(String sql, PreparedStatementValuesHolder pstmtValues, DatabaseType databaseType) {
        Matcher matcher = PSTMT_PARAMETERS_PATTERN.matcher(sql);
        int i = 0;
        StringBuffer strBuf = new StringBuffer((int)((double)sql.length() * 1.5));
        while (matcher.find()) {
            SqlTypedValue sqlTypedValue;
            if ((sqlTypedValue = (SqlTypedValue)pstmtValues.get(++i)) == null) continue;
            String valueAsString = PerfLogger.getValueAsString(sqlTypedValue, databaseType);
            matcher = matcher.appendReplacement(strBuf, Matcher.quoteReplacement(valueAsString));
        }
        matcher.appendTail(strBuf);
        return strBuf.toString();
    }

    static String getValueAsString(SqlTypedValue sqlTypedValue, DatabaseType databaseType) {
        int sqlType;
        String setter;
        Object value = sqlTypedValue.value;
        String sqlTypeStr = setter = sqlTypedValue.setter;
        int n = sqlType = sqlTypedValue.sqlType != null ? sqlTypedValue.sqlType : 0;
        if (sqlTypeStr == null && (sqlTypeStr = typesMap.get(sqlType)) == null) {
            sqlTypeStr = "TYPE=" + sqlType;
        }
        String additionalComment = null;
        StringBuilder strBuilder = new StringBuilder(20);
        if (value == null) {
            strBuilder.append("NULL");
        } else if (sqlType == 1 || sqlType == 12 || sqlType == -15 || sqlType == -9 || "setString".equals(setter) || "setNString".equals(setter)) {
            strBuilder.append("'" + value.toString().replace("'", "''") + "'");
        } else if (sqlType == 91 || "setDate".equals(setter) || value instanceof Date) {
            Date sqlDate = value instanceof Date ? (Date)value : new Date(((java.util.Date)value).getTime());
            Date pureSqlDate = Date.valueOf(sqlDate.toString());
            if (sqlDate.getTime() == pureSqlDate.getTime()) {
                strBuilder.append("date'" + sqlDate.toString() + "'");
            } else {
                strBuilder.append("cast(timestamp'" + new Timestamp(sqlDate.getTime()) + "' as DATE)");
                additionalComment = " (non pure)";
            }
        } else if (sqlType == 93 || "setTimestamp".equals(setter) || value instanceof Timestamp) {
            Timestamp tstamp = value instanceof Timestamp ? (Timestamp)value : new Timestamp(((java.util.Date)value).getTime());
            strBuilder.append("timestamp'" + tstamp.toString() + "'");
        } else if (sqlType == 92 || "setTime".equals(setter) || value instanceof Time) {
            Time sqlTime = value instanceof Time ? (Time)value : new Time(((java.util.Date)value).getTime());
            strBuilder.append("time'" + sqlTime.toString() + "'");
        } else if (value instanceof Number) {
            strBuilder.append(value);
        } else if (value instanceof Boolean) {
            if (databaseType == DatabaseType.ORACLE) {
                strBuilder.append((Boolean)value != false ? 1 : 0);
            } else {
                strBuilder.append(value);
            }
        } else {
            strBuilder.append("?");
        }
        strBuilder.append(" /*");
        strBuilder.append(sqlTypeStr);
        if (additionalComment != null) {
            strBuilder.append(additionalComment);
        }
        strBuilder.append("*/");
        return strBuilder.toString();
    }

    static {
        try {
            for (Field field : Types.class.getFields()) {
                if (field.getType() != Integer.TYPE) continue;
                typesMap.put(field.getInt(null), field.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

