/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.Logger;
import ch.sla.jdbcperflogger.logger.PerfLoggerRemoting;
import ch.sla.jdbcperflogger.logger.SocketLogSender;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;

class PerfLoggerClientThread
extends Thread
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(PerfLoggerClientThread.class);
    private static final int CONNECT_TIMEOUT_MS = 30000;
    volatile boolean done;
    private final InetSocketAddress socketAddress;
    private Socket socket;

    static PerfLoggerClientThread spawn(final InetSocketAddress socketAddress) {
        return AccessController.doPrivileged(new PrivilegedAction<PerfLoggerClientThread>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerfLoggerClientThread run() {
                ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(null);
                    PerfLoggerClientThread thread = new PerfLoggerClientThread(socketAddress);
                    thread.start();
                    PerfLoggerClientThread perfLoggerClientThread = thread;
                    return perfLoggerClientThread;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
        });
    }

    private PerfLoggerClientThread(InetSocketAddress socketAddress) {
        this.setDaemon(true);
        this.setName("PerfLoggerClient " + socketAddress);
        this.socketAddress = socketAddress;
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                InetSocketAddress resolvedAddress = new InetSocketAddress(this.socketAddress.getHostName(), this.socketAddress.getPort());
                this.socket = new Socket();
                this.socket.connect(resolvedAddress, 30000);
            }
            catch (IOException e) {
                LOGGER.debug("Unable to connect to " + this.socketAddress + ", will try again later", e);
                this.quietSleep(30);
                continue;
            }
            LOGGER.debug("Connected to " + this.socketAddress);
            try {
                SocketLogSender sender = new SocketLogSender(this.socket);
                PerfLoggerRemoting.senders.add(sender);
                sender.run();
            }
            catch (IOException e) {
                LOGGER.info("Error in connection with " + this.socketAddress + ", will try again later", e);
            }
        }
        LOGGER.debug("Client for " + this.socketAddress + "closed");
    }

    @Override
    public void close() {
        this.done = true;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOGGER.info("Error closing socket at port" + this.socket.getLocalPort());
        }
    }

    private void quietSleep(int seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

