/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.DriverConfig;
import ch.sla.jdbcperflogger.driver.LoggingConnectionInvocationHandler;
import ch.sla.jdbcperflogger.logger.LogSender;
import ch.sla.jdbcperflogger.logger.PerfLoggerClientThread;
import ch.sla.jdbcperflogger.logger.PerfLoggerServerThread;
import ch.sla.jdbcperflogger.model.ConnectionInfo;
import ch.sla.jdbcperflogger.model.LogMessage;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class PerfLoggerRemoting {
    static final Set<LogSender> senders = new CopyOnWriteArraySet<LogSender>();
    static final Map<LoggingConnectionInvocationHandler, ConnectionInfo> connectionToInfo = new WeakHashMap<LoggingConnectionInvocationHandler, ConnectionInfo>();
    static final List<Closeable> remotingThreads = new ArrayList<Closeable>();

    public static synchronized void start() {
        Integer serverPort = DriverConfig.INSTANCE.getServerPort();
        if (serverPort != null) {
            remotingThreads.add(PerfLoggerServerThread.spawn(serverPort));
        }
        for (InetSocketAddress clientAddress : DriverConfig.INSTANCE.getClientAddresses()) {
            remotingThreads.add(PerfLoggerClientThread.spawn(clientAddress));
        }
    }

    public static synchronized void stop() {
        for (Closeable thread : remotingThreads) {
            try {
                thread.close();
            }
            catch (IOException iOException) {}
        }
        remotingThreads.clear();
    }

    private PerfLoggerRemoting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void connectionCreated(LoggingConnectionInvocationHandler connectionHandler, long connectionCreationDuration) {
        ConnectionInfo info = new ConnectionInfo(connectionHandler.getConnectionUuid(), connectionHandler.getConnectionId(), connectionHandler.getUrl(), new Date(), connectionCreationDuration, connectionHandler.getConnectionProperties());
        Map<LoggingConnectionInvocationHandler, ConnectionInfo> map = connectionToInfo;
        synchronized (map) {
            connectionToInfo.put(connectionHandler, info);
            PerfLoggerRemoting.postLog(info);
        }
    }

    static void postLog(LogMessage log) {
        for (LogSender sender : senders) {
            sender.postLog(log);
        }
    }

    public static void addSender(LogSender sender) {
        senders.add(sender);
    }

    public static void removeSender(LogSender sender) {
        senders.remove(sender);
    }
}

