/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.logger;

import ch.sla.jdbcperflogger.logger.LogSender;
import ch.sla.jdbcperflogger.model.LogMessage;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jdt.annotation.Nullable;

public class RecordingLogSender
implements LogSender {
    private static final int DEFAULT_RETAINED_LOG_MESSAGES_COUNT = 50;
    private final LinkedBlockingDeque<LogMessage> queue;

    public RecordingLogSender() {
        this(50);
    }

    public RecordingLogSender(int retainedLogMessagesCount) {
        this.queue = new LinkedBlockingDeque(retainedLogMessagesCount);
    }

    @Override
    public void postLog(LogMessage log) {
        while (!this.queue.offerFirst(log)) {
            this.queue.pollLast();
        }
    }

    public LogMessage[] getRecordedLogMessages() {
        return this.queue.toArray(new LogMessage[0]);
    }

    public void clearLogs() {
        this.queue.clear();
    }

    public @Nullable LogMessage lastLogMessage(int index) {
        LogMessage[] logs = this.getRecordedLogMessages();
        if (logs.length <= index) {
            return null;
        }
        return logs[index];
    }
}

