/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.model;

import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.model.AbstractBeforeStatementExecutionLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class BatchedNonPreparedStatementsLog
extends AbstractBeforeStatementExecutionLog {
    private static final long serialVersionUID = 1L;
    private final List<String> sqlList;

    public BatchedNonPreparedStatementsLog(UUID connectionId, UUID logId, long timestamp, List<String> sqlList, String threadName, int timeout, boolean autoCommit, int transactionIsolation) {
        super(connectionId, logId, timestamp, StatementType.NON_PREPARED_BATCH_EXECUTION, threadName, timeout, autoCommit, transactionIsolation);
        this.sqlList = Collections.unmodifiableList(new ArrayList<String>(sqlList));
    }

    public List<String> getSqlList() {
        return this.sqlList;
    }

    public String toString() {
        return "BatchedNonPreparedStatementsLog[logId=" + this.getLogId() + ", timestamp=" + this.getTimestamp() + ", statementType=" + (Object)((Object)this.getStatementType()) + ", threadName=" + this.getThreadName() + ", timeout=" + this.getTimeout() + ", autocommit=" + this.isAutoCommit() + ", getTransactionIsolation=" + this.getTransactionIsolation() + ", sqlList=" + this.sqlList + "]";
    }
}

