/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.model;

import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.model.AbstractBeforeStatementExecutionLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class BatchedPreparedStatementsLog
extends AbstractBeforeStatementExecutionLog {
    private static final long serialVersionUID = 1L;
    private final String rawSql;
    private final List<String> sqlList;

    public BatchedPreparedStatementsLog(UUID connectionId, UUID logId, long timestamp, String rawSql, List<String> sqlList, String threadName, int timeout, boolean autoCommit, int transactionIsolation) {
        super(connectionId, logId, timestamp, StatementType.PREPARED_BATCH_EXECUTION, threadName, timeout, autoCommit, transactionIsolation);
        this.rawSql = rawSql;
        this.sqlList = Collections.unmodifiableList(new ArrayList<String>(sqlList));
    }

    public String getRawSql() {
        return this.rawSql;
    }

    public List<String> getSqlList() {
        return this.sqlList;
    }

    public String toString() {
        return "BatchedPreparedStatementsLog[logId=" + this.getLogId() + ", rawSql=" + this.rawSql + ", timestamp=" + this.getTimestamp() + ", statementType=" + (Object)((Object)this.getStatementType()) + ", threadName=" + this.getThreadName() + ", timeout=" + this.getTimeout() + ", autocommit=" + this.isAutoCommit() + ", transactionIsolation=" + this.getTransactionIsolation() + "]";
    }
}

