/*
 * Decompiled with CFR 0.152.
 */
package com.github.sylvainlaurent.maven.yamljsonvalidator;

import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationResult;
import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationService;
import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter
    private ValidationSet[] validationSets;
    @Parameter(defaultValue="true")
    private boolean verbose;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(name="allowEmptyFiles", defaultValue="false")
    private boolean allowEmptyFiles;
    @Parameter(defaultValue="true")
    private boolean detectDuplicateKeys;
    @Parameter(defaultValue="false")
    private boolean allowJsonComments;
    @Parameter(defaultValue="false")
    private boolean allowTrailingComma;

    public void execute() throws MojoExecutionException {
        boolean encounteredError = false;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping validation");
            return;
        }
        for (ValidationSet set : this.validationSets) {
            File[] files;
            InputStream inputStream = this.openJsonSchema(set.getJsonSchema());
            ValidationService validationService = new ValidationService(inputStream, this.allowEmptyFiles, this.detectDuplicateKeys, this.allowJsonComments, this.allowTrailingComma);
            for (File file : files = set.getFiles(this.basedir)) {
                ValidationResult result;
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Validating file " + file));
                }
                if ((result = validationService.validate(file)).hasError()) {
                    encounteredError = true;
                }
                for (String msg : result.getMessages()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
        }
        if (encounteredError) {
            throw new MojoExecutionException("Some files are not valid, see previous logs");
        }
    }

    InputStream openJsonSchema(String jsonSchemaFile) throws MojoExecutionException {
        if (jsonSchemaFile != null && jsonSchemaFile.length() > 0) {
            File file = new File(jsonSchemaFile);
            if (file.isFile()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new MojoExecutionException("Could not load schema file [" + jsonSchemaFile + "]", (Exception)e);
                }
            }
            try {
                InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(jsonSchemaFile);
                if (inputStream != null) {
                    return inputStream;
                }
                throw new MojoExecutionException("Could not load schema neither from filesystem nor classpath [" + jsonSchemaFile + "]");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not load schema file from classpath [" + jsonSchemaFile + "]", e);
            }
        }
        return null;
    }
}

