/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

import com.github.t1.bulmajava.basic.Attribute;
import com.github.t1.bulmajava.basic.Attributes;
import com.github.t1.bulmajava.basic.Basic;
import com.github.t1.bulmajava.basic.Classes;
import com.github.t1.bulmajava.basic.Modifier;
import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Renderer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class AbstractElement<SELF extends AbstractElement<?>>
implements Renderable {
    private boolean close;
    private boolean rendersOnSeparateLines;
    @NonNull
    private String name;
    private Attributes attributes;
    private Renderable content;
    @NonNull
    private Function<Renderable, Renderable> mapFunction;

    protected AbstractElement(@NonNull String name, String ... classes) {
        this(name, Attributes.of(Classes.of(classes)));
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    protected AbstractElement(@NonNull String name, Attributes attributes) {
        this(name, attributes, null);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    protected AbstractElement(@NonNull String name, Attributes attributes, Renderable content) {
        this(name, attributes, content, Function.identity());
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    protected AbstractElement(@NonNull String name, Attributes attributes, Renderable content, Function<Renderable, Renderable> mapFunction) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.close = true;
        this.rendersOnSeparateLines = true;
        this.name = name;
        this.attributes = attributes;
        this.content = content;
        this.mapFunction = mapFunction;
    }

    public String toString() {
        return this.render();
    }

    public boolean hasName(String name) {
        return this.name.equals(name);
    }

    public boolean hasAttribute(String name, String value) {
        return this.attributes.hasAttribute(name, value);
    }

    public boolean has(Modifier modifier) {
        return this.hasClass(modifier.className());
    }

    @Override
    public boolean hasClass(String name) {
        return Optional.ofNullable(this.getClasses()).map((? super T classes) -> classes.hasClass(name)).orElse(false);
    }

    public Classes getClasses() {
        return this.attributes == null ? null : (Classes)this.attributes.find(Classes.class).orElse(null);
    }

    public Renderable content() {
        return this.content;
    }

    public Stream<Renderable> contentStream() {
        return this.content == null ? Stream.of(new Renderable[0]) : (this.contentIsA(Renderable.ConcatenatedRenderable.class) ? this.contentAs(Renderable.ConcatenatedRenderable.class).renderables().stream() : Stream.of(this.content));
    }

    public <T extends Renderable> T contentAs(Class<T> type) {
        return (T)((Renderable)type.cast(this.content));
    }

    public <T extends Renderable> boolean contentIsA(Class<T> type) {
        return type.isAssignableFrom(this.content.getClass());
    }

    protected SELF self() {
        return (SELF)this;
    }

    public SELF close(boolean close) {
        this.close = close;
        return this.self();
    }

    public SELF rendersOnSeparateLines(boolean rendersOnSeparateLines) {
        this.rendersOnSeparateLines = rendersOnSeparateLines;
        return this.self();
    }

    public SELF id(String id) {
        return this.attr("id", id);
    }

    public SELF classes(String ... classes) {
        return this.classes(Classes.of(classes));
    }

    public SELF classes(Stream<String> classes) {
        return this.classes(Classes.of(classes));
    }

    private SELF classes(Classes classes) {
        return classes == null || classes.empty() ? this.self() : this.attr(classes);
    }

    public SELF notClasses(String ... classes) {
        return this.notClasses(Classes.of(classes));
    }

    public SELF notClasses(Classes removing) {
        if (this.attributes == null) {
            return this.self();
        }
        this.attributes.find(Classes.class).ifPresent(existing -> {
            existing.minus(removing);
            if (existing.empty()) {
                this.attributes.remove((Attribute)existing);
            }
        });
        return this.self();
    }

    public SELF is(Modifier ... modifiers) {
        return this.is(Stream.of(modifiers));
    }

    public SELF is(Stream<Modifier> modifiers) {
        return this.classes((String[])modifiers.map(Modifier::className).toArray(String[]::new));
    }

    public SELF is(int size) {
        return this.classes("is-" + size);
    }

    public SELF isPulledLeft() {
        return this.classes("is-pulled-left");
    }

    public SELF isPulledRight() {
        return this.classes("is-pulled-right");
    }

    public SELF style(String style) {
        return this.attr("style", style);
    }

    public SELF ariaHidden(boolean hidden) {
        return this.ariaHidden(Boolean.toString(hidden));
    }

    public SELF ariaHidden(String hidden) {
        return this.attr("aria-hidden", hidden);
    }

    public SELF ariaLabel(String label) {
        return this.attr("aria-label", label);
    }

    public SELF autofocus() {
        return this.attr("autofocus");
    }

    public SELF attr(String name) {
        return this.attr(Attribute.of(name));
    }

    public SELF attr(String name, String value) {
        return this.attr(Attribute.of(name, value));
    }

    public SELF attr(Attribute attribute) {
        if (this.attributes == null) {
            Attributes.of(attribute);
        } else {
            this.attributes.add(attribute);
        }
        return this.self();
    }

    public SELF attrs(Attribute ... attributes) {
        return this.attrs(Stream.of(attributes));
    }

    public SELF attrs(Stream<Attribute> attributes) {
        attributes.forEach(this::attr);
        return this.self();
    }

    public SELF hasText(Modifier modifier) {
        return this.classes("has-text-" + modifier.key());
    }

    public SELF hasBackground(Modifier modifier) {
        return this.classes("has-background-" + modifier.key());
    }

    public SELF dataValue(String value) {
        return this.attr("data-value", value);
    }

    public SELF disabled() {
        return this.attr("disabled");
    }

    public SELF tabindex(int tabindex) {
        return this.attr("tabindex", Integer.toString(tabindex));
    }

    public SELF onkeyup(String key, String action) {
        return this.onkey("up", key, action);
    }

    public SELF onkeydown(String key, String action) {
        return this.onkey("down", key, action);
    }

    public SELF onkey(String eventType, String key, String action) {
        return this.on("key" + eventType, "if (event.key === '" + key + "') { " + action + " }");
    }

    public SELF on(String event, String action) {
        return this.attr(Attribute.StringAttribute.unsafeStringAttribute("on" + event, action));
    }

    public SELF with(Consumer<SELF> consumer) {
        consumer.accept(this.self());
        return this.self();
    }

    public SELF map(Function<Renderable, Renderable> function) {
        this.mapFunction = function;
        return this.self();
    }

    public SELF firstContent(Renderable content) {
        Renderable mapped = this.mapFunction.apply(content);
        this.content = this.content == null ? mapped : Renderable.ConcatenatedRenderable.concat(mapped, this.content);
        return this.self();
    }

    public SELF content(String content) {
        return this.content(Renderable.RenderableString.string(content));
    }

    public SELF content(Renderable ... content) {
        return this.content(Arrays.stream(content));
    }

    public SELF content(Stream<? extends Renderable> content) {
        content.filter(Objects::nonNull).forEach(this::content);
        return this.self();
    }

    public SELF content(Renderable content) {
        Renderable mapped = this.mapFunction.apply(content);
        this.content = this.content == null ? mapped : Renderable.ConcatenatedRenderable.concat(this.content, mapped);
        return this.self();
    }

    public final SELF content(String className, Function<AbstractElement<?>, AbstractElement<?>> function) {
        return this.content((AbstractElement<?> e) -> e.hasClass(className), function, () -> Basic.div().classes(className));
    }

    public SELF content(Predicate<AbstractElement<?>> predicate, Function<AbstractElement<?>, AbstractElement<?>> function, Supplier<AbstractElement<?>> generator) {
        Optional<AbstractElement<?>> element = this.findElement(predicate);
        element.ifPresentOrElse(function::apply, () -> this.content((Renderable)function.apply((AbstractElement)generator.get())));
        return this.self();
    }

    public <T extends AbstractElement<?>> T getOrCreate(String className) {
        return (T)this.getOrCreate(className, Basic::div);
    }

    public <T extends AbstractElement<?>> T getOrCreate(String className, Supplier<T> generator) {
        return (T)this.getOrCreate((AbstractElement<?> e) -> e.hasClass(className), () -> ((AbstractElement)generator.get()).classes(className));
    }

    public <T extends AbstractElement<?>> T getOrCreate(Predicate<AbstractElement<?>> predicate, Supplier<T> generator) {
        return (T)this.findElement(predicate).orElseGet(() -> {
            AbstractElement generated = (AbstractElement)generator.get();
            this.content((Renderable)generated);
            return generated;
        });
    }

    public Optional<AbstractElement<?>> findElement(String className) {
        return this.findElement((AbstractElement<?> e) -> e.hasClass(className));
    }

    public Optional<AbstractElement<?>> findElement(Predicate<AbstractElement<?>> predicate) {
        return this.content() == null ? Optional.empty() : this.content().find((Renderable renderable) -> {
            AbstractElement e;
            return renderable instanceof AbstractElement && predicate.test(e = (AbstractElement)renderable);
        }).map((? super T obj) -> (AbstractElement)obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractElement)) return false;
        AbstractElement that = (AbstractElement)obj;
        if (!this.render().equals(that.render())) return false;
        return true;
    }

    @Override
    public void render(Renderer renderer) {
        if (this.rendersOnSeparateLines) {
            renderer.appendIndent();
        }
        renderer.unsafeAppend("<").safeAppend(this.name);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            renderer.unsafeAppend(" ");
            this.attributes.render(renderer);
        }
        renderer.unsafeAppend(">");
        if (this.content != null) {
            if (this.content.rendersOnSeparateLines()) {
                renderer.nl().in();
            }
            this.content.render(renderer);
            if (this.content.rendersOnSeparateLines()) {
                renderer.out();
                if (this.close) {
                    renderer.appendIndent();
                }
            }
        }
        if (this.close) {
            renderer.unsafeAppend("</").safeAppend(this.name).unsafeAppend(">");
        }
        if (this.rendersOnSeparateLines) {
            renderer.nl();
        }
    }

    @Generated
    protected AbstractElement(AbstractElementBuilder<SELF, ?, ?> b) {
        this.close = b.close;
        this.rendersOnSeparateLines = b.rendersOnSeparateLines;
        this.name = b.name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.attributes = b.attributes;
        this.content = b.content;
        this.mapFunction = b.mapFunction;
        if (this.mapFunction == null) {
            throw new NullPointerException("mapFunction is marked non-null but is null");
        }
    }

    @Generated
    public static <SELF extends AbstractElement<?>> AbstractElementBuilder<SELF, ?, ?> builder() {
        return new AbstractElementBuilderImpl();
    }

    @Generated
    public AbstractElementBuilder<SELF, ?, ?> toBuilder() {
        return new AbstractElementBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean rendersOnSeparateLines() {
        return this.rendersOnSeparateLines;
    }

    @NonNull
    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public Attributes attributes() {
        return this.attributes;
    }

    @Generated
    public static abstract class AbstractElementBuilder<SELF extends AbstractElement<?>, C extends AbstractElement<SELF>, B extends AbstractElementBuilder<SELF, C, B>> {
        @Generated
        private boolean close;
        @Generated
        private boolean rendersOnSeparateLines;
        @Generated
        private String name;
        @Generated
        private Attributes attributes;
        @Generated
        private Renderable content;
        @Generated
        private Function<Renderable, Renderable> mapFunction;

        @Generated
        protected B $fillValuesFrom(C instance) {
            AbstractElementBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static <SELF extends AbstractElement<?>> void $fillValuesFromInstanceIntoBuilder(AbstractElement<SELF> instance, AbstractElementBuilder<SELF, ?, ?> b) {
            b.close(instance.close);
            b.rendersOnSeparateLines(instance.rendersOnSeparateLines);
            b.name(instance.name);
            b.attributes(instance.attributes);
            b.content(instance.content);
            b.mapFunction(instance.mapFunction);
        }

        @Generated
        public B close(boolean close) {
            this.close = close;
            return this.self();
        }

        @Generated
        public B rendersOnSeparateLines(boolean rendersOnSeparateLines) {
            this.rendersOnSeparateLines = rendersOnSeparateLines;
            return this.self();
        }

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this.self();
        }

        @Generated
        public B attributes(Attributes attributes) {
            this.attributes = attributes;
            return this.self();
        }

        @Generated
        public B content(Renderable content) {
            this.content = content;
            return this.self();
        }

        @Generated
        public B mapFunction(@NonNull Function<Renderable, Renderable> mapFunction) {
            if (mapFunction == null) {
                throw new NullPointerException("mapFunction is marked non-null but is null");
            }
            this.mapFunction = mapFunction;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractElement.AbstractElementBuilder(close=" + this.close + ", rendersOnSeparateLines=" + this.rendersOnSeparateLines + ", name=" + this.name + ", attributes=" + String.valueOf(this.attributes) + ", content=" + String.valueOf(this.content) + ", mapFunction=" + String.valueOf(this.mapFunction) + ")";
        }
    }

    @Generated
    private static final class AbstractElementBuilderImpl<SELF extends AbstractElement<?>>
    extends AbstractElementBuilder<SELF, AbstractElement<SELF>, AbstractElementBuilderImpl<SELF>> {
        @Generated
        private AbstractElementBuilderImpl() {
        }

        @Override
        @Generated
        protected AbstractElementBuilderImpl<SELF> self() {
            return this;
        }

        @Override
        @Generated
        public AbstractElement<SELF> build() {
            return new AbstractElement(this);
        }
    }
}

