/*
 * Decompiled with CFR 0.152.
 */
package com.github.t1.bulmajava.basic;

import com.github.t1.bulmajava.basic.Renderable;
import com.github.t1.bulmajava.basic.Renderer;
import java.util.Comparator;
import lombok.NonNull;

public interface Attribute
extends Renderable {
    public static final Comparator<String> KEY_COMPARATOR = (left, right) -> {
        if (left.equals(right)) {
            return 0;
        }
        return switch (left) {
            case "id" -> -1;
            case "class" -> {
                if (right.equals("id")) {
                    yield 1;
                }
                yield -1;
            }
            case "rel" -> {
                if (right.equals("id") || right.equals("class")) {
                    yield 1;
                }
                yield -1;
            }
            case "href" -> {
                if (right.equals("id") || right.equals("class") || right.equals("rel")) {
                    yield 1;
                }
                yield -1;
            }
            default -> 0;
        };
    };
    public static final Comparator<Attribute> COMPARATOR = (left, right) -> KEY_COMPARATOR.compare(left.key(), right.key());

    public static Attribute of(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return new NoValueAttribute(key);
    }

    public static Attribute of(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new StringAttribute(key, value, false);
    }

    public String key();

    default public boolean hasKey(String expected) {
        return this.key().equals(expected);
    }

    public boolean matches(Attribute var1);

    @Override
    default public void render(Renderer renderer) {
        renderer.unsafeAppend(this.key()).unsafeAppend("=\"");
        this.renderValue(renderer);
        renderer.unsafeAppend("\"");
    }

    public void renderValue(Renderer var1);

    default public Attribute and(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    public record NoValueAttribute(String key) implements Attribute
    {
        @Override
        public boolean matches(Attribute attribute) {
            return attribute.hasKey(attribute.key());
        }

        @Override
        public void render(Renderer renderer) {
            renderer.unsafeAppend(this.key());
        }

        @Override
        public void renderValue(Renderer renderer) {
        }
    }

    public record StringAttribute(String key, String value, boolean unsafe) implements Attribute
    {
        public static Attribute unsafeStringAttribute(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return new StringAttribute(key, value, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(Attribute attribute) {
            if (!this.hasKey(attribute.key())) return false;
            if (!(attribute instanceof StringAttribute)) return false;
            StringAttribute str = (StringAttribute)attribute;
            if (!this.value.equals(str.value)) return false;
            return true;
        }

        @Override
        public Attribute and(Attribute attribute) {
            if ("style".equals(this.key())) {
                return Attribute.of(this.key, this.value + " " + ((StringAttribute)attribute).value);
            }
            throw new UnsupportedOperationException("can't add to a '" + this.key() + "' attribute");
        }

        @Override
        public void renderValue(Renderer renderer) {
            if (this.unsafe) {
                renderer.unsafeAppend(this.value);
            } else {
                renderer.safeAppend(this.value);
            }
        }
    }
}

